/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import org.apache.log4j.Logger;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarException;

public class CheckRam
extends AbstractJobConditionValidator {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final Logger logger = Logger.getLogger(CheckRam.class);

    public boolean checkCondition(JobCondition jobCondition) {
        try {
            return jobCondition.isConditionChoice() ? this.isAvailableRamSpace(jobCondition) : !this.isAvailableRamSpace(jobCondition);
        }
        catch (SigarException sigarException) {
            logger.debug((Object)"SigarException from isAvailableRamSpace() method", (Throwable)sigarException);
            sigarException.printStackTrace();
            return false;
        }
    }

    private boolean isAvailableRamSpace(JobCondition jobCondition) throws SigarException {
        return this.getRamFreeSpaceWithUnit(jobCondition) >= (long)jobCondition.getConditionVar2();
    }

    private long getRamFreeSpaceWithUnit(JobCondition jobCondition) throws SigarException {
        switch (jobCondition.getConditionVar1()) {
            case 1: {
                return this.getRamFreeSpace() / 1024L;
            }
            case 2: {
                return this.getRamFreeSpace() / 0x100000L;
            }
            case 3: {
                return this.getRamFreeSpace() / 0x40000000L;
            }
            case 4: {
                return this.getRamFreeSpace() / 0x10000000000L;
            }
        }
        throw new IllegalArgumentException("job Condition Var type is not valid: " + jobCondition.getConditionVar1());
    }

    private long getRamFreeSpace() throws SigarException {
        Mem mem = this.getSigarObject().getMem();
        return mem.getFree();
    }

    public String toString(JobCondition jobCondition) {
        return "Checking RAM.";
    }
}

