/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import org.apache.log4j.Logger;

public class CheckProcess
extends AbstractJobConditionValidator {
    private static final Logger logger = Logger.getLogger(CheckProcess.class);
    private static final int BEGINS_WITH = 1;
    private static final int CONTAINS = 2;
    private static final int ENDS_WITH = 3;
    private static final int USER_NAME_CONTAINS = 0;
    private static final int USER_NAME_BEGINS_WITH = 1;
    private static final int USER_NAME_IS_EQUAL = 2;
    private static final int USER_NAME_IS_NOT_EQUAL = 3;

    public boolean checkCondition(JobCondition jobCondition) {
        try {
            return jobCondition.isConditionChoice() ? this.isProcessRunning(jobCondition) : !this.isProcessRunning(jobCondition);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error occurred while checking a Process.", (Throwable)resourceUnavailableException);
            return false;
        }
    }

    private boolean isUserNameConditionExists(String string, JobCondition jobCondition) throws ResourceUnavailableException {
        String string2 = string.toLowerCase().trim();
        String string3 = "";
        string3 = jobCondition.getConditionData1();
        string3 = string3 != null ? string3.trim().toLowerCase() : "";
        if (string3.equals("")) {
            return true;
        }
        switch (jobCondition.getConditionVar2()) {
            case 0: {
                if (!this.contains(string2, string3)) break;
                logger.trace((Object)("Found" + string + "contains" + string3 + ""));
                return true;
            }
            case 1: {
                if (!this.beginsWith(string2, string3)) break;
                logger.trace((Object)("Found " + string2 + " begins with " + string3 + ""));
                return true;
            }
            case 2: {
                if (!this.isEqualToString(string2, string3)) break;
                logger.trace((Object)("Found " + string2 + "equals " + string3 + ""));
                return true;
            }
            case 3: {
                if (this.isEqualToString(string2, string3)) break;
                logger.trace((Object)("Didn Not Found " + string2 + "" + string3 + ""));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessRunning(JobCondition jobCondition) throws ResourceUnavailableException {
        ActiveProcessAM activeProcessAM = (ActiveProcessAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.getAgentPeerID(), (String)"COMMON.ActiveProcessAM");
        DataSet dataSet = null;
        try {
            dataSet = activeProcessAM.getDataSet(null, null, null);
            BasicProcessInfo[] basicProcessInfoArray = dataSet.size() == 0 ? new BasicProcessInfo[]{} : (BasicProcessInfo[])ArrayDataSet.toArray((DataSet)dataSet, (boolean)false);
            String string = "";
            String string2 = "";
            String string3 = "";
            string = jobCondition.getConditionData();
            string = string != null ? string.trim().toLowerCase() : "";
            if (string.equals("")) {
                boolean object;
                boolean bl = false;
                for (BasicProcessInfo bl2 : basicProcessInfoArray) {
                    String string4 = bl2.getUser();
                    object = this.isUserNameConditionExists(string4, jobCondition);
                }
                void var9_18 = object;
                return (boolean)var9_18;
            }
            block33: for (BasicProcessInfo basicProcessInfo : basicProcessInfoArray) {
                string2 = basicProcessInfo.getCommand().trim().toLowerCase();
                string3 = basicProcessInfo.getUser();
                string2 = string2.replace("\"", "");
                switch (jobCondition.getConditionVar1()) {
                    case 1: {
                        if (!this.beginsWith(string2, string)) continue block33;
                        logger.trace((Object)("Found " + string2 + " begins with " + string + ""));
                        System.out.println("PROCESS NAME + + + + " + string);
                        if (!this.isUserNameConditionExists(string3, jobCondition)) continue block33;
                        boolean bl = true;
                        return bl;
                    }
                    case 2: {
                        if (!this.contains(string2, string)) continue block33;
                        logger.trace((Object)("Found " + string2 + " contains " + string + ""));
                        if (!this.isUserNameConditionExists(string3, jobCondition)) continue block33;
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        if (!this.endsWith(string2, string)) continue block33;
                        logger.trace((Object)("Found " + string2 + " ends with " + string + ""));
                        if (!this.isUserNameConditionExists(string3, jobCondition)) continue block33;
                        boolean bl = true;
                        return bl;
                    }
                    default: {
                        throw new IllegalArgumentException("job Condition Var type is not valid: " + jobCondition.getConditionVar1());
                    }
                }
            }
            String string5 = this.getTypeToFindMessage("Failed to find a process that ", jobCondition.getConditionVar1(), string);
            logger.trace((Object)string5);
        }
        catch (DataSetException dataSetException) {
            logger.error((Object)"Error getting Process list. ", (Throwable)dataSetException);
        }
        catch (BadDataException badDataException) {
            logger.error((Object)"Error getting Process list. ", (Throwable)badDataException);
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (DataSetException dataSetException) {
                    logger.error((Object)"Error closing dataset. ", (Throwable)dataSetException);
                }
            }
        }
        return false;
    }

    private String getTypeToFindMessage(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        switch (n) {
            case 1: {
                stringBuffer.append("begins with");
                break;
            }
            case 2: {
                stringBuffer.append("contains");
                break;
            }
            case 3: {
                stringBuffer.append("ends with");
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    private boolean beginsWith(String string, String string2) {
        logger.trace((Object)("Checking if " + string + " begins with " + string2));
        return string.startsWith(string2);
    }

    private boolean contains(String string, String string2) {
        return string.contains(string2);
    }

    private boolean endsWith(String string, String string2) {
        return string.endsWith(string2);
    }

    private boolean isEqualToString(String string, String string2) {
        logger.trace((Object)("Checking if" + string + "equals to" + string2 + ""));
        return string.equals(string2);
    }

    public String toString(JobCondition jobCondition) {
        String string = "Checking for Process that ";
        return this.getTypeToFindMessage(string, jobCondition.getConditionVar1(), jobCondition.getConditionData());
    }
}

