/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.ReadInputThread;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ServicePeerMonitor
implements Runnable,
InterruptibleProcess {
    private static Logger logger = Logger.getLogger(ServicePeerMonitor.class);
    public static final String SERVICE_NAME = "Service Peer Monitor";
    public static final String THREAD_NAME = "Service Peer Monitor Thread";
    public static final String EXECUTABLE_WINDOWS_NAME = "Automate Schedule Server Process.exe";
    public static final String EXECUTABLE_NON_WINDOWS_NAME = "start_service.sh";
    private static final int NORMAL_CHECK_TIME = 10000;
    private static final int STARTUP_TIME = 30000;
    AgentPeer serverPeer = null;
    boolean isShutdown = false;
    boolean isWindows = false;
    int serverport = 0;
    int port = -1234;
    private Process process;

    public ServicePeerMonitor(AgentPeer agentPeer, boolean bl, int n) {
        this.serverPeer = agentPeer;
        this.isWindows = bl;
        this.serverport = n;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.endProcess();
    }

    @Override
    public void run() {
        int n = 30000;
        this.isShutdown = false;
        logger.debug((Object)"About to initialize Service Peers...");
        while (!this.isShutdown) {
            try {
                try {
                    Thread.sleep(n);
                    n = 10000;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.serverPeer == null || this.serverPeer.isShutdownRequested() || !this.serverPeer.isStartupComplete() || !this.serverPeer.isReadyForConnections()) continue;
                try {
                    if (this.serverPeer.getConnectedServicePeers().length != 0) continue;
                    this.startServicePeer();
                }
                catch (Throwable throwable) {
                    logger.error((Object)"Unable to start theService Peer Monitor.", throwable);
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Service Peer Monitor logged the following error.", throwable);
            }
        }
    }

    private void startServicePeer() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        if (this.isWindows) {
            stringBuffer.append("cmd.exe /c \"");
            arrayList.add("cmd.exe");
            arrayList.add("/c");
            string2 = string2 + "\"";
        }
        String string3 = System.getProperty("user.dir") + File.separatorChar;
        stringBuffer.append(string3);
        if (this.isWindows) {
            stringBuffer.append(EXECUTABLE_WINDOWS_NAME);
            stringBuffer.append("\"");
            string2 = string2 + EXECUTABLE_WINDOWS_NAME;
            string2 = string2 + "\"";
            arrayList.add(string2);
        } else {
            stringBuffer.append(EXECUTABLE_NON_WINDOWS_NAME);
            string = string + EXECUTABLE_NON_WINDOWS_NAME;
            arrayList.add(string);
        }
        stringBuffer.append(" ");
        String string4 = this.serverport + ":" + this.port + ":" + "com.helpsystems.enterprise.peer.SAPEventMonitorProcess";
        stringBuffer.append(string4);
        arrayList.add(string4);
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"About to start Service Peer Monitor...");
                logger.trace((Object)stringBuffer);
            }
            Process process = Runtime.getRuntime().exec(arrayList.toArray(stringArray));
            ReadInputThread readInputThread = new ReadInputThread(process.getInputStream(), Level.DEBUG, "Console message from service peer: ", process);
            readInputThread.setName("ReadInputThread_ConsoleLog");
            readInputThread.start();
            ReadInputThread readInputThread2 = new ReadInputThread(process.getErrorStream(), Level.ERROR, "Console error from service peer: ", process);
            readInputThread2.setName("ReadInputThread_ErrorLog");
            readInputThread2.start();
        }
        catch (Throwable throwable) {
            logger.error((Object)"The Enterprise Server Driver could not start the Service Peer Monitor.", throwable);
        }
    }

    public void interrupt() {
        this.isShutdown = true;
        this.endProcess();
    }

    private void endProcess() {
        if (this.process != null) {
            try {
                logger.debug((Object)"Ending service peer monitor processor...");
                this.process.destroy();
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error occured ending service peer monitor processor.", throwable);
            }
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        return this.isShutdown;
    }
}

