/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.EnterpriseService;
import com.helpsystems.enterprise.core.busobj.ServicePeerDefinition;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.dm.ReportSubmitterAM;
import com.helpsystems.enterprise.core.dm.ReportsProcessorAM;
import com.helpsystems.enterprise.core.reports.Report;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import com.helpsystems.enterprise.core.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

class ReportRunner
implements InterruptibleProcess,
EnterpriseService {
    private static final long serialVersionUID = 3577570090558761303L;
    private static Logger logger = Logger.getLogger(ReportRunner.class);
    private static final String SERVICE_NAME = "Report Runner";
    public static final String THREAD_NAME = "Report Runner thread";
    private boolean isShutdown = false;
    private ReportsProcessorAM reportProcessorAM = null;
    private PeerID serverPeerID = null;
    private String dqName;
    private ReportCommand currentCommand = null;
    private long numberReportsProcessed = 0L;
    private static ReportRunner singleton = null;
    private static DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();

    public ReportRunner() {
        ReportRunner.getInstance();
    }

    private ReportRunner(int n) {
        this.numberReportsProcessed = 0L;
    }

    public static ReportRunner getInstance() {
        if (singleton == null) {
            singleton = new ReportRunner(1);
        }
        return singleton;
    }

    public void setServicePort(int n) {
    }

    public int getServicePort() {
        return -1235;
    }

    public void registerServiceToServerPeer(PeerID peerID) {
        this.serverPeerID = peerID;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public String getServiceLogFileName() {
        return OutputDistributionSetup.REPORT_RUNNER_LOG_FILE_NAME;
    }

    public String getServiceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFullServiceInfo());
        return stringBuffer.toString();
    }

    private String getFullServiceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getListing());
        return stringBuffer.toString();
    }

    private Object getListing() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<H2>Report Queue:</h2>");
        ArrayList arrayList = new ArrayList();
        try {
            arrayList = this.getDQ().listQueue();
        }
        catch (IOException iOException) {
            stringBuffer.append("<BR>");
            stringBuffer.append("Unable to retrieve Report Queue listing.");
            stringBuffer.append(iOException.getStackTrace());
            return stringBuffer.toString();
        }
        stringBuffer.append("<table border=2 CELLPADDING=4><tr>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Report Name</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Run as user</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Date Submitted</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Output Type</th></tr>");
        if (arrayList.isEmpty()) {
            stringBuffer.append("<tr><td COLSPAN=4 align=\"center\">");
            stringBuffer.append("No reports queued.");
            stringBuffer.append("</td><tr></table>");
            return stringBuffer.toString();
        }
        for (Serializable serializable : arrayList) {
            ReportCommand reportCommand = (ReportCommand)serializable;
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append(StringUtilities.getHumanizedText((String)reportCommand.getReportName()));
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(reportCommand.getRunAsUserName());
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(new Date(reportCommand.getRequestTimestamp()).toString());
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(reportCommand.getOutputType().toString());
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String getDataQueueFileName() {
        if (this.dqName == null) {
            File file = null;
            try {
                file = new File(OutputDistributionSetup.getReportQueueName());
                this.dqName = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Unable to get the actual path to the report data queue.", (Throwable)iOException);
                System.exit(1);
            }
        }
        return this.dqName;
    }

    private ReportsProcessorAM getAM() {
        if (this.reportProcessorAM == null) {
            this.reportProcessorAM = (ReportsProcessorAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportsProcessorAM");
        }
        return this.reportProcessorAM;
    }

    public void startService() {
        this.startThread();
    }

    private Thread startThread() {
        Thread thread = new Thread(new ReportProcessor());
        thread.setName("ReportRunner Thread");
        thread.setDaemon(true);
        System.out.println("Starting thread: " + thread.getName());
        thread.start();
        return thread;
    }

    private DurableQueue getDQ() {
        try {
            return new DurableQueue(this.getDataQueueFileName());
        }
        catch (IOException iOException) {
            logger.error((Object)"Unable connect to the Report Queue.", (Throwable)iOException);
            System.exit(1);
            return null;
        }
    }

    public void interrupt() {
        this.isShutdown = true;
        try {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        return this.isShutdown;
    }

    private static String getFormattedNumber(long l) {
        df.applyPattern("###,###,###,###,###,###");
        return df.format(l);
    }

    public boolean getLocalService() {
        return true;
    }

    public String getServiceStatistics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr><td><b>Number Reports processed:</b></td><td>");
        if (this.numberReportsProcessed == 0L) {
            stringBuffer.append("None");
        } else {
            stringBuffer.append(ReportRunner.getFormattedNumber(this.numberReportsProcessed));
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td><b>Processing Report: </b></td><td>");
        if (this.currentCommand == null) {
            stringBuffer.append("None");
        } else {
            stringBuffer.append(StringUtilities.getHumanizedText((String)this.currentCommand.getReportName()));
        }
        stringBuffer.append("</td></tr>");
        return stringBuffer.toString();
    }

    public static ServicePeerDefinition getServicePeerDefinition() {
        String[] stringArray = new String[]{};
        ServicePeerDefinition servicePeerDefinition = new ServicePeerDefinition();
        servicePeerDefinition.setName(SERVICE_NAME);
        servicePeerDefinition.setDescription("The Report Runner Service.");
        servicePeerDefinition.setClassName("com.helpsystems.enterprise.peer.ReportRunner");
        servicePeerDefinition.setPortNumber(-1235);
        servicePeerDefinition.setArguments(stringArray);
        return servicePeerDefinition;
    }

    class ReportProcessor
    implements Runnable {
        Report report = null;

        ReportProcessor() {
        }

        public int processReport() {
            String string = null;
            if (this.dataQueueHasData()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Looking for next report...");
                }
                try {
                    ReportRunner.this.currentCommand = this.getReport();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Interrupted waiting for reports.", (Throwable)exception);
                }
                if (ReportRunner.this.currentCommand != null) {
                    this.report = null;
                    try {
                        string = "Starting to process ReportCommand.";
                        logger.info((Object)string);
                        string = "Processing ReportCommand: " + ReportRunner.this.currentCommand.toString();
                        System.out.println(string);
                        logger.debug((Object)string);
                        this.report = ReportRunner.this.getAM().generateReport(ReportRunner.this.currentCommand.getReportID(), ReportRunner.this.currentCommand.getOutputType(), ReportRunner.this.currentCommand.getRunAsUserName(), ReportRunner.this.currentCommand.getUserFileRecordId(), ReportRunner.this.currentCommand.getParams());
                        if (this.report != null) {
                            string = "Finished processing Report.  Report output to: " + this.report.getReportOuputLocation();
                            System.out.println(string);
                            logger.info((Object)string);
                            ReportRunner.this.numberReportsProcessed++;
                            return 0;
                        }
                        string = "Unable to process Report.  Report " + ReportRunner.this.currentCommand.toString() + " cannot be established.";
                        System.out.println(string);
                        logger.info((Object)string);
                        return 1;
                    }
                    catch (ReportException reportException) {
                        string = "Problem with generating report...";
                        System.out.println(string);
                        logger.error((Object)string, (Throwable)reportException);
                        return 1;
                    }
                    catch (Throwable throwable) {
                        string = "Problem with generating report ";
                        System.out.println(string);
                        logger.error((Object)string, throwable);
                        return 1;
                    }
                }
                string = "No reports to process.  Exiting...";
                System.out.println(string);
                logger.debug((Object)string);
                ReportRunner.this.currentCommand = null;
                return 0;
            }
            string = "No reports to process.  Exiting...";
            System.out.println(string);
            logger.debug((Object)string);
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean dataQueueHasData() {
            DurableQueue durableQueue = ReportRunner.this.getDQ();
            if (durableQueue == null) {
                logger.debug((Object)"Unable to check if ReportQueueu has reports.");
                return false;
            }
            DurableQueue durableQueue2 = durableQueue;
            synchronized (durableQueue2) {
                boolean bl = durableQueue.isEmpty();
                try {
                    durableQueue.close();
                }
                catch (IOException iOException) {
                    logger.debug((Object)"Unable to close DataQueue.", (Throwable)iOException);
                }
                return !bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReportCommand getReport() throws IOException {
            DurableQueue durableQueue;
            DurableQueue durableQueue2 = durableQueue = ReportRunner.this.getDQ();
            synchronized (durableQueue2) {
                ReportCommand reportCommand = (ReportCommand)durableQueue.pop();
                durableQueue.close();
                return reportCommand;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 0;
            try {
                Object object = ReportSubmitterAM.ReportQueue;
                synchronized (object) {
                    n = this.processReport();
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"Report Runner has encounted an error running the report.", throwable);
                n = 1;
            }
            if (this.report == null) {
                System.exit(n);
            } else {
                while (!this.report.isSystemExit()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.exit(n);
                    }
                }
            }
            System.exit(n);
        }
    }
}

