/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.common.tl.ex.PeerInitialConnectException;
import com.helpsystems.common.tl.ex.SocketInUseException;
import com.helpsystems.common.tl.ex.SocketStartupException;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommandReply;
import com.helpsystems.enterprise.core.cmdlineobj.AgentJobInfo;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferInfo;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityData;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusData;
import com.helpsystems.enterprise.core.cmdlineobj.ImportCronCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableValue;
import com.helpsystems.enterprise.core.dm.AgentConfigAM;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.peer.ImportCronCommandProcessor;
import com.helpsystems.enterprise.peer.LocalAgentAM;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.w3c.dom.Document;

public class AgentControl {
    private static final int COMMAND_OK = 0;
    private static final int COMMAND_FAILED = 1;
    private static final int NO_FILENAME_SPECIFIED = 101;
    private static final int UNABLE_TO_LOAD_CONFIG = 102;
    private static final int COMMAND_NOT_SUCCESSFUL = 103;
    private static final int NEED_MORE_ARGS = 104;
    private static final int UNABLE_TO_CONNECT = 105;
    private static final int INVALID_SERVER_ARG = 106;
    private static final int PORT_IN_USE = 107;
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String RESTART = "restart";
    public static final String DIAG = "diag";
    public static final String FIREEVENT = "fireevent";
    public static final String NOW = "now";
    public static final String VERBOSE = "verbose";
    public static final String SWITCH = "switch";
    public static final String SENDMSG = "SENDMSG";
    public static final String GETACTIVITY = "GETACTIVITY";
    public static final String ROVAR = "ROVAR";
    public static final String GETAGTSTS = "GETSTATUS";
    public static final String IMPORT_CRON = "IMPORTCRON";
    public static final String REPORT = "REPORT";
    static boolean verbose = false;
    static String consoleEncoding = System.getProperty("helpsystems.console.encoding");
    static PrintStream encodedConsoleOut;
    static PrintStream encodedConsoleErr;

    private AgentControl() {
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String object3 = null;
        AgentPeerConfig agentPeerConfig = null;
        int n = 103;
        if (stringArray == null || stringArray.length == 0) {
            encodedConsoleOut.println("Please specify the command and config file");
            return;
        }
        String string = null;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String exception : stringArray) {
            if (string == null && exception.equalsIgnoreCase(VERBOSE) || exception.equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (FIREEVENT.equalsIgnoreCase(string) || SWITCH.equalsIgnoreCase(string) || SENDMSG.equalsIgnoreCase(string) || GETACTIVITY.equalsIgnoreCase(string) || ROVAR.equalsIgnoreCase(string) || GETAGTSTS.equalsIgnoreCase(string) || IMPORT_CRON.equalsIgnoreCase(string) || AgentControl.isReport(string)) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(exception);
                arrayList.add(exception);
                continue;
            }
            if (START.equalsIgnoreCase(exception)) {
                string = START;
                continue;
            }
            if (STOP.equalsIgnoreCase(exception)) {
                string = STOP;
                continue;
            }
            if (RESTART.equalsIgnoreCase(exception)) {
                string = RESTART;
                continue;
            }
            if (DIAG.equalsIgnoreCase(exception)) {
                string = DIAG;
                continue;
            }
            if (FIREEVENT.equalsIgnoreCase(exception)) {
                string = FIREEVENT;
                continue;
            }
            if (NOW.equalsIgnoreCase(exception)) {
                bl = true;
                continue;
            }
            if (SWITCH.equalsIgnoreCase(exception)) {
                string = SWITCH;
                continue;
            }
            if (SENDMSG.equalsIgnoreCase(exception)) {
                string = SENDMSG;
                n = 1;
                continue;
            }
            if (GETACTIVITY.equalsIgnoreCase(exception)) {
                string = GETACTIVITY;
                n = 1;
                continue;
            }
            if (GETAGTSTS.equalsIgnoreCase(exception)) {
                string = GETAGTSTS;
                continue;
            }
            if (ROVAR.equalsIgnoreCase(exception)) {
                string = ROVAR;
                n = 1;
                continue;
            }
            if (IMPORT_CRON.equalsIgnoreCase(exception)) {
                string = IMPORT_CRON;
                continue;
            }
            if (AgentControl.isReport(exception)) {
                string = REPORT;
                continue;
            }
            object3 = exception;
            object2 = new File(object3);
            if (AgentControl.isWindows() && !((File)object2).exists()) {
                object3 = DefaultConfigPath.getDefaultPath() + File.separator + object3;
                object2 = new File(object3);
            }
            if (!((File)object2).exists()) {
                AgentControl.finished("The file " + ((File)object2).getAbsolutePath() + " does not exist.", null, 102);
            }
            if (((File)object2).isDirectory()) {
                AgentControl.finished("The filename " + ((File)object2).getAbsolutePath() + " is a directory.", null, 102);
            }
            try {
                object = XMLUtil.loadXML((String)((File)object2).getAbsolutePath());
                agentPeerConfig = (AgentPeerConfig)((Object)XMLReflector.readObject((Document)object));
            }
            catch (Exception exception2) {
                verbose = true;
                AgentControl.finished("Unable to load the configuration file: " + object3, exception2, 102);
            }
        }
        if (agentPeerConfig == null) {
            AgentControl.finished("Please specify the config filename.", null, 101);
        }
        if (string == null) {
            AgentControl.finished("Please specify whether to start or stop the process.", null, 104);
        }
        if (START.equals(string)) {
            AgentControl.start(agentPeerConfig, object3);
        } else {
            Object var8_9 = null;
            if (STOP.equals(string) || RESTART.equals(string)) {
                String string2 = object3 + ".passphrase";
                try {
                    String string3 = AgentControl.loadPassphrase(string2);
                }
                catch (Exception exception) {
                    AgentControl.finished("Unable to read the shutdown passphrase from " + string2, exception, 102);
                }
            }
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} [%c] %t> %m\n"), "System.out"));
            Logger.getRootLogger().setLevel(Level.WARN);
            Log4jInit.setInitialized((boolean)true);
            PeerID peerID = null;
            SimplePeer simplePeer = null;
            try {
                simplePeer = SimplePeer.createAnInstance();
                PeerDescriptor peerDescriptor = new PeerDescriptor("localhost", agentPeerConfig.getListenPort(), 4, "Unknown");
                peerID = simplePeer.connectToPeer(peerDescriptor, (Serializable)((Object)new NotificationCredentials()));
                ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)simplePeer));
            }
            catch (Exception exception) {
                if (GETAGTSTS.equalsIgnoreCase(string) && exception instanceof PeerInitialConnectException) {
                    object2 = agentPeerConfig.getMaster().findName();
                    object = agentPeerConfig.getMaster().findIPAddress();
                    AgentControl.finished("Local agent listening on port " + agentPeerConfig.getListenPort() + " connecting to " + (String)object2 + " (" + (String)object + ") is inactive.", null, 30);
                }
                AgentControl.finished("Unable to connect to the local Agent on port " + agentPeerConfig.getListenPort(), exception, 105);
            }
            try {
                if (STOP.equals(string) || RESTART.equals(string)) {
                    void var8_11;
                    AgentControl.doStopOrRestart(simplePeer, peerID, string, bl, (String)var8_11);
                } else if (DIAG.equals(string)) {
                    AgentControl.doDiag(peerID);
                } else if (FIREEVENT.equals(string)) {
                    AgentControl.doFireEvent(peerID, stringBuilder.toString());
                } else if (SWITCH.equals(string)) {
                    AgentControl.doSwitch(peerID, stringBuilder.toString());
                } else if (SENDMSG.equals(string) || GETACTIVITY.equals(string) || GETAGTSTS.equals(string) || ROVAR.equals(string) || IMPORT_CRON.equals(string) || REPORT.equals(string)) {
                    String[] stringArray3 = new String[]{};
                    stringArray3 = arrayList.toArray(stringArray3);
                    AgentControl.doAgentCommand(string, peerID, stringArray3);
                }
            }
            catch (ActionFailedException actionFailedException) {
                AgentControl.finished("Command not successful: " + actionFailedException.getMessage(), (Exception)((Object)actionFailedException), n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AgentControl.finished("Unable to send command to agent.", exception, n);
            }
            System.exit(0);
        }
    }

    private static boolean isReport(String string) {
        if (string == null) {
            return false;
        }
        return REPORT.toUpperCase().endsWith(string.toUpperCase());
    }

    private static AgentPeer start(AgentPeerConfig agentPeerConfig, String string) {
        verbose = true;
        AgentPeer agentPeer = null;
        try {
            agentPeer = AgentPeer.createAgent(agentPeerConfig, string);
        }
        catch (Exception exception) {
            int n = 103;
            String string2 = "Agent";
            if (agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.SERVER) {
                string2 = "Enterprise Server";
            }
            if (agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.STANDBY) {
                string2 = "Enterprise Standby Server";
            }
            if (exception instanceof SocketStartupException && exception.getCause() instanceof BindException) {
                n = 107;
            } else if (exception instanceof SocketInUseException) {
                n = 107;
            }
            AgentControl.finished("Unable to start the " + string2 + ".", exception, n);
        }
        return agentPeer;
    }

    private static void doStopOrRestart(SimplePeer simplePeer, final PeerID peerID, String string, boolean bl, String string2) throws Exception {
        PeerEventListener peerEventListener = new PeerEventListener(){

            protected void peerConnected(PeerID peerID3, PeerID peerID2) {
            }

            protected void peerDisconnected(PeerID peerID3, PeerID peerID2) {
                if (peerID3.equals((Object)peerID)) {
                    AgentControl.finished("The Agent has shutdown.", null, 0);
                }
            }
        };
        LocalAgentAM localAgentAM = (LocalAgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.LocalAgentAM");
        boolean bl2 = RESTART.equalsIgnoreCase(string);
        boolean bl3 = !bl;
        simplePeer.addListener((SimpleEventListener)peerEventListener);
        String string3 = localAgentAM.shutdown(bl3, bl2, string2);
        AgentControl.finished(string3, null, 0);
    }

    private static void doDiag(PeerID peerID) throws Exception {
        LocalAgentAM localAgentAM = (LocalAgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.LocalAgentAM");
        String string = localAgentAM.saveDiagnostics();
        AgentControl.finished("OK:" + string, null, 0);
    }

    private static void doFireEvent(PeerID peerID, String string) throws Exception {
        LocalAgentAM localAgentAM = (LocalAgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.LocalAgentAM");
        String string2 = localAgentAM.fireManualEvent(string);
        AgentControl.finished("OK:" + string2, null, 0);
    }

    private static void doAgentCommand(String string, PeerID peerID, String[] stringArray) throws ResourceUnavailableException, ActionFailedException, IOException {
        ImportCronCommandProcessor importCronCommandProcessor;
        Object object;
        AgentCommand agentCommand = AgentCommand.loadAgentCommand((String)string);
        agentCommand.setInitiatingAgent(peerID);
        if (peerID.getPeerDescriptor() != null && (object = peerID.getPeerDescriptor().getComputerName()) != null) {
            agentCommand.setAgentName(((String)object).trim());
        }
        object = (LocalAgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.LocalAgentAM");
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.TranslationDM");
        ManagerRegistry.registerManager((IAbstractManager)translationDM);
        agentCommand.parseParameters(stringArray);
        if (agentCommand instanceof SkybotVariableCommand) {
            AgentControl.checkAndFillInParms((SkybotVariableCommand)agentCommand);
        }
        if (agentCommand instanceof ImportCronCommand) {
            importCronCommandProcessor = new ImportCronCommandProcessor();
            importCronCommandProcessor.process((ImportCronCommand)agentCommand);
        }
        agentCommand.validate();
        importCronCommandProcessor = object.executeAgentCommand(agentCommand);
        if (agentCommand instanceof SkybotVariableCommand) {
            AgentControl.processSV((SkybotVariableCommand)agentCommand, (AgentCommandReply)importCronCommandProcessor);
        }
        if (!importCronCommandProcessor.isFailed()) {
            if (agentCommand instanceof GetActivityCommand) {
                AgentControl.printActivityInfo((GetActivityCommand)agentCommand, (AgentCommandReply)importCronCommandProcessor);
            }
            if (agentCommand instanceof GetAgentStatusCommand) {
                AgentControl.printAgentStatusInfo((AgentCommandReply)importCronCommandProcessor);
            }
            if (agentCommand instanceof ImportCronCommand) {
                AgentControl.printImportCronInfo((AgentCommandReply)importCronCommandProcessor);
            }
            if (agentCommand instanceof SkybotVariableCommand && ((SkybotVariableCommand)agentCommand).isGetMode()) {
                AgentControl.finished(null, null, 0);
            } else {
                AgentControl.finished("OK:" + importCronCommandProcessor.getReplyText(), null, 0);
            }
        } else {
            if (importCronCommandProcessor.getException() != null && importCronCommandProcessor.getException() instanceof ActionFailedException) {
                ActionFailedException actionFailedException = (ActionFailedException)importCronCommandProcessor.getException();
                throw actionFailedException;
            }
            if (importCronCommandProcessor.getException() != null) {
                throw new ActionFailedException(importCronCommandProcessor.getReplyText(), importCronCommandProcessor.getException());
            }
            throw new ActionFailedException(importCronCommandProcessor.getReplyText());
        }
    }

    private static void printAgentStatusInfo(AgentCommandReply agentCommandReply) {
        GetAgentStatusData getAgentStatusData = (GetAgentStatusData)agentCommandReply.getReturnObject();
        if (getAgentStatusData == null) {
            throw new IllegalArgumentException("Agent status return data is null.");
        }
        encodedConsoleOut.println(getAgentStatusData.getConnectionText());
        AgentControl.finished("OK:" + agentCommandReply.getReplyText(), null, getAgentStatusData.getAgentStatus());
    }

    private static void checkAndFillInParms(SkybotVariableCommand skybotVariableCommand) {
        if (skybotVariableCommand.isGetMode()) {
            return;
        }
        SkybotVariableValue skybotVariableValue = skybotVariableCommand.getSkybotVariableValue();
        if (skybotVariableValue == null || skybotVariableValue.isStatusFailed() || !"".equals(skybotVariableValue.getValue())) {
            return;
        }
        String string = System.getenv(skybotVariableValue.getName());
        if (string == null) {
            skybotVariableValue.setStatus(0);
            skybotVariableValue.setReplyMessage("Environment variable " + skybotVariableValue.getName() + " not found.");
        } else {
            skybotVariableValue.setValue(string);
        }
    }

    private static void processSV(SkybotVariableCommand skybotVariableCommand, AgentCommandReply agentCommandReply) {
        SkybotVariableValue skybotVariableValue = (SkybotVariableValue)agentCommandReply.getReturnObject();
        if (agentCommandReply.isFailed()) {
            encodedConsoleOut.println(skybotVariableValue.getReplyMessage());
            AgentControl.finished("Command failed", (Exception)agentCommandReply.getException(), 103);
        }
        if (skybotVariableValue == null) {
            AgentControl.finished("No values returned from agent server.", null, 103);
        }
        if (skybotVariableValue.isStatusFailed()) {
            encodedConsoleErr.println(skybotVariableValue.getReplyMessage());
        } else if (skybotVariableValue.isStatusPending()) {
            encodedConsoleErr.println(skybotVariableValue.getName() + " was not processed.");
        } else if (skybotVariableCommand.isSetMode()) {
            if (verbose) {
                encodedConsoleOut.println(skybotVariableValue.getReplyMessage());
            }
        } else if (skybotVariableCommand.isGetMode()) {
            encodedConsoleOut.println(skybotVariableValue.getValue());
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Win") > -1;
    }

    private static void printActivityInfo(GetActivityCommand getActivityCommand, AgentCommandReply agentCommandReply) {
        StringBuffer stringBuffer = new StringBuffer();
        GetActivityData getActivityData = (GetActivityData)agentCommandReply.getReturnObject();
        if (getActivityCommand.isJobListRequested()) {
            AgentControl.buildJobInfoOutput(stringBuffer, getActivityData.getJobs());
        }
        if (getActivityCommand.isFileTransfersRequested()) {
            if (getActivityCommand.isJobListRequested()) {
                stringBuffer.append("\n");
            }
            AgentControl.buildFileTransferOutput(stringBuffer, getActivityData.getFiles());
        }
        if (getActivityCommand.isEventListRequested()) {
            if (getActivityCommand.isJobListRequested() || getActivityCommand.isFileTransfersRequested()) {
                stringBuffer.append("\n");
            }
            AgentControl.buildEventMonitorOutput(stringBuffer, getActivityData.getMonitors());
        }
        encodedConsoleOut.println(stringBuffer.toString());
    }

    private static void buildEventMonitorOutput(StringBuffer stringBuffer, AgentEventMonitor[] agentEventMonitorArray) {
        stringBuffer.append("Agent Event Monitors:\n");
        int n = 0;
        if (agentEventMonitorArray != null) {
            n = agentEventMonitorArray.length;
        }
        int n2 = 20;
        int n3 = 20;
        int n4 = 20;
        int n5 = 15;
        if (n > 0) {
            stringBuffer.append(AgentControl.padTo("Name", n2) + " ");
            stringBuffer.append(AgentControl.padTo("Description", n3) + " ");
            stringBuffer.append(AgentControl.padTo("Type", n4) + " ");
            stringBuffer.append("Poll Interval\n");
            stringBuffer.append(AgentControl.padTo("", n2, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n3, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n4, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n5, "-") + "\n");
            for (int i = 0; i < agentEventMonitorArray.length; ++i) {
                String string = "";
                if (agentEventMonitorArray[i].getDescription() != null) {
                    string = agentEventMonitorArray[i].getDescription().length() > n3 ? agentEventMonitorArray[i].getDescription().substring(0, n3) : agentEventMonitorArray[i].getDescription();
                }
                stringBuffer.append(AgentControl.padTo(agentEventMonitorArray[i].getName(), n2) + " ");
                stringBuffer.append(AgentControl.padTo(string, n3) + " ");
                stringBuffer.append(AgentControl.padTo(agentEventMonitorArray[i].getTypeDescription(), n4) + " ");
                String string2 = null;
                string2 = agentEventMonitorArray[i] instanceof ManualEvent ? "Manually fired" : agentEventMonitorArray[i].getCycle() + " seconds";
                if (agentEventMonitorArray[i].getDisabled()) {
                    string2 = "Disabled";
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(AgentControl.formatCountMessage(n, "event monitor\n", "event monitors\n"));
    }

    private static void buildFileTransferOutput(StringBuffer stringBuffer, FileTransferInfo[] fileTransferInfoArray) {
        stringBuffer.append("Agent Output File Transfers:\n");
        int n = 0;
        if (fileTransferInfoArray != null) {
            n = fileTransferInfoArray.length;
        }
        int n2 = 20;
        int n3 = 12;
        int n4 = 10;
        int n5 = 30;
        if (n > 0) {
            stringBuffer.append(AgentControl.padTo("Remote Peer", n2) + " ");
            stringBuffer.append(AgentControl.padTo("File Size", n3) + " ");
            stringBuffer.append(AgentControl.padTo("% Complete", n4) + " ");
            stringBuffer.append("File Name\n");
            stringBuffer.append(AgentControl.padTo("", n2, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n3, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n4, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n5, "-") + "\n");
            for (int i = 0; i < fileTransferInfoArray.length; ++i) {
                stringBuffer.append(AgentControl.padTo(fileTransferInfoArray[i].getRemotePeerName(), n2) + " ");
                stringBuffer.append(AgentControl.padTo(fileTransferInfoArray[i].getFileSize(), n3) + " ");
                stringBuffer.append(AgentControl.padTo(fileTransferInfoArray[i].getPercentComplete(), n4) + " ");
                stringBuffer.append(fileTransferInfoArray[i].getFileName());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(AgentControl.formatCountMessage(n, "active file transfer\n", "active file transfers\n"));
    }

    private static void buildJobInfoOutput(StringBuffer stringBuffer, AgentJobInfo[] agentJobInfoArray) {
        stringBuffer.append("Jobs currently running:\n");
        int n = 0;
        if (agentJobInfoArray != null) {
            n = agentJobInfoArray.length;
        }
        int n2 = 20;
        int n3 = 20;
        if (n > 0) {
            stringBuffer.append(AgentControl.padTo("Job Name", n2) + " ");
            stringBuffer.append("Duration (mm" + AgentControl.getTimeSeparator() + "ss)\n");
            stringBuffer.append(AgentControl.padTo("", n2, "-") + " ");
            stringBuffer.append(AgentControl.padTo("", n3, "-") + "\n");
            long l = System.currentTimeMillis();
            for (int i = agentJobInfoArray.length - 1; i > -1; --i) {
                String string = agentJobInfoArray[i].getScheduleJobName();
                stringBuffer.append(AgentControl.padTo(string, n2) + " ");
                long l2 = agentJobInfoArray[i].getStartTime();
                stringBuffer.append(DateTranslator.formatElapsedTime((long)(l - l2)));
                if (agentJobInfoArray[i].isTerminating()) {
                    stringBuffer.append(" - Terminating");
                }
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(AgentControl.formatCountMessage(n, "active job\n", "active jobs\n"));
    }

    private static String formatCountMessage(int n, String string, String string2) {
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{"0 " + string2, "1 " + string, "{0,number} " + string2};
        ChoiceFormat choiceFormat = new ChoiceFormat(dArray, stringArray);
        MessageFormat messageFormat = new MessageFormat("{0}");
        Format[] formatArray = new Format[]{choiceFormat};
        messageFormat.setFormats(formatArray);
        Object[] objectArray = new Object[]{new Integer(n)};
        return messageFormat.format(objectArray);
    }

    private static String padTo(String string, int n) {
        return AgentControl.padTo(string, n, " ");
    }

    private static String padTo(String string, int n, String string2) {
        int n2;
        String string3 = null;
        string3 = string2 == null || string2.length() != 1 ? " " : string2;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = n2 = string.length(); i < n; ++i) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String getTimeSeparator() {
        Object object;
        String string = "M/DY";
        try {
            object = (SimpleDateFormat)DateFormat.getTimeInstance(3);
            string = ((SimpleDateFormat)object).toPattern();
        }
        catch (MissingResourceException missingResourceException) {
            string = "";
        }
        object = ":";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            object = Character.toString(c);
            break;
        }
        return object;
    }

    private static void doSwitch(PeerID peerID, String string) throws Exception {
        String string2 = null;
        int n = 0;
        String[] stringArray = null;
        stringArray = string.indexOf(":") > -1 ? string.split(":") : string.split(" ");
        if (stringArray.length != 2) {
            AgentControl.finished("Invalid address:port - " + string, null, 106);
        }
        string2 = stringArray[0];
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            AgentControl.finished("Invalid port number: " + stringArray[1], numberFormatException, 106);
        }
        if (n < 1 || n > 65535) {
            AgentControl.finished("Invalid port number: " + stringArray[1], null, 106);
        }
        AgentConfigAM agentConfigAM = (AgentConfigAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentConfigAM");
        agentConfigAM.switchServer(string2, n);
        String string3 = "Switched server to " + string;
        AgentControl.finished("OK:" + string3, null, 0);
    }

    static void finished(String string, Exception exception, int n) {
        if (n == 0) {
            if (string != null) {
                encodedConsoleOut.println(string);
            }
        } else if (string != null) {
            encodedConsoleErr.println(string);
        }
        if (verbose && exception != null) {
            exception.printStackTrace();
        }
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadPassphrase(String string) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            String string3 = string2;
            return string3;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static Map<String, List<String>> parseArgs(String[] stringArray) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<String> arrayList;
            String string2 = stringArray[i];
            if (string2.startsWith("-")) {
                if (string2.length() == 1) {
                    string = "";
                    continue;
                }
                string = string2.substring(1);
                continue;
            }
            if (string == null) {
                string = "";
            }
            if ((arrayList = (ArrayList<String>)hashMap.get(string)) == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(string2);
        }
        return hashMap;
    }

    private static void printImportCronInfo(AgentCommandReply agentCommandReply) {
        encodedConsoleOut.println(agentCommandReply.getReplyText());
    }

    static {
        if (consoleEncoding == null) {
            encodedConsoleOut = System.out;
            encodedConsoleErr = System.err;
        } else {
            try {
                encodedConsoleOut = new PrintStream((OutputStream)System.out, true, consoleEncoding);
                encodedConsoleErr = new PrintStream((OutputStream)System.err, true, consoleEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                encodedConsoleOut = System.out;
                encodedConsoleErr = System.err;
                unsupportedEncodingException.printStackTrace(encodedConsoleErr);
            }
        }
    }
}

