/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.tl.LingeringObjectRegistry;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommandReply;
import com.helpsystems.enterprise.core.cmdlineobj.AgentJobInfo;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferInfo;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityData;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusData;
import com.helpsystems.enterprise.core.cmdlineobj.ImportCronCommand;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SendMessageCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import com.helpsystems.enterprise.core.dm.AgentCommandAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorAM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.FileTransferInfoFetcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AgentCommandProcessor {
    private static final Logger logger = Logger.getLogger(AgentCommandProcessor.class);

    public AgentCommandReply execute(AgentPeer agentPeer, AgentCommand agentCommand) throws ActionFailedException {
        logger.debug((Object)("Executing Agent Command: " + agentCommand.getLogDescription()));
        if (agentCommand instanceof SendMessageCommand || agentCommand instanceof SkybotVariableCommand || agentCommand instanceof ReportCommand || agentCommand instanceof ImportCronCommand) {
            PeerID peerID = agentPeer.getConnectedAgentServer();
            try {
                Object object;
                AgentCommandAM agentCommandAM = (AgentCommandAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentCommandAM");
                if (peerID != null && peerID.getPeerDescriptor() != null && (object = peerID.getPeerDescriptor().getComputerName()) != null) {
                    agentCommand.setEnterpriseServerName(((String)object).trim());
                }
                object = agentCommandAM.executeCommand(agentCommand, agentPeer.getRemotePeerID());
                return object;
            }
            catch (ManagerNotFoundException managerNotFoundException) {
                throw new ActionFailedException("The Automate Schedule Server is not available.", (Throwable)managerNotFoundException);
            }
        }
        if (agentCommand instanceof GetActivityCommand) {
            return this.getActivityInfo(agentPeer, (GetActivityCommand)agentCommand);
        }
        if (agentCommand instanceof GetAgentStatusCommand) {
            return this.getAgentStatusInfo(agentPeer);
        }
        return new AgentCommandReply(true, "Undefined agent command: " + agentCommand.getLogDescription());
    }

    private AgentCommandReply getAgentStatusInfo(AgentPeer agentPeer) {
        AgentCommandReply agentCommandReply = new AgentCommandReply(false, "GETSTATUS completed normally.");
        GetAgentStatusData getAgentStatusData = new GetAgentStatusData();
        int n = 30;
        String string = null;
        String string2 = null;
        if (agentPeer.isShutdownRequested() || agentPeer.isShutdownStarted()) {
            n = 20;
        } else {
            PeerID peerID = agentPeer.getConnectedAgentServer();
            if (peerID == null) {
                n = 10;
            } else {
                n = 0;
                PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
                if (peerDescriptor != null) {
                    try {
                        string = peerDescriptor.getComputerName();
                        string2 = peerDescriptor.findIPAddress();
                    }
                    catch (Throwable throwable) {
                        logger.debug((Object)"Error loading enterprise server addresses.", throwable);
                    }
                }
            }
        }
        getAgentStatusData.setAgentStatus(n);
        if (string == null) {
            try {
                string = agentPeer.getAgentConfig().getMaster().findName();
            }
            catch (Throwable throwable) {
                logger.warn((Object)"Error resolving enterprise server name.", throwable);
            }
        }
        if (string2 == null) {
            try {
                string2 = agentPeer.getAgentConfig().getMaster().findIPAddress();
            }
            catch (Throwable throwable) {
                logger.warn((Object)"Error resolving enterprise server address.", throwable);
            }
        }
        getAgentStatusData.setEnterpriseServerName(string);
        getAgentStatusData.setEnterpriseServerAddress(string2);
        agentCommandReply.setReturnObject((Serializable)getAgentStatusData);
        return agentCommandReply;
    }

    private AgentCommandReply getActivityInfo(AgentPeer agentPeer, GetActivityCommand getActivityCommand) {
        FileTransferInfoFetcher fileTransferInfoFetcher;
        GetActivityData getActivityData = new GetActivityData();
        if (getActivityCommand.isJobListRequested()) {
            getActivityData.setJobs(this.getActiveJobInfo());
        }
        if (getActivityCommand.isFileTransfersRequested()) {
            fileTransferInfoFetcher = new FileTransferInfoFetcher((Peer)agentPeer);
            getActivityData.setFiles(fileTransferInfoFetcher.get());
        }
        if (getActivityCommand.isEventListRequested()) {
            getActivityData.setMonitors(this.getActiveEventMonitorInfo());
        }
        fileTransferInfoFetcher = new AgentCommandReply(false, "GETACTIVITY completed normally.");
        fileTransferInfoFetcher.setReturnObject((Serializable)getActivityData);
        return fileTransferInfoFetcher;
    }

    private AgentEventMonitor[] getActiveEventMonitorInfo() {
        AgentEventMonitorAM agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorAM");
        AgentEventMonitor[] agentEventMonitorArray = agentEventMonitorAM.getMonitors();
        Comparator<AgentEventMonitor> comparator = new Comparator<AgentEventMonitor>(){

            @Override
            public int compare(AgentEventMonitor agentEventMonitor, AgentEventMonitor agentEventMonitor2) {
                return agentEventMonitor.getName().compareTo(agentEventMonitor2.getName());
            }
        };
        Arrays.sort(agentEventMonitorArray, comparator);
        return agentEventMonitorArray;
    }

    public static FileTransferInfo[] getActiveFileTransferInfo(Peer peer) {
        LingeringObjectRegistry lingeringObjectRegistry = peer.getRemoteObjectRegistry();
        LingeringObjectRegistry.RegistryEntry[] registryEntryArray = lingeringObjectRegistry.getEntries();
        ArrayList<FileTransferInfo> arrayList = new ArrayList<FileTransferInfo>();
        for (LingeringObjectRegistry.RegistryEntry registryEntry : registryEntryArray) {
            Object object;
            if (registryEntry == null || !((object = registryEntry.getObject()) instanceof FileHandle)) continue;
            FileTransferInfo fileTransferInfo = new FileTransferInfo();
            FileHandle fileHandle = (FileHandle)object;
            PeerDescriptor peerDescriptor = registryEntry.getPeerID().getPeerDescriptor();
            String string = peerDescriptor.getComputerName();
            if (string == null || string.length() == 0) {
                string = peerDescriptor.findPrintableAddress();
            }
            fileTransferInfo.setRemotePeerName(string);
            fileTransferInfo.setFileName(fileHandle.getAbsolutePath());
            String string2 = "Unknown";
            long l = -1L;
            try {
                l = fileHandle.getLength();
                string2 = Convert.formatSizeInBytes((long)l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileTransferInfo.setFileSize(string2);
            int n = -1;
            try {
                double d = fileHandle.getFilePointer();
                n = (int)(d / (double)l * 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "Unknown";
            if (n > -1) {
                string3 = n + "%";
            }
            fileTransferInfo.setPercentComplete(string3);
            arrayList.add(fileTransferInfo);
        }
        if (arrayList.size() > 0) {
            LingeringObjectRegistry.RegistryEntry[] registryEntryArray2 = new FileTransferInfo[]{};
            return (FileTransferInfo[])arrayList.toArray(registryEntryArray2);
        }
        return null;
    }

    private AgentJobInfo[] getActiveJobInfo() {
        JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobExecDM");
        HashMap hashMap = null;
        if (jobExecDM != null) {
            hashMap = (HashMap)jobExecDM.listJobs();
        }
        Object[] objectArray = new JobTimer[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        AgentJobInfo[] agentJobInfoArray = new AgentJobInfo[objectArray.length];
        for (int i = objectArray.length - 1; i > -1; --i) {
            Object object = objectArray[i];
            ExecutableJob executableJob = (ExecutableJob)hashMap.get(object);
            agentJobInfoArray[i] = new AgentJobInfo((JobTimer)object, executableJob);
        }
        return agentJobInfoArray;
    }
}

