/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.sql.SQLException;

public class SAPInterceptedJobHistoryPurgeRunner
extends AbstractPurgeRunner {
    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        SAPInterceptedJobsDM sAPInterceptedJobsDM = (SAPInterceptedJobsDM)ManagerRegistry.getManager((String)"ENTERPRISE.SAPInterceptedJobsDM");
        sAPInterceptedJobsDM.purgeHistory(systemSetup.getSapInterceptedJobHistoryDaysToKeep());
    }

    @Override
    public String getName() {
        return RosettaMsg.PURGE_SAP_INTERCEPTED_JOB_HISTORY_NAME.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return systemSetup.isSapInterceptedJobHistoryAutoPurge();
    }
}

