/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventHistoryDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyDM;
import com.helpsystems.enterprise.scheduler.executors.AbstractPurgeRunner;
import java.sql.SQLException;

public class RemoteHistoryPurgeRunner
extends AbstractPurgeRunner {
    @Override
    public void doPurge(SystemSetup systemSetup) throws ResourceUnavailableException, DataException, SQLException {
        System.out.println("Remote History keep days = " + systemSetup.getRemoteHistoryDaysToKeep());
        RemoteEventHistoryDM remoteEventHistoryDM = (RemoteEventHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteEventHistoryDM");
        remoteEventHistoryDM.purgeHistory(systemSetup.getRemoteHistoryDaysToKeep());
        RemoteDependencyDM remoteDependencyDM = (RemoteDependencyDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteDependencyDM");
        remoteDependencyDM.purgeHistory(systemSetup.getRemoteHistoryDaysToKeep());
    }

    @Override
    public String getName() {
        return RosettaMsg.PURGE_REMOTE_HISTORY_NAME.newLogEntry().getMessageText();
    }

    @Override
    public boolean isOkToRunPurge(SystemSetup systemSetup) {
        return systemSetup.isRemoteHistoryAutoPurge();
    }
}

