/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.scheduler.executors.CleanupExecutor;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class MinuteBasedCleanupExecutor
extends CleanupExecutor {
    private int minutes = 15;

    public MinuteBasedCleanupExecutor(int n) {
        if (n > 0) {
            this.minutes = n;
        }
        this.setThreadName("Minutes Based Cleanup Thread");
        this.setLogMessages(RosettaMsg.MINUTES_BASED_CLEANUP_NEXT_WAKEUP, RosettaMsg.NO_MINUTES_BASED_CLEANUP_RUNNERS, RosettaMsg.MINUTES_BASED_CLEANUP_RUNNERS_ERROR_ENCOUNTERED);
        this.scheduleService();
    }

    @Override
    protected long getNextWakeupTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(12, this.minutes);
        return gregorianCalendar.getTimeInMillis();
    }

    @Override
    protected long getWaitTime() {
        return this.minutes * 60;
    }

    @Override
    protected boolean isServerLogEnabled() {
        return false;
    }

    static {
        logger = Logger.getLogger(MinuteBasedCleanupExecutor.class);
    }
}

