/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.MissedAgentJob;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.scheduler.Driver;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import com.helpsystems.enterprise.scheduler.PrereqEvaluator;
import com.helpsystems.enterprise.scheduler.Scheduler;
import com.helpsystems.enterprise.scheduler.SchedulerAMImpl;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class SchedulerDriver
extends Driver {
    private static Logger logger = Logger.getLogger(SchedulerDriver.class);
    public static final String THREAD_NAME = SchedulerDriver.class.getSimpleName();

    public static SchedulerDriver getSchedulerDriver(Set<MissedAgentJob> set, boolean bl, Date date) {
        SchedulerAMImpl schedulerAMImpl = (SchedulerAMImpl)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SchedulerAM");
        NSTCalculator nSTCalculator = schedulerAMImpl.getNSTCalculator();
        ScheduledTimeDM scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
        ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        PrereqDM prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
        PrereqEvaluator prereqEvaluator = null;
        try {
            prereqEvaluator = new PrereqEvaluator(nSTCalculator, scheduleJobDM, prereqDM);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Could not start the Scheduler Prerequisite Evaluator.", (Throwable)resourceUnavailableException);
        }
        Scheduler scheduler = new Scheduler(scheduledTimeDM, prereqEvaluator, set, bl, date);
        nSTCalculator.setScheduler(scheduler);
        return new SchedulerDriver(scheduler);
    }

    public SchedulerDriver(Scheduler scheduler) {
        super(scheduler);
    }
}

