/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEventSource;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import com.helpsystems.enterprise.core.busobj.SNMPTrapMonitor;
import com.helpsystems.enterprise.core.busobj.SendStatusEventType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventMonitor;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryInfoDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.JobMonitorEventsDM;
import com.helpsystems.enterprise.core.dm.PrereqEventDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapEventDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventHistoryDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventHistoryDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventMonitorDM;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMember;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqEventList;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntry;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntryList;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteMarkerList;
import com.helpsystems.enterprise.core.scheduler.PrerequisitesDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.util.LongConverter;
import com.helpsystems.enterprise.scheduler.Drivable;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import com.helpsystems.enterprise.scheduler.PrereqEvaluator;
import com.helpsystems.enterprise.scheduler.SchedulerAMImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import sun.util.calendar.ZoneInfo;

public class ReactivityMonitor
implements Drivable {
    private static final Logger logger = Logger.getLogger(ReactivityMonitor.class);
    private static boolean active = false;
    private static Object activeLock = new Object();
    private boolean shutdown = false;
    private Object waitLock = new Object();
    private boolean sleeping;
    private boolean moreToDo = false;
    private PrereqEventDM prereqEventDM;
    private PrerequisitesDM prerequisitesDM;
    private PrereqDM prereqDM;
    private SpecialInstanceDM specialInstanceDM;
    private CalendarObjectDM calendarObjectDM;
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private ScheduleJobDM scheduleJobDM;
    private JobSuiteDM jobSuiteDM;
    private JobMonitorEventsDM jobMonitorEventsDM;
    private AgentEventMonitorDM agentEventMonitorDM;
    private AgentEventHistoryInfoDM agentEventHistoryInfoDM;
    private SNMPTrapMonitorDM snmpTrapMonitorDM;
    private SNMPTrapEventDM snmpTrapEventDM;
    private SAPEventHistoryDM sapEventHistoryDM;
    private SAPEventMonitorDM sapEventMonitorDM;
    private RemoteEventDM remoteEventDM;
    private RemoteEventHistoryDM remoteEventHistoryDM;
    private PrereqEventList prereqEventList;
    private PrereqEvaluator prereqEvaluator;
    private PrerequisiteEntryList prerequisiteEntryList;
    private PrerequisiteMarkerList prerequisiteMarkerList;
    private static ReactivityMonitor currentReactivityMonitor = null;
    private static Object currentReactivityMonitorLock = new Object();
    private boolean current = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCaughtUp() {
        Object object = currentReactivityMonitorLock;
        synchronized (object) {
            if (currentReactivityMonitor == null) {
                return false;
            }
            return ReactivityMonitor.currentReactivityMonitor.current;
        }
    }

    public ReactivityMonitor(PrereqEventDM prereqEventDM) {
        this.prereqEventDM = prereqEventDM;
        this.prerequisitesDM = (PrerequisitesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrerequisitesDM");
        this.prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
        this.specialInstanceDM = (SpecialInstanceDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SpecialInstanceDM");
        this.calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        this.scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteDM");
        this.jobMonitorEventsDM = (JobMonitorEventsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorEventsDM");
        this.agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventMonitorDM");
        this.agentEventHistoryInfoDM = (AgentEventHistoryInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventHistoryInfoDM");
        this.snmpTrapMonitorDM = (SNMPTrapMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SNMPTrapMonitorDM");
        this.snmpTrapEventDM = (SNMPTrapEventDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SNMPTrapEventDM");
        this.sapEventHistoryDM = (SAPEventHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPEventHistoryDM");
        this.sapEventMonitorDM = (SAPEventMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPEventMonitorDM");
        this.remoteEventDM = (RemoteEventDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteEventDM");
        this.remoteEventHistoryDM = (RemoteEventHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteEventHistoryDM");
        this.createPrereqEvaluator();
    }

    @Override
    public void prepareForRestart() {
        logger.debug((Object)"Preparing to restart the Reactivity Monitor.");
        if (this.prereqEventList != null) {
            this.prereqEventList.close();
            this.prereqEventList = null;
        }
        if (this.prerequisiteEntryList != null) {
            this.prerequisiteEntryList.close();
            this.prerequisiteEntryList = null;
        }
        if (this.prerequisiteMarkerList != null) {
            this.prerequisiteMarkerList.close();
            this.prerequisiteMarkerList = null;
        }
        if (this.prereqEvaluator != null) {
            this.prereqEvaluator.shutDown();
            this.prereqEvaluator = null;
            this.createPrereqEvaluator();
        }
    }

    @Override
    public void start() {
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SCHEDULER.getMDCKeyValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = currentReactivityMonitorLock;
        synchronized (object) {
            currentReactivityMonitor = this;
            this.current = false;
        }
        object = activeLock;
        synchronized (object) {
            if (active) {
                throw new IllegalStateException("The Reactivity Monitor is already running!");
            }
            active = true;
            this.shutdown = false;
            this.prerequisiteEntryList = null;
            this.prerequisiteMarkerList = null;
            this.prereqEventList = null;
        }
        try {
            this.prerequisiteEntryList = this.prerequisitesDM.createPrerequisiteEntryList();
            this.prerequisiteMarkerList = this.prerequisitesDM.createPrerequisiteMarkerList(this.prerequisiteEntryList);
            this.createPrereqEvaluator();
            this.mainLoop();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string = "The Reactivity Monitor is ending in Error.";
            throw new RuntimeException(string, resourceUnavailableException);
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable throwable) {}
            Object object2 = activeLock;
            synchronized (object2) {
                active = false;
            }
        }
    }

    private void createPrereqEvaluator() {
        logger.debug((Object)"Creating Prereq Evaluator for the Reactivity Monitor.");
        if (this.prereqEvaluator != null) {
            logger.debug((Object)"Prereq Evaluator already exists...");
            return;
        }
        SchedulerAMImpl schedulerAMImpl = (SchedulerAMImpl)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SchedulerAM");
        NSTCalculator nSTCalculator = schedulerAMImpl.getNSTCalculator();
        try {
            this.prereqEvaluator = new PrereqEvaluator(nSTCalculator, this.scheduleJobDM, this.prereqDM);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RuntimeException("Error creating Prereq evaluator.", resourceUnavailableException);
        }
    }

    public boolean isActive() {
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() throws ResourceUnavailableException {
        try {
            int n = 10;
            int n2 = n * 60 * 1000;
            boolean bl = true;
            while (!this.shutdown) {
                Object object = this.waitLock;
                synchronized (object) {
                    if (!this.shutdown && !this.moreToDo) {
                        this.sleeping = true;
                        if (!bl) {
                            try {
                                this.waitLock.wait(n2);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            bl = false;
                        }
                        this.sleeping = false;
                    }
                }
                if (!this.shutdown) {
                    do {
                        if (!this.moreToDo) {
                            logger.debug((Object)"Reactivity Monitor is processing events.");
                        } else {
                            logger.debug((Object)"Reactivity Monitor is processing \"moreToDo\" events.");
                        }
                        this.moreToDo = false;
                        this.processAllEvents();
                        this.current = true;
                    } while (!this.shutdown && this.moreToDo);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            String string = "Reactivity Monitor error.";
            logger.error((Object)string, (Throwable)exception);
        }
    }

    private void processAllEvents() throws ResourceUnavailableException {
        if (this.prereqEventList == null) {
            this.prereqEventList = this.prereqEventDM.getPrereqEventList();
        }
        this.prereqEventList.reload();
        while (!this.shutdown && this.prereqEventList.next()) {
            PrereqEvent prereqEvent = this.prereqEventList.getPrereqEvent();
            if (prereqEvent.getEventSource() == PrereqEventSource.USER) {
                this.processUserEvent(prereqEvent);
            } else {
                this.processEvent(prereqEvent);
            }
            this.prereqEventDM.delete(prereqEvent.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUserEvent(PrereqEvent prereqEvent) {
        logger.debug((Object)("Processing User Event: " + prereqEvent.getSendStatusEventType()));
        AgentGroupType agentGroupType = null;
        switch (prereqEvent.getSendStatusEventType()) {
            case SEND_OBJECT_EVENT: {
                this.processEvent(prereqEvent);
                break;
            }
            case SEND_JOB_CHANGE_EVENT: {
                ScheduleJobProxy scheduleJobProxy = null;
                try {
                    scheduleJobProxy = this.getJobProxy(prereqEvent.getUserEventObjectID());
                }
                catch (NoDataException noDataException) {
                    logger.debug((Object)("The job may have been deleted.  Job (" + prereqEvent.getUserEventObjectID() + ")"));
                    return;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.debug((Object)("Unable to find the job number to update.  Job (" + prereqEvent.getUserEventObjectID() + ")"));
                    return;
                }
                if (scheduleJobProxy == null) break;
                this.prereqEvaluator.prereqEvent(scheduleJobProxy, scheduleJobProxy.getSystem());
                break;
            }
            default: {
                try {
                    ScheduleJobProxy scheduleJobProxy = null;
                    JobSuiteMember jobSuiteMember = null;
                    Prereq prereq = this.prereqDM.getPrereq(prereqEvent.getUserEventDepID());
                    if (prereqEvent.getType() == PrereqEventType.JOB_STATUS_CHANGE || prereqEvent.getType() == PrereqEventType.JOB_MONITOR_EVENT || prereqEvent.getType() == PrereqEventType.JOB_SUITE_MEMBER_MONITOR_EVENT) {
                        scheduleJobProxy = this.getJobProxy(prereq.getPrereqObjectID());
                    } else if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
                        jobSuiteMember = this.getJobSuiteMember(prereq.getPrereqObjectID());
                        scheduleJobProxy = this.getJobProxy(jobSuiteMember.getJobID());
                    }
                    int n = LongConverter.intValue((long)prereqEvent.getUserEventDepID());
                    int n2 = LongConverter.intValue((long)prereqEvent.getUserEventDepAgentID());
                    int n3 = LongConverter.intValue((long)prereq.getDepJobID());
                    int n4 = LongConverter.intValue((long)prereq.getPrereqObjectID());
                    int n5 = LongConverter.intValue((long)prereqEvent.getUserEventPrereqAgentID());
                    PrerequisiteEntry prerequisiteEntry = new PrerequisiteEntry();
                    prerequisiteEntry.setOid(n);
                    prerequisiteEntry.setDepAgentID(n2);
                    prerequisiteEntry.setDepJobID(n3);
                    prerequisiteEntry.setSpecificInstance(null);
                    prerequisiteEntry.setLatchStatus(false);
                    prerequisiteEntry.setReactToStatus(prereq.getReactToStatus());
                    ArrayList<PrerequisiteEntry> arrayList = new ArrayList<PrerequisiteEntry>();
                    arrayList.add(prerequisiteEntry);
                    this.markPrereqStatuses(prereqEvent, n4, n5, arrayList, scheduleJobProxy);
                    switch (prereq.getPrereqObjectFile()) {
                        case JOBS: 
                        case MEMBER_JOB_MONITORS: {
                            if (scheduleJobProxy == null) {
                                scheduleJobProxy = this.getJobProxy(prereq.getPrereqObjectID());
                            }
                            if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                                AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy.getTargetId());
                                agentGroupType = agentGroupProxy.getAgentGroupType();
                            }
                            logger.debug((Object)("Prereq Job " + scheduleJobProxy.getName() + " is agent group type: " + agentGroupType));
                            break;
                        }
                        case AGENT_EVENT_MONITORS: {
                            AgentEventMonitor agentEventMonitor = this.getAgentEventMonitor(prereq.getPrereqObjectID());
                            if (agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                                agentGroupType = AgentGroupType.ALL_AGENTS;
                            }
                            logger.debug((Object)("Prereq AEM " + agentEventMonitor.getName() + " is a agent group type: " + agentGroupType));
                            break;
                        }
                        case SNMP_TRAP_MONITORS: {
                            break;
                        }
                        case REMOTE_EVENTS: {
                            break;
                        }
                        case MEMBER_JOB_STATUSES: {
                            if (jobSuiteMember == null) {
                                jobSuiteMember = this.getJobSuiteMember(prereq.getPrereqObjectID());
                            }
                            if (scheduleJobProxy == null) {
                                scheduleJobProxy = this.getJobProxy(jobSuiteMember.getJobID());
                            }
                            if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                                AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobProxy.getTargetId());
                                agentGroupType = agentGroupProxy.getAgentGroupType();
                            }
                            logger.debug((Object)("Prereq Job Suite Member " + scheduleJobProxy.getName() + " is a group: " + agentGroupType));
                            break;
                        }
                        case JOB_SUITES: {
                            break;
                        }
                        default: {
                            logger.debug((Object)("Prereq object file is not defined: " + prereq.getPrereqObjectFile()));
                        }
                    }
                    this.checkDepJobs(this.prerequisiteMarkerList.getPrerequisiteEntries(), agentGroupType, n5, n4);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error processing user prerequisite event: " + prereqEvent.toString()), throwable);
                }
                break;
            }
        }
    }

    private void markPrereqStatuses(PrereqEvent prereqEvent, int n, int n2, List<PrerequisiteEntry> list, Object object) throws ResourceUnavailableException {
        this.prerequisiteMarkerList.setPrerequisiteEntries(list);
        this.prerequisiteMarkerList.setSystem(n2);
        this.prerequisiteMarkerList.setPrereqObjectOID(n);
        this.prerequisiteMarkerList.setPrereqEventType(prereqEvent.getType());
        this.prerequisiteMarkerList.setStatus(prereqEvent.getPrereqStatus().persistanceCode());
        if (!prereqEvent.isDoneMarkingStatuses()) {
            this.prerequisitesDM.markPrerequisiteStatus(this.prerequisiteMarkerList, prereqEvent, object);
            this.prereqEventDM.updateMarkedStatuses(prereqEvent.getId());
        } else {
            logger.debug((Object)("*** prereqEvent for job history: " + prereqEvent.getHistoryOID() + " has already marked statuses."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEvent(PrereqEvent prereqEvent) {
        Object object;
        Object object2;
        long l = 0L;
        String string = null;
        String string2 = null;
        String string3 = prereqEvent.getPrereqStatus().toString();
        long l2 = 0L;
        String string4 = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        ScheduleJobProxy scheduleJobProxy = null;
        AgentEventMonitor agentEventMonitor = null;
        ScheduleJobProxy scheduleJobProxy2 = null;
        AgentGroupType agentGroupType = null;
        try {
            SNMPTrapEvent sNMPTrapEvent;
            JobMonitorEvent jobMonitorEvent;
            if (prereqEvent.getEventSource() == PrereqEventSource.USER) {
                if (prereqEvent.getSendStatusEventType() != SendStatusEventType.SEND_OBJECT_EVENT) throw new IllegalStateException("SendStatusEventType " + prereqEvent.getSendStatusEventType() + " is not supported.");
                l = prereqEvent.getUserEventObjectID();
                l3 = prereqEvent.getTimestamp();
                switch (prereqEvent.getType()) {
                    case JOB_STATUS_CHANGE: 
                    case JOB_SUITE_STATUS_CHANGE: 
                    case JOB_MONITOR_EVENT: 
                    case JOB_SUITE_MONITOR_EVENT: 
                    case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                        logger.debug((Object)"Loading user sent job event...");
                        scheduleJobProxy = this.getJobProxy(l);
                        string = scheduleJobProxy.getName();
                        scheduleJobProxy2 = scheduleJobProxy;
                        l2 = prereqEvent.getUserEventPrereqAgentID();
                        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_STATUS_CHANGE) {
                            string2 = "job suite";
                            break;
                        }
                        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_MONITOR_EVENT) {
                            string2 = "job suite monitor";
                            break;
                        }
                        if (prereqEvent.getType() == PrereqEventType.JOB_MONITOR_EVENT) {
                            string2 = "job monitor";
                            break;
                        }
                        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_MEMBER_MONITOR_EVENT) {
                            string2 = "suite member monitor";
                            break;
                        }
                        string2 = "job";
                        break;
                    }
                    case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                        logger.debug((Object)"Loading user sent member job event...");
                        l5 = l;
                        JobSuiteMember jobSuiteMember = this.getJobSuiteMember(l5);
                        l = jobSuiteMember.getJobID();
                        scheduleJobProxy = this.getJobProxy(l);
                        string = scheduleJobProxy.getName();
                        scheduleJobProxy2 = scheduleJobProxy;
                        l2 = prereqEvent.getUserEventPrereqAgentID();
                        string2 = "member job";
                        break;
                    }
                    case AGENT_EVENT: {
                        logger.debug((Object)"Loading user sent AEM event...");
                        agentEventMonitor = this.getAgentEventMonitor(l);
                        string = agentEventMonitor.getName();
                        scheduleJobProxy2 = agentEventMonitor;
                        l2 = prereqEvent.getUserEventPrereqAgentID();
                        string2 = "agent event monitor";
                        break;
                    }
                    case SNMP_TRAP_EVENT: {
                        logger.debug((Object)"Loading user sent SNMP Trap event...");
                        jobMonitorEvent = this.getSNMPTrapMonitor(l);
                        string = jobMonitorEvent.getName();
                        l2 = 0L;
                        string2 = "SNMP trap monitor";
                        break;
                    }
                    case SAP_MONITOR_EVENT: {
                        logger.debug((Object)"Loading user sent SAP Event...");
                        sNMPTrapEvent = this.getSAPEventMonitor(l);
                        string = sNMPTrapEvent.getName();
                        l2 = 0L;
                        string2 = "SAP event monitor";
                        break;
                    }
                    case REMOTE_EVENT: {
                        logger.debug((Object)"Loading user sent Remote Event...");
                        object2 = this.getRemoteEvent(l);
                        string = object2.getRemoteObjectName();
                        l2 = 0L;
                        string2 = "remote event";
                        break;
                    }
                    default: {
                        String string5 = "Undefined User Event Type: " + prereqEvent.getType();
                        throw new IllegalStateException(string5);
                    }
                }
                if (l2 != 0L) {
                    Agent agent = this.getAgent(l2);
                    string4 = agent.getName();
                } else {
                    string4 = "*NONE";
                }
            } else {
                logger.debug((Object)"Loading non-user event...");
                switch (prereqEvent.getType()) {
                    case JOB_STATUS_CHANGE: 
                    case JOB_SUITE_STATUS_CHANGE: {
                        l = prereqEvent.getHistoryJobID();
                        string = prereqEvent.getHistoryJobName();
                        l2 = prereqEvent.getHistoryAgentID();
                        l3 = prereqEvent.getHistoryScheduledTimeUTC();
                        l4 = prereqEvent.getHistoryMovedFromScheduledDateTime();
                        scheduleJobProxy2 = scheduleJobProxy = this.getJobProxy(l);
                        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_STATUS_CHANGE) {
                            string2 = "job suite";
                            string4 = "*NONE";
                            break;
                        }
                        string2 = "job";
                        string4 = prereqEvent.getHistoryAgentName();
                        break;
                    }
                    case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                        l = prereqEvent.getHistoryJobID();
                        string = prereqEvent.getHistoryJobName();
                        l2 = prereqEvent.getHistoryAgentID();
                        string4 = prereqEvent.getHistoryAgentName();
                        l3 = prereqEvent.getHistoryScheduledTimeUTC();
                        l4 = prereqEvent.getHistoryMovedFromScheduledDateTime();
                        l5 = prereqEvent.getHistoryJobSuiteMemberID();
                        scheduleJobProxy2 = scheduleJobProxy = this.getJobProxy(l);
                        string2 = "member job";
                        break;
                    }
                    case AGENT_EVENT: {
                        AgentEventHistoryInfo agentEventHistoryInfo = this.agentEventHistoryInfoDM.get(prereqEvent.getHistoryOID());
                        l = agentEventHistoryInfo.getEventOID();
                        string = agentEventHistoryInfo.getEventMonitorName();
                        l2 = agentEventHistoryInfo.getAgentOID();
                        string4 = agentEventHistoryInfo.getAgentName();
                        l3 = agentEventHistoryInfo.getServerTimeStamp();
                        agentEventMonitor = this.agentEventMonitorDM.get(l, null);
                        scheduleJobProxy2 = agentEventMonitor;
                        string2 = "agent event monitor";
                        break;
                    }
                    case JOB_MONITOR_EVENT: 
                    case JOB_SUITE_MONITOR_EVENT: 
                    case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                        jobMonitorEvent = this.jobMonitorEventsDM.get(prereqEvent.getHistoryOID());
                        l = jobMonitorEvent.getJobID();
                        string = jobMonitorEvent.getRuntimeJobName();
                        l2 = jobMonitorEvent.getAgentID();
                        l3 = jobMonitorEvent.getScheduledTime() != 0L ? jobMonitorEvent.getScheduledTime() : jobMonitorEvent.getTimeDetected();
                        l5 = prereqEvent.getHistoryJobSuiteMemberID();
                        scheduleJobProxy2 = scheduleJobProxy = this.getJobProxy(l);
                        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_MONITOR_EVENT) {
                            string2 = "job suite monitor";
                            string4 = "*NONE";
                            break;
                        }
                        string2 = "job monitor";
                        string4 = jobMonitorEvent.getAgentName();
                        break;
                    }
                    case SNMP_TRAP_EVENT: {
                        sNMPTrapEvent = this.snmpTrapEventDM.get(prereqEvent.getHistoryOID());
                        l = sNMPTrapEvent.getSNMPTrapMonitorID();
                        string = sNMPTrapEvent.getSNMPTrapMonitorName();
                        l2 = 0L;
                        string4 = "*NONE";
                        l3 = sNMPTrapEvent.getTimeDetected();
                        string2 = "SNMP trap monitor";
                        break;
                    }
                    case SAP_MONITOR_EVENT: {
                        object2 = this.sapEventHistoryDM.get(prereqEvent.getHistoryOID());
                        l = object2.getEventMonitorOID();
                        string = object2.getEventMonitorName();
                        l2 = 0L;
                        string4 = "*NONE";
                        l3 = object2.getEventTimestampUTC();
                        string2 = "SAP event monitor";
                        break;
                    }
                    case REMOTE_EVENT: {
                        object = this.remoteEventHistoryDM.get(prereqEvent.getHistoryOID());
                        l = object.getRemoteEventID();
                        string = object.getObjectName();
                        l2 = 0L;
                        string4 = "*NONE";
                        l3 = object.getServerTime();
                        string2 = "Remote event";
                        break;
                    }
                    default: {
                        String string6 = "Undefined Event Type: " + prereqEvent.getType();
                        throw new IllegalStateException(string6);
                    }
                }
            }
        }
        catch (NoDataException noDataException) {
            logger.warn((Object)("Missing data for prerequisite event: " + noDataException.getMessage()));
            return;
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error loading prerequisite history.", throwable);
            return;
        }
        String string7 = MessageUtil.formatMsg((String)"TYPE({0}).STATUS({1}).HIST_ID({2}).OBJ_ID({3}).OBJ_NAME({4}).AGENT_ID({5}).AGENT_NAME({6}).SPCINST_TIME({7}).MOVED_FROM({8}).SUITE_MEMBER_ID({9})", (Object[])new Object[]{prereqEvent.getType().toString(), prereqEvent.getPrereqStatus(), String.valueOf(prereqEvent.getHistoryOID()), String.valueOf(l), string, String.valueOf(l2), string4, String.valueOf(l3), String.valueOf(l4), String.valueOf(l5)});
        logger.debug((Object)("Processing Prereq Event: " + string7));
        int n = LongConverter.intValue((long)l);
        int n2 = LongConverter.intValue((long)l2);
        if (prereqEvent.getType() == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
            n = LongConverter.intValue((long)l5);
        }
        try {
            PrerequisiteEntry prerequisiteEntry;
            this.prerequisitesDM.retrievePrerequisiteEntriesForEvent(n, this.prerequisiteEntryList, prereqEvent.getType());
            object2 = new ArrayList();
            object = Calendar.getInstance();
            while (this.prerequisiteEntryList.next()) {
                prerequisiteEntry = this.prerequisiteEntryList.getEntry();
                ScheduleInfo.TimeZoneType timeZoneType = null;
                String string8 = null;
                long l6 = 0L;
                if (prerequisiteEntry.isReactToSpecificInstanceOnly()) {
                    String string9;
                    TimeZone timeZone;
                    ((Calendar)object).setTimeInMillis(l3);
                    if (prereqEvent.getType() == PrereqEventType.JOB_STATUS_CHANGE || prereqEvent.getType() == PrereqEventType.JOB_MONITOR_EVENT || prereqEvent.getType() == PrereqEventType.JOB_SUITE_STATUS_CHANGE) {
                        if (scheduleJobProxy == null) {
                            scheduleJobProxy = this.getJobProxy(l);
                        }
                        timeZoneType = scheduleJobProxy.getTimezoneType();
                        string8 = scheduleJobProxy.getJobTimezone();
                        l6 = scheduleJobProxy.getCalendarID();
                    }
                    if (prereqEvent.getType() == PrereqEventType.AGENT_EVENT) {
                        if (agentEventMonitor == null) {
                            agentEventMonitor = this.getAgentEventMonitor(l);
                        }
                        timeZoneType = agentEventMonitor.getTimeZoneType();
                    }
                    if (timeZoneType == null) {
                        timeZoneType = ScheduleInfo.TimeZoneType.SERVER;
                    }
                    switch (timeZoneType) {
                        case SERVER: {
                            timeZone = this.serverTimeZone();
                            break;
                        }
                        case AGENT: {
                            String string10 = this.agentTimezoneID(l2);
                            timeZone = this.timezone(string10, string);
                            break;
                        }
                        case JOB: {
                            String string10 = string8;
                            if (string10 != null && !string10.isEmpty()) {
                                timeZone = this.timezone(string10, string);
                                break;
                            }
                            timeZone = this.serverTimeZone();
                            string9 = timeZone.getID();
                            logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string9}));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
                        }
                    }
                    ((Calendar)object).setTimeZone(timeZone);
                    if (!this.validSpecialInstance(prerequisiteEntry, (Calendar)object, l4, l6)) {
                        try {
                            String[] stringArray;
                            string9 = this.specialInstanceDM.get(prerequisiteEntry.getSpecialInstanceID());
                            ScheduleJobProxy scheduleJobProxy3 = this.scheduleJobDM.getScheduleJobProxy((long)prerequisiteEntry.getDepJobID());
                            ScheduleLogEntry scheduleLogEntry = null;
                            if (string4 == null || string4.length() == 0) {
                                stringArray = new String[]{string2, string, ScheduleLogger.formatTimeStamp((Calendar)object), string9.getName(), scheduleJobProxy3.getName(), string3};
                                scheduleLogEntry = RosettaMsg.PREREQUISITE_STATUS_FOR_AGENTLESS_EVENT_NOT_ACCEPTED_BY_SPECIAL_INSTANCE.newLogEntry(stringArray, (long)prerequisiteEntry.getDepAgentID(), (long)prerequisiteEntry.getDepJobID());
                            } else {
                                stringArray = new String[]{string2, string, string4, ScheduleLogger.formatTimeStamp((Calendar)object), string9.getName(), scheduleJobProxy3.getName(), string3};
                                scheduleLogEntry = RosettaMsg.PREREQUISITE_STATUS_NOT_ACCEPTED_BY_SPECIAL_INSTANCE.newLogEntry(stringArray, (long)prerequisiteEntry.getDepAgentID(), (long)prerequisiteEntry.getDepJobID());
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)scheduleLogEntry.getMessageText());
                            }
                            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        }
                        catch (Throwable throwable) {
                            logger.error((Object)"Error processing special instance or schedule job.", throwable);
                        }
                        continue;
                    }
                }
                object2.add(prerequisiteEntry);
            }
            if (object2.size() == 0) {
                logger.debug((Object)("No prerequisites to update for: " + string7));
                return;
            }
            logger.debug((Object)(object2.size() + " prerequisite statuses to update for: " + string7));
            this.markPrereqStatuses(prereqEvent, n, n2, (List<PrerequisiteEntry>)object2, scheduleJobProxy2);
            if (scheduleJobProxy != null) {
                logger.debug((Object)("Loading prereq target type: " + scheduleJobProxy.getTargetType() + " Target ID: " + scheduleJobProxy.getTargetId()));
                if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                    prerequisiteEntry = this.agentGroupDM.getProxy(scheduleJobProxy.getTargetId());
                    agentGroupType = prerequisiteEntry.getAgentGroupType();
                }
            } else if (agentEventMonitor != null) {
                if (agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                    agentGroupType = AgentGroupType.ALL_AGENTS;
                }
            } else {
                logger.debug((Object)"Loading prereq agent group type was not loaded: Prereq objects were null...");
            }
            this.checkDepJobs(this.prerequisiteMarkerList.getPrerequisiteEntries(), agentGroupType, l2, l);
            return;
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error processing prerequisite event: " + string7), throwable);
            return;
        }
        finally {
            this.prerequisitesDM.closeRS(this.prerequisiteEntryList);
        }
    }

    private boolean validSpecialInstance(PrerequisiteEntry prerequisiteEntry, Calendar calendar, long l, long l2) {
        try {
            SpecialInstance specialInstance = this.specialInstanceDM.get(prerequisiteEntry.getSpecialInstanceID());
            logger.trace((Object)("Loaded special instance " + prerequisiteEntry.getSpecialInstanceID() + ": " + specialInstance.toString()));
            CalendarObject calendarObject = this.loadCalendarObject(l2);
            return specialInstance.isAcceptedTimestamp(calendar, l, calendarObject);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error processing special instance.", throwable);
            return false;
        }
    }

    private CalendarObject loadCalendarObject(long l) {
        try {
            if (l == 0L) {
                return this.calendarObjectDM.getStandardCalendar();
            }
            return this.calendarObjectDM.get(l);
        }
        catch (BadDataException badDataException) {
            logger.error((Object)("Error loading calendar with ID: " + l), (Throwable)badDataException);
            return (CalendarObject)badDataException.getLoadedObject();
        }
        catch (NoDataException noDataException) {
            logger.error((Object)("Calendar not found for ID: " + l), (Throwable)noDataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)("Error loading calendar with ID: " + l), (Throwable)resourceUnavailableException);
        }
        return null;
    }

    private Agent getAgent(long l) throws ResourceUnavailableException, DataException {
        return this.agentDM.get(l, null);
    }

    private ScheduleJobProxy getJobProxy(long l) throws ResourceUnavailableException, NoDataException {
        return this.scheduleJobDM.getScheduleJobProxy(l);
    }

    private JobSuiteMember getJobSuiteMember(long l) throws ResourceUnavailableException, NoDataException {
        return this.jobSuiteDM.getMember(l);
    }

    private AgentEventMonitor getAgentEventMonitor(long l) throws ResourceUnavailableException, DataException {
        return this.agentEventMonitorDM.get(l, null);
    }

    private SNMPTrapMonitor getSNMPTrapMonitor(long l) throws ResourceUnavailableException, DataException {
        return this.snmpTrapMonitorDM.get(l, null);
    }

    private RemoteEvent getRemoteEvent(long l) throws ResourceUnavailableException, DataException {
        return this.remoteEventDM.get(l);
    }

    private SAPEventMonitor getSAPEventMonitor(long l) throws ResourceUnavailableException, DataException {
        return this.sapEventMonitorDM.get(l, null);
    }

    private void checkDepJobs(PrerequisiteEntry[] prerequisiteEntryArray, AgentGroupType agentGroupType, long l, long l2) throws ResourceUnavailableException, NoDataException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < prerequisiteEntryArray.length; ++i) {
            Object object;
            String string = String.valueOf(prerequisiteEntryArray[i].getDepJobID()) + ".0";
            if (!prerequisiteEntryArray[i].isCheckDependencies()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Bypassing dependencies check for dep job key " + string + " (" + prerequisiteEntryArray[i] + ")"));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing dependencies check for dep job key " + string + " (" + prerequisiteEntryArray[i] + ")"));
            }
            if (hashSet.contains(string)) continue;
            ScheduleJobProxy scheduleJobProxy = this.getJobProxy(prerequisiteEntryArray[i].getDepJobID());
            String string2 = "Name: " + scheduleJobProxy.getName() + " Automate Schedule Job Number: " + scheduleJobProxy.getSkybotJobNumber() + " Target Type: " + scheduleJobProxy.getTargetType() + " Target ID: " + scheduleJobProxy.getTargetId() + " System ID: " + scheduleJobProxy.getSystem();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checkDepJobs -> Agent Group Type: " + agentGroupType + " DepJobInfo(" + string2 + ")"));
            }
            AgentGroupType agentGroupType2 = null;
            if (scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                try {
                    object = this.agentGroupDM.getProxy(scheduleJobProxy.getTargetId());
                    agentGroupType2 = object.getAgentGroupType();
                }
                catch (DataException dataException) {
                    throw new RuntimeException("Error loading Agent Group information.", dataException);
                }
            }
            if (scheduleJobProxy.isSuite()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Reactivity Check (suite)");
                }
                this.prereqEvaluator.prereqEvent(scheduleJobProxy, scheduleJobProxy.getSystem());
            } else if (agentGroupType2 == AgentGroupType.PREFERRED_AGENT || agentGroupType2 == AgentGroupType.UTILIZATION_BALANCED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Reactivity Check - Dep Job on Balanced Agent Group.");
                }
                this.prereqEvaluator.prereqEvent(scheduleJobProxy, scheduleJobProxy.getSystem());
            } else if (scheduleJobProxy.getSystem() != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reactivity Check - Dep Job Agent ID: " + scheduleJobProxy.getSystem()));
                }
                this.prereqEvaluator.prereqEvent(scheduleJobProxy, scheduleJobProxy.getSystem());
            } else if (agentGroupType == AgentGroupType.ALL_AGENTS && l != 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reactivity Check - Prereq Agent ID: " + l));
                }
                this.prereqEvaluator.prereqEvent(scheduleJobProxy, LongConverter.intValue((long)l));
            } else {
                object = this.agentGroupDM.getAgentsIDsInGroup((long)scheduleJobProxy.getModel(), null);
                for (int j = 0; j < ((AgentGroupProxy)object).length; ++j) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reactivity Check - Agent Group Agent: " + (long)object[j]));
                    }
                    this.prereqEvaluator.prereqEvent(scheduleJobProxy, (int)object[j]);
                }
            }
            hashSet.add(string);
        }
    }

    private void cleanup() {
        logger.debug((Object)"Cleaning Up the Reactivity Monitor.");
        if (this.prerequisiteEntryList != null) {
            this.prerequisiteEntryList.close();
        }
        if (this.prerequisiteMarkerList != null) {
            this.prerequisiteMarkerList.close();
        }
        if (this.prereqEventList != null) {
            this.prereqEventList.close();
        }
        if (this.prereqEvaluator != null) {
            this.prereqEvaluator.shutDown();
            this.prereqEvaluator = null;
        }
    }

    private String agentTimezoneID(long l) {
        String string;
        try {
            Agent agent = this.agentDM.get(l);
            string = agent.getTimeZone();
        }
        catch (Exception exception) {
            TimeZone timeZone = this.serverTimeZone();
            string = timeZone.getID();
            String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
            logger.error((Object)string2, (Throwable)exception);
        }
        return string;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (this.sleeping) {
                this.waitLock.notify();
            } else {
                this.moreToDo = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.waitLock;
        synchronized (object) {
            if (this.sleeping) {
                this.waitLock.notify();
            }
        }
        object = currentReactivityMonitorLock;
        synchronized (object) {
            currentReactivityMonitor = null;
        }
        logger.trace((Object)"Reactivity shutdown requested!");
    }

    @Override
    public boolean isShuttingDown() {
        return this.shutdown;
    }

    @Override
    public String getName() {
        return "Reactivity Monitor";
    }
}

