"use strict";

const fs = require('fs');
/**
 * This hook is called when a user uses the SDK to import a bot.
 * You can read the content of the temporary folder to analyze the bot's content. You can also change the content.
 *
 * To cancel the import, set the value `hookResult.allowImport = false`
 *
 * @param bp The botpress SDK
 * @param botId The ID of the bot
 * @param tmpFolder The submitted archive is extracted in this folder.
 */


const validateImport = async () => {
  // Read the files from the extracted archive. Check for prohibited files, etc.
  const files = fs.readdirSync(tmpFolder); // If you want to abort the import operation:
  // hookResult.allowImport = false
};

return validateImport();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi5pbXBvcnRfdmFsaWRhdGlvbnMuanMiXSwibmFtZXMiOlsiZnMiLCJyZXF1aXJlIiwidmFsaWRhdGVJbXBvcnQiLCJmaWxlcyIsInJlYWRkaXJTeW5jIiwidG1wRm9sZGVyIl0sIm1hcHBpbmdzIjoiOztBQUFBLE1BQU1BLEVBQUUsR0FBR0MsT0FBTyxDQUFDLElBQUQsQ0FBbEI7QUFFQTs7Ozs7Ozs7Ozs7O0FBVUEsTUFBTUMsY0FBYyxHQUFHLFlBQVk7QUFDakM7QUFDQSxRQUFNQyxLQUFLLEdBQUdILEVBQUUsQ0FBQ0ksV0FBSCxDQUFlQyxTQUFmLENBQWQsQ0FGaUMsQ0FJakM7QUFDQTtBQUNELENBTkQ7O0FBUUEsT0FBT0gsY0FBYyxFQUFyQiIsInNvdXJjZVJvb3QiOiIvdmFyL2xpYi9qZW5raW5zL3dvcmtzcGFjZS9idWlsZC1saW51eC9tb2R1bGVzL2J1aWx0aW4vc3JjL2JhY2tlbmQiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBmcyA9IHJlcXVpcmUoJ2ZzJylcblxuLyoqXG4gKiBUaGlzIGhvb2sgaXMgY2FsbGVkIHdoZW4gYSB1c2VyIHVzZXMgdGhlIFNESyB0byBpbXBvcnQgYSBib3QuXG4gKiBZb3UgY2FuIHJlYWQgdGhlIGNvbnRlbnQgb2YgdGhlIHRlbXBvcmFyeSBmb2xkZXIgdG8gYW5hbHl6ZSB0aGUgYm90J3MgY29udGVudC4gWW91IGNhbiBhbHNvIGNoYW5nZSB0aGUgY29udGVudC5cbiAqXG4gKiBUbyBjYW5jZWwgdGhlIGltcG9ydCwgc2V0IHRoZSB2YWx1ZSBgaG9va1Jlc3VsdC5hbGxvd0ltcG9ydCA9IGZhbHNlYFxuICpcbiAqIEBwYXJhbSBicCBUaGUgYm90cHJlc3MgU0RLXG4gKiBAcGFyYW0gYm90SWQgVGhlIElEIG9mIHRoZSBib3RcbiAqIEBwYXJhbSB0bXBGb2xkZXIgVGhlIHN1Ym1pdHRlZCBhcmNoaXZlIGlzIGV4dHJhY3RlZCBpbiB0aGlzIGZvbGRlci5cbiAqL1xuY29uc3QgdmFsaWRhdGVJbXBvcnQgPSBhc3luYyAoKSA9PiB7XG4gIC8vIFJlYWQgdGhlIGZpbGVzIGZyb20gdGhlIGV4dHJhY3RlZCBhcmNoaXZlLiBDaGVjayBmb3IgcHJvaGliaXRlZCBmaWxlcywgZXRjLlxuICBjb25zdCBmaWxlcyA9IGZzLnJlYWRkaXJTeW5jKHRtcEZvbGRlcilcblxuICAvLyBJZiB5b3Ugd2FudCB0byBhYm9ydCB0aGUgaW1wb3J0IG9wZXJhdGlvbjpcbiAgLy8gaG9va1Jlc3VsdC5hbGxvd0ltcG9ydCA9IGZhbHNlXG59XG5cbnJldHVybiB2YWxpZGF0ZUltcG9ydCgpXG4iXX0=