"use strict";

async function hook() {
  if (event.type === 'session_reference' && event.payload.signature && event.payload.text) {
    const verifySignature = await bp.security.getMessageSignature(event.payload.text);

    if (event.payload.signature === verifySignature) {
      Object.assign(event.state.session, {
        reference: event.payload.text
      });
      event.setFlag(bp.IO.WellKnownFlags.SKIP_DIALOG_ENGINE, true);
      event.setFlag(bp.IO.WellKnownFlags.FORCE_PERSIST_STATE, true);
    }
  }
}

return hook();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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