"use strict";

/**
 * Get number of conversations
 * @title Get number of conversations
 * @category Storage
 * @author Botpress, Inc.
 * @param {string} output - The state variable to output the count to
 */
const getNumberOfConversations = async output => {
  const userId = event.target;
  const botId = event.botId;
  const key = bp.kvs.getUserStorageKey(userId, 'numberOfConversations');
  const value = await bp.kvs.getStorageWithExpiry(botId, key);
  temp[output] = value;
};

return getNumberOfConversations(args.output);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdldE51bWJlck9mQ29udmVyc2F0aW9ucy5qcyJdLCJuYW1lcyI6WyJnZXROdW1iZXJPZkNvbnZlcnNhdGlvbnMiLCJvdXRwdXQiLCJ1c2VySWQiLCJldmVudCIsInRhcmdldCIsImJvdElkIiwia2V5IiwiYnAiLCJrdnMiLCJnZXRVc2VyU3RvcmFnZUtleSIsInZhbHVlIiwiZ2V0U3RvcmFnZVdpdGhFeHBpcnkiLCJ0ZW1wIiwiYXJncyJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7OztBQU9BLE1BQU1BLHdCQUF3QixHQUFHLE1BQU1DLE1BQU4sSUFBZ0I7QUFDL0MsUUFBTUMsTUFBTSxHQUFHQyxLQUFLLENBQUNDLE1BQXJCO0FBQ0EsUUFBTUMsS0FBSyxHQUFHRixLQUFLLENBQUNFLEtBQXBCO0FBQ0EsUUFBTUMsR0FBRyxHQUFHQyxFQUFFLENBQUNDLEdBQUgsQ0FBT0MsaUJBQVAsQ0FBeUJQLE1BQXpCLEVBQWlDLHVCQUFqQyxDQUFaO0FBQ0EsUUFBTVEsS0FBSyxHQUFHLE1BQU1ILEVBQUUsQ0FBQ0MsR0FBSCxDQUFPRyxvQkFBUCxDQUE0Qk4sS0FBNUIsRUFBbUNDLEdBQW5DLENBQXBCO0FBRUFNLEVBQUFBLElBQUksQ0FBQ1gsTUFBRCxDQUFKLEdBQWVTLEtBQWY7QUFDRCxDQVBEOztBQVNBLE9BQU9WLHdCQUF3QixDQUFDYSxJQUFJLENBQUNaLE1BQU4sQ0FBL0IiLCJzb3VyY2VSb290IjoiL3Zhci9saWIvamVua2lucy93b3Jrc3BhY2UvYnVpbGQtbGludXgvbW9kdWxlcy9idWlsdGluL3NyYy9iYWNrZW5kIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBHZXQgbnVtYmVyIG9mIGNvbnZlcnNhdGlvbnNcbiAqIEB0aXRsZSBHZXQgbnVtYmVyIG9mIGNvbnZlcnNhdGlvbnNcbiAqIEBjYXRlZ29yeSBTdG9yYWdlXG4gKiBAYXV0aG9yIEJvdHByZXNzLCBJbmMuXG4gKiBAcGFyYW0ge3N0cmluZ30gb3V0cHV0IC0gVGhlIHN0YXRlIHZhcmlhYmxlIHRvIG91dHB1dCB0aGUgY291bnQgdG9cbiAqL1xuY29uc3QgZ2V0TnVtYmVyT2ZDb252ZXJzYXRpb25zID0gYXN5bmMgb3V0cHV0ID0+IHtcbiAgY29uc3QgdXNlcklkID0gZXZlbnQudGFyZ2V0XG4gIGNvbnN0IGJvdElkID0gZXZlbnQuYm90SWRcbiAgY29uc3Qga2V5ID0gYnAua3ZzLmdldFVzZXJTdG9yYWdlS2V5KHVzZXJJZCwgJ251bWJlck9mQ29udmVyc2F0aW9ucycpXG4gIGNvbnN0IHZhbHVlID0gYXdhaXQgYnAua3ZzLmdldFN0b3JhZ2VXaXRoRXhwaXJ5KGJvdElkLCBrZXkpXG5cbiAgdGVtcFtvdXRwdXRdID0gdmFsdWVcbn1cblxucmV0dXJuIGdldE51bWJlck9mQ29udmVyc2F0aW9ucyhhcmdzLm91dHB1dClcbiJdfQ==