"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _lodash = _interopRequireDefault(require("lodash"));

var _moment = _interopRequireDefault(require("moment"));

var _generate = _interopRequireDefault(require("nanoid/generate"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const dbFile = process.env.DB_PATH || './seed.sqlite';
const daysBack = 98;
const initialNumberOfUsers = 1000;
const interactionsPerDay = 1.5;
const retentionRate = 0.94;
const growthRate = 0.01;
const fixedDailyGrowth = 250;
const channels = ['facebook', 'slack'];
const distribution = {
  0: 5,
  1: 5,
  2: 5,
  3: 7,
  4: 10,
  5: 10,
  6: 20,
  7: 30,
  8: 70,
  9: 65,
  10: 20,
  11: 30,
  12: 35,
  13: 23,
  14: 20,
  15: 35,
  16: 65,
  17: 70,
  18: 75,
  19: 30,
  20: 25,
  21: 20,
  22: 9,
  23: 8
};
const users = [];

const vary = (nb, variance = 0.1) => {
  return nb + _lodash.default.random(-variance * nb, variance * nb, false);
};

const dropUsers = count => {
  count = parseInt(count);

  const removeAt = _lodash.default.uniq(_lodash.default.times(count, () => _lodash.default.random(0, users.length)));

  _lodash.default.pullAt(users, removeAt);

  console.log('Removed ~', count, 'users');
};

const generateName = () => {
  return (0, _generate.default)(_lodash.default.random(5, 20, false));
};

const addUsers = (count, knex, date) => {
  count = parseInt(count);
  const rows = [];

  for (let i = 0; i < count; i++) {
    const channel = _lodash.default.sample(channels);

    const id = _lodash.default.uniqueId();

    const first_name = {
      key: 'first_name',
      value: generateName(),
      type: 'string'
    };
    const last_name = {
      key: 'last_name',
      value: generateName(),
      type: 'string'
    };
    const gender = {
      key: 'gender',
      value: Math.random() < vary(0.65, 0.35) ? 'male' : 'female',
      type: 'string'
    };
    const locale = {
      key: 'locale',
      value: _lodash.default.sample(['en_US', 'fr_CA', 'en_CA']),
      type: 'string'
    };
    const timezone = {
      key: 'timezone',
      value: _lodash.default.random(-6, 12, false),
      type: 'string'
    };
    const user = {
      user_id: id,
      channel: channel,
      attributes: JSON.stringify([first_name, last_name, gender, locale, timezone]),
      created_at: date
    };
    users.push(user);
    rows.push(user);
  }

  return knex.batchInsert('srv_channel_users', rows, 20).then(() => console.log('Added', count, 'users'));
};

const run = async knex => {
  const interactions = [];
  const startDate = (0, _moment.default)(new Date()).subtract(daysBack, 'days').toDate().toISOString();
  return addUsers(initialNumberOfUsers, knex, startDate).then(() => {
    return Promise.mapSeries(_lodash.default.times(daysBack, n => n + 1), day => {
      const i = daysBack - day;
      console.log('day', i);
      let count = 0;
      const target = vary(interactionsPerDay * users.length);

      while (count < target) {
        const hour = _lodash.default.random(1, 24, false);

        if (Math.random() > distribution[hour] / 100) {
          continue;
        }

        const time = (0, _moment.default)(new Date()).startOf('day').subtract(i, 'days').add(hour - 1, 'hours').toDate().toISOString();
        const direction = Math.random() > 0.3 ? 'in' : 'out';

        const user = _lodash.default.sample(users);

        interactions.push({
          ts: time,
          type: 'text',
          text: 'Random',
          user_id: user.user_id,
          channel: user.channel,
          direction: direction
        });
        count++;
      }

      dropUsers(vary((1 - retentionRate) * users.length, 0.13));
      const addDate = (0, _moment.default)(new Date()).subtract(i, 'days').toDate().toISOString();
      const nbNewUsers = vary(users.length * growthRate, 0.25) + vary(fixedDailyGrowth, 0.25);
      return addUsers(nbNewUsers, knex, addDate);
    });
  }).then(() => {
    console.log('Preparing to insert', interactions.length);
    return knex.batchInsert('analytics_interactions', interactions, 20).then(() => console.log('Added', interactions.length, 'interactions'));
  }).then(() => console.log('ALL DONE'));
};

if (_fs.default.existsSync(dbFile)) {
  _fs.default.unlinkSync(dbFile);
}

var _default = {
  run
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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