"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _default = async (bp, analytics) => {
  const router = bp.http.createRouterForBot('analytics');
  router.get('/graphs', async (req, res) => {
    const graphData = await analytics[req.params.botId].getChartsGraphData();
    res.send(graphData);
  });
  router.get('/metadata', async (req, res) => {
    const metadata = await analytics[req.params.botId].getAnalyticsMetadata();
    res.send(metadata);
  });
  router.post('/graphs', async (req, res) => {
    const fn = req.body.fn ? {
      fn: eval(req.body.fn)
    } : {};
    const fnAvg = req.body.fnAvg ? {
      fnAvg: eval(req.body.fnAvg)
    } : {};
    analytics[req.params.botId].custom.addGraph({ ...req.body,
      ...fn,
      ...fnAvg
    });
    res.end();
  });
  router.get('/custom_metrics', async (req, res) => {
    const metrics = await analytics[req.params.botId].custom.getAll(req.query.from, req.query.to);
    res.send(metrics);
  });
  const methods = ['increment', 'decrement', 'set'];
  methods.map(method => {
    router.post(`/custom_metrics/${method}`, async (req, res) => {
      const params = [req.body.name, ...(typeof req.body.count === 'number' ? [req.body.count] : [])];
      analytics[req.params.botId].custom[method](...params);
      res.end();
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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