import { LodashDecorator, ResolvableFunction } from './factory';
declare const decorator: (...args: any[]) => LodashDecorator;
/**
 * Creates a function that invokes func with arguments reversed. Honestly, there is probably not much
 * use for this decorator but maybe you will find one?
 *
 * @example
 *
 * class MyClass {
 *   value = 100;
 *
 *   @Flip('fn')
 *   fn2: (b: number, a: string) => [ number, string ];
 *
 *   fn(a: string, b: number): [ string, number ] {
 *     return [ a, b ];
 *   }
 * }
 *
 * const myClass = new MyClass();
 *
 * myClass.fn2(10, '20'); // => [ '20', 10 ]
 */
export declare function Flip(fn?: ResolvableFunction): LodashDecorator;
export { Flip as flip };
export default decorator;
