"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _api = _interopRequireDefault(require("./api"));

var _editor = _interopRequireDefault(require("./editor"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const editorByBot = {};

const onServerStarted = async bp => {};

const onServerReady = async bp => {
  await (0, _api.default)(bp, editorByBot);
};

const onBotMount = async (bp, botId) => {
  const config = await bp.config.getModuleConfig('code-editor');
  editorByBot[botId] = new _editor.default(bp, botId, config);
};

const onBotUnmount = async (bp, botId) => {
  delete editorByBot[botId];
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  definition: {
    name: 'code-editor',
    menuIcon: 'code',
    menuText: 'Code Editor',
    noInterface: false,
    fullName: 'Code Editor',
    homepage: 'https://botpress.io',
    experimental: true
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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