"use strict";

const _ = require('lodash'); // Make sure extractedSlots exists


event.state.session.extractedSlots = event.state.session.extractedSlots || {};
handleSlotsExpiry();
extractIntentSlots();

function extractIntentSlots() {
  const slots = _.flatten(_.values(event.nlu.slots)).filter(x => !!x.value); // only non-null slots


  for (let slot of slots) {
    // BETA(11.8.4): Prevent overwrite of the slot if explicitely demanded
    if (event.state.session.extractedSlots[slot.name] && event.state.session.extractedSlots[slot.name].overwritable == false) {
      continue;
    } // Slot is an array when the NLU is confused about the results
    // The array is sorted by confidence so we take the first index


    if (Array.isArray(slot)) {
      slot = slot[0];
    }

    event.state.session.extractedSlots.notFound = 0;
    event.setFlag(bp.IO.WellKnownFlags.FORCE_PERSIST_STATE, true);
    event.state.session.extractedSlots[slot.name] = { ...slot,
      timestamp: Date.now(),
      turns: 0,
      overwritable: true,
      expiresAfterTurns: false // BETA(11.8.4): Set this to a number to expire the slot after 'N' turns

    };
  }
}

function handleSlotsExpiry() {
  for (let slot of _.values(event.state.session.extractedSlots)) {
    if (typeof slot.turns === 'number') {
      ++slot.turns;
    } // BETA(11.8.4): Automatically expire the slot after X dialog turns


    if (typeof slot.expiresAfterTurns === 'number' && slot.turns >= slot.expiresAfterTurns) {
      delete event.state.session.extractedSlots[slot.name];
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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