"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var sdk = _interopRequireWildcard(require("botpress/sdk"));

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const setup = async bp => {
  const router = bp.http.createRouterForBot('basic-skills');
  router.get('/choice/config', async (req, res) => {
    const config = await bp.config.getModuleConfigForBot('basic-skills', req.params.botId);
    res.send(_lodash.default.pick(config, ['defaultContentElement', 'defaultContentRenderer', 'defaultMaxAttempts', 'matchNumbers']));
  });
  const config = await bp.config.getModuleConfig('basic-skills');

  const checkCategoryAvailable = async () => {
    const categories = await bp.cms.getAllContentTypes().map(c => c.id);

    if (!categories.includes(config.defaultContentElement)) {
      bp.logger.warn(`Configured to use Content Element "${config.defaultContentElement}", but it was not found.`);

      if (config.defaultContentElement === 'builtin_single-choice') {
        bp.logger.warn(`You should probably install (and use) the @botpress/builtins
  module OR change the "defaultContentElement" in this module's configuration to use your own content element.`);
      }

      return;
    }
  };

  if (!config.disableIntegrityCheck) {
    setTimeout(checkCategoryAvailable, 3000);
  }
};

const generateFlow = async (data, metadata) => {
  let onInvalidText = undefined;

  if (data.config.invalidText && data.config.invalidText.length) {
    onInvalidText = data.config.invalidText;
  }

  const maxAttempts = data.config.nbMaxRetries;
  const nodes = [{
    name: 'entry',
    onEnter: [{
      type: sdk.NodeActionType.RenderElement,
      name: `#!${data.contentId}`,
      args: {
        skill: 'choice'
      }
    }],
    next: [{
      condition: 'true',
      node: 'parse'
    }]
  }, {
    name: 'parse',
    onReceive: [{
      type: sdk.NodeActionType.RunAction,
      name: 'basic-skills/choice_parse_answer',
      args: data
    }],
    next: [{
      condition: `temp['skill-choice-valid'] === true`,
      node: '#'
    }, {
      condition: 'true',
      node: 'invalid'
    }]
  }, {
    name: 'invalid',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: 'basic-skills/choice_invalid_answer'
    }],
    next: [{
      condition: `temp['skill-choice-invalid-count'] <= ${maxAttempts}`,
      node: 'sorry'
    }, {
      condition: 'true',
      node: '#'
    }]
  }, {
    name: 'sorry',
    onEnter: [{
      type: sdk.NodeActionType.RenderElement,
      name: `#!${data.contentId}`,
      args: { ...{
          skill: 'choice'
        },
        ...(onInvalidText ? {
          text: onInvalidText
        } : {})
      }
    }],
    next: [{
      condition: 'true',
      node: 'parse'
    }]
  }];
  return {
    transitions: createTransitions(data),
    flow: {
      nodes: nodes,
      catchAll: {
        next: []
      }
    }
  };
};

const createTransitions = data => {
  const transitions = Object.keys(data.keywords).map(choice => {
    const choiceShort = choice.length > 8 ? choice.substr(0, 7) + '...' : choice;
    return {
      caption: `User picked [${choiceShort}]`,
      condition: `temp['skill-choice-ret'] == "${choice}"`,
      node: ''
    };
  });
  transitions.push({
    caption: 'On failure',
    condition: 'true',
    node: ''
  });
  return transitions;
};

var _default = {
  generateFlow,
  setup
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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