"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityDefCreateSchema = exports.IntentDefCreateSchema = exports.SlotsCreateSchema = exports.ID_REGEX = void 0;

var _joi = _interopRequireDefault(require("joi"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const ID_REGEX = /^[a-zA-Z0-9]+[A-Z0-9_-]{2,}$/i;
exports.ID_REGEX = ID_REGEX;

const SlotsCreateSchema = _joi.default.object().keys({
  name: _joi.default.string().required(),
  // @deprecated >11
  entity: _joi.default.string().optional(),
  entities: _joi.default.array().items(_joi.default.string()).required(),
  color: _joi.default.number().required(),
  id: _joi.default.string().required()
});

exports.SlotsCreateSchema = SlotsCreateSchema;

const IntentDefCreateSchema = _joi.default.object().keys({
  name: _joi.default.string().required(),
  utterances: _joi.default.array().items(_joi.default.string()).default([]),
  slots: _joi.default.array().items(SlotsCreateSchema).default([]),
  contexts: _joi.default.array().items(_joi.default.string()).default(['global'])
});

exports.IntentDefCreateSchema = IntentDefCreateSchema;

const EntityDefOccurenceSchema = _joi.default.object().keys({
  name: _joi.default.string().required(),
  synonyms: _joi.default.array().items(_joi.default.string())
});

const EntityDefCreateSchema = _joi.default.object().keys({
  id: _joi.default.string().regex(ID_REGEX).required(),
  name: _joi.default.string().required(),
  type: _joi.default.string().valid(['system', 'pattern', 'list']).required(),
  sensitive: _joi.default.boolean(),
  occurences: _joi.default.array().items(EntityDefOccurenceSchema).default([]),
  pattern: _joi.default.string().default('')
});

exports.EntityDefCreateSchema = EntityDefCreateSchema;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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