"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMiddleware = void 0;

require("bluebird-global");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EVENTS_TO_IGNORE = ['session_reference', 'session_reset', 'bp_dialog_timeout', 'visit', ''];

const registerMiddleware = async (bp, botScopedNlu) => {
  bp.events.registerMiddleware({
    name: 'nlu.incoming',
    direction: 'incoming',
    order: 10,
    description: 'Process natural language in the form of text. Structured data with an action and parameters for that action is injected in the incoming message event.',
    handler: async (event, next) => {
      const botCtx = botScopedNlu[event.botId];

      if (!botCtx || !event.preview || EVENTS_TO_IGNORE.includes(event.type) || event.hasFlag(bp.IO.WellKnownFlags.SKIP_NATIVE_NLU)) {
        return next();
      }

      try {
        const metadata = await botCtx.extract(event.preview, event.nlu.includedContexts);

        _lodash.default.merge(event, {
          nlu: metadata
        });

        removeSensitiveText(event);
      } catch (err) {
        bp.logger.warn('Error extracting metadata for incoming text: ' + err.message);
      } finally {
        next();
      }
    }
  });

  function removeSensitiveText(event) {
    if (!event.nlu.entities || !event.payload.text) {
      return;
    }

    try {
      const sensitiveEntities = event.nlu.entities.filter(ent => ent.sensitive);

      for (const entity of sensitiveEntities) {
        const stars = '*'.repeat(entity.data.value.length);
        event.payload.text = event.payload.text.replace(entity.data.value, stars);
      }
    } catch (err) {
      bp.logger.warn('Error removing sensitive informations: ' + err.message);
    }
  }
};

exports.registerMiddleware = registerMiddleware;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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