"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _api = _interopRequireDefault(require("./api"));

var _middleware = require("./middleware");

var _confusionEngine = _interopRequireDefault(require("./confusion-engine"));

var _models = _interopRequireDefault(require("./models"));

var _duckling_extractor = require("./pipelines/entities/duckling_extractor");

var _storage = _interopRequireDefault(require("./storage"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const nluByBot = {};

const onServerStarted = async bp => {
  _storage.default.ghostProvider = botId => botId ? bp.ghost.forBot(botId) : bp.ghost.forGlobal();

  const globalConfig = await bp.config.getModuleConfig('nlu');
  await _duckling_extractor.DucklingEntityExtractor.configure(globalConfig.ducklingEnabled, globalConfig.ducklingURL, bp.logger);
  await (0, _middleware.registerMiddleware)(bp, nluByBot);
};

const onServerReady = async bp => {
  await (0, _api.default)(bp, nluByBot);
  await (0, _models.default)(bp);
};

const onBotMount = async (bp, botId) => {
  const moduleBotConfig = await bp.config.getModuleConfigForBot('nlu', botId);
  const scoped = new _confusionEngine.default(bp.logger, botId, moduleBotConfig, bp.MLToolkit);
  await scoped.init();
  nluByBot[botId] = scoped;
};

const onBotUnmount = async (bp, botId) => {
  delete nluByBot[botId];
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('nlu.incoming');
  bp.http.deleteRouterForBot('nlu');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  definition: {
    name: 'nlu',
    moduleView: {
      stretched: true
    },
    menuIcon: 'fiber_smart_record',
    menuText: 'NLU',
    fullName: 'NLU',
    homepage: 'https://botpress.io'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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