"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _messenger = require("./messenger");

let service;

const onServerStarted = async bp => {
  service = new _messenger.MessengerService(bp);

  try {
    await service.initialize();
  } catch (err) {
    bp.logger.attachError(err).warn('Channel misconfigured');
  }
};

const onServerReady = bp => {};

const onBotMount = async (bp, botId) => {
  await service.mountBot(botId);
};

const onBotUnmount = async (bp, botId) => {
  await service.unmountBot(botId);
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('messenger.sendMessages');
  bp.http.deleteRouterForBot('channel-messenger');
};

const entryPoint = {
  onServerReady,
  onServerStarted,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  definition: {
    name: 'channel-messenger',
    noInterface: true,
    fullName: 'Messenger Channel'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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