"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertLastMessages = void 0;

const convertLastMessages = (lastMessages, eventId) => {
  if (!lastMessages) {
    return;
  }

  const lastConvo = eventId ? lastMessages.filter(x => x.eventId === eventId) : lastMessages;

  if (!lastConvo.length) {
    return;
  }

  return {
    userMessage: lastConvo[0].incomingPreview,
    botReplies: lastConvo.map(x => {
      return {
        // tslint:disable-next-line:no-null-keyword
        botResponse: x.replyPreview === undefined ? null : x.replyPreview,
        replySource: x.replySource
      };
    })
  };
};

exports.convertLastMessages = convertLastMessages;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInV0aWxzLnRzIl0sIm5hbWVzIjpbImNvbnZlcnRMYXN0TWVzc2FnZXMiLCJsYXN0TWVzc2FnZXMiLCJldmVudElkIiwibGFzdENvbnZvIiwiZmlsdGVyIiwieCIsImxlbmd0aCIsInVzZXJNZXNzYWdlIiwiaW5jb21pbmdQcmV2aWV3IiwiYm90UmVwbGllcyIsIm1hcCIsImJvdFJlc3BvbnNlIiwicmVwbHlQcmV2aWV3IiwidW5kZWZpbmVkIiwicmVwbHlTb3VyY2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBTyxNQUFNQSxtQkFBbUIsR0FBRyxDQUFDQyxZQUFELEVBQWVDLE9BQWYsS0FBMkI7QUFDNUQsTUFBSSxDQUFDRCxZQUFMLEVBQW1CO0FBQ2pCO0FBQ0Q7O0FBQ0QsUUFBTUUsU0FBUyxHQUFHRCxPQUFPLEdBQUdELFlBQVksQ0FBQ0csTUFBYixDQUFvQkMsQ0FBQyxJQUFJQSxDQUFDLENBQUNILE9BQUYsS0FBY0EsT0FBdkMsQ0FBSCxHQUFxREQsWUFBOUU7O0FBRUEsTUFBSSxDQUFDRSxTQUFTLENBQUNHLE1BQWYsRUFBdUI7QUFDckI7QUFDRDs7QUFFRCxTQUFPO0FBQ0xDLElBQUFBLFdBQVcsRUFBRUosU0FBUyxDQUFDLENBQUQsQ0FBVCxDQUFhSyxlQURyQjtBQUVMQyxJQUFBQSxVQUFVLEVBQUVOLFNBQVMsQ0FBQ08sR0FBVixDQUFjTCxDQUFDLElBQUk7QUFDN0IsYUFBTztBQUNMO0FBQ0FNLFFBQUFBLFdBQVcsRUFBRU4sQ0FBQyxDQUFDTyxZQUFGLEtBQW1CQyxTQUFuQixHQUErQixJQUEvQixHQUFzQ1IsQ0FBQyxDQUFDTyxZQUZoRDtBQUdMRSxRQUFBQSxXQUFXLEVBQUVULENBQUMsQ0FBQ1M7QUFIVixPQUFQO0FBS0QsS0FOVztBQUZQLEdBQVA7QUFVRCxDQXBCTSIsInNvdXJjZVJvb3QiOiIvdmFyL2xpYi9qZW5raW5zL3dvcmtzcGFjZS9idWlsZC1saW51eC9tb2R1bGVzL3Rlc3Rpbmcvc3JjL2JhY2tlbmQiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgY29uc3QgY29udmVydExhc3RNZXNzYWdlcyA9IChsYXN0TWVzc2FnZXMsIGV2ZW50SWQpID0+IHtcbiAgaWYgKCFsYXN0TWVzc2FnZXMpIHtcbiAgICByZXR1cm5cbiAgfVxuICBjb25zdCBsYXN0Q29udm8gPSBldmVudElkID8gbGFzdE1lc3NhZ2VzLmZpbHRlcih4ID0+IHguZXZlbnRJZCA9PT0gZXZlbnRJZCkgOiBsYXN0TWVzc2FnZXNcblxuICBpZiAoIWxhc3RDb252by5sZW5ndGgpIHtcbiAgICByZXR1cm5cbiAgfVxuXG4gIHJldHVybiB7XG4gICAgdXNlck1lc3NhZ2U6IGxhc3RDb252b1swXS5pbmNvbWluZ1ByZXZpZXcsXG4gICAgYm90UmVwbGllczogbGFzdENvbnZvLm1hcCh4ID0+IHtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIC8vIHRzbGludDpkaXNhYmxlLW5leHQtbGluZTpuby1udWxsLWtleXdvcmRcbiAgICAgICAgYm90UmVzcG9uc2U6IHgucmVwbHlQcmV2aWV3ID09PSB1bmRlZmluZWQgPyBudWxsIDogeC5yZXBseVByZXZpZXcsXG4gICAgICAgIHJlcGx5U291cmNlOiB4LnJlcGx5U291cmNlXG4gICAgICB9XG4gICAgfSlcbiAgfVxufVxuIl19