#!/bin/sh
# Copyright (C) 2009 Help/Systems LLC, All Rights Reserved


WORKING_DIR=`dirname $0`
RUNJAVA_DIR=`dirname $WORKING_DIR`
logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.module.webservice.WebServiceWorker"
DEV_MODE="false"
# ------------------------------------------------------------------------
# Function: Log an info message                                         -
# ------------------------------------------------------------------------
logInfo() {
  echo "$1"
}

# ------------------------------------------------------------------------
# Function: Log an error message                                         -
# ------------------------------------------------------------------------
logError() {
  printf "$1\n">&2
}


# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText(){
  logInfo ""
  logInfo "Help for: $0"
  logInfo ""
  logInfo "Web Service $0 allows these actions:"
  logInfo ""
  logInfo "     find_id_by_name, stop, restart, lock, unlock,"
  logInfo "     hold_job_queue, release_job_queue"
  logInfo ""
  logInfo "All Automate Schedule object names are case sensitive."
  logInfo ""
  logInfo "------------------------ The Web Service Parameters ------------------------"  
  logInfo ""
  logInfo "     -serverurl=<server url>   The Automate Schedule server url"
  logInfo "                               for the request - Required"
  logInfo "     -password=<password>      The Automate Schedule password - Required"
  logInfo "     -username=<username>      The Automate Schedule user name - Required"
  logInfo "     -name=<agent name>        The agent name - Required"
  logInfo "     -action=<action>          The actions for Agent (find_id_by_name,"
  logInfo "                               stop, restart, lock, unlock,"
  logInfo "                               hold_job_queue, release_job_queue) - Required"
  logInfo "     -configfile=<file>        The configuration file."
  logInfo "     -ssl=<ssl>                Use 'any' to accept all SSL certificates"
  logInfo "                               (used with https only)."
  logInfo "------------------------ END Web Service Parameters ------------------------"
  logInfo ""
  logInfo "     Example: $0"
  logInfo "                -serverurl=http://localhost:8008"
  logInfo "                -password=admin -username=admin"
  logInfo "                -name=agent_name -action=hold_job_queue"
  logInfo ""
  logInfo "---------------- The default configuration file parameters -----------------"  
  logInfo ""
  logInfo "     serverurl=<server url> The Automate Schedule server url for the request"
  logInfo "     password=<password>    The Automate Schedule password"
  logInfo "     username=<username>    The Automate Schedule user name"
  logInfo ""
  logInfo "---------------- END default configuration file parameters -----------------"
  logInfo ""
  logInfo "     Example:"
  logInfo "        serverurl=http://localhost:8008"
  logInfo "        username=admin"
  logInfo "        password=admin"
  logInfo ""
  logInfo "     -h, /h, -? or /?   Show help information"
  logInfo ""
  logInfo ""
}


PATH=$PATH:/usr/ucb

allArgs=$@

if [ $# -eq 0 ]; then
  showHelpText
  exit 1
fi

for i in "${@}"
do
    if [ "$i" = "-h" -o "$i" = "--help" -o "$i" = "-?" -o "$i" = "/h" -o "$i" = "/?" ]; then
        showHelpText
        exit 1
    fi
done

if [ ${RUNJAVA_DIR} = "." ]; then
 RUNJAVA_DIR=".."
fi

${RUNJAVA_DIR}/runjava.sh $MAIN_CLASS -type="agents" -devmode=${DEV_MODE} "$@"
