#!/bin/sh
# Copyright (C) 2017 HelpSystems, LLC, All Rights Reserved


WORKING_DIR=`dirname $0`
logDebug="false"
MAIN_CLASS="com.helpsystems.enterprise.module.informatica.InformaticaWorker"

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText(){
echo  " 
 ----------------------- The Repository Parameters -------------------------------
      -domain:^<domain^>                                       The Domain - Required
      -port:^<port^>                                           The port - Default value is 7333
      -systemName:^<system name/ip^>                           The System Name/IP - Required
      -username:^<username^>                                   The repository username-Required
      -password:^<password^>                                   The Repository password - Required 
      -passwordSalt:^<password salt^>                          If passed encrypted password password salt must be past as well
      -userNameSpace:^<user name space^>                       The user name space-Default value is NULL
      -securityDomain:^<security domain^>                      The Security Domain
      -repoName:^<repository name^>                            The Repository name - Required
      -useHTTPS:^<use https^>                                  Use Https[yes:no]

       ----------------------- End Repository Parameters ---------------------------------
       ----------------------- The workflow Parameters -----------------------------------
      -intSvcName:^<integration service name^>               The Integration Service Name - Required
      -folderName:^<Folder Name^>                            The Folder Name - Required
      -wfName:^<Workflow Name^>                              The Workflow Name - Required
      -runInstanceName:^<Run Intsnace Name^>                 The Run Instance Name
      -taskInstancePath:^<Task Instance Path^>               The Task Instance Path
      -runOnly:^<Run Task^>                                  The Run Task [yes:no] 
      -osUser:^<OS User^>                                    The OS User 
      -paramFile:^<Parameter file name^>                     The Paramtere File Name
      -wfParam^<Parameter name value scope^>                 Parameter's name value and scope
      -abort:^<Abort^>                                       Abort[yes:no]
      -requestMode:^<request mode^>                          Request Mode[NORMAL:RECOVERY]
      -retrieveLog:^<Retrieve log^>                          Retrieve log[yes:no]
       ----------------------- END Workflow Parameters ------------------------------------
      ----------------------- The Automate Schedule Parameters --------------------------------------
       -jobNumber:^<Job Number ^>                The Job Run Number
       -jobName:^<Job Name ^>                    The Job Name
      ----------------------- END Automate Schedule Parameters --------------------------------------

      -h, /h, -? or /?   Show help information
   This function can only be run on the executed Agent.
    Example: $0 -domain:"Domain_tripp" -systemName:"172.16.5.108" -username:"armenia" -port:"7333" -password:"automate2017" -repoName:"pc_repo" -folderName:"NEWFOLDER0" -wfName:"test123" -runInstanceName:"JOB_1353332870018"  -intSvcName:"pc_is" -jobNumber:"7654321" -jobName:"automatejob"  -domain:"Domain_tripp" -systemName:"172.16.5.108" -username:"armenia" -port:"7333" -password:"automate2017" -repoName:"pc_repo" -folderName:"NEWFOLDER0" -wfName:"test123" -runInstanceName:"JOB_1353332870018"  -intSvcName:"pc_is" -jobNumber:"7654321" -jobName:"automatejob" -wfParam "name" "value" "scope"  

      -h, /h, -? or /?   Show help information"
  
}

PATH=$PATH:/usr/ucb

allArgs=$@

for i in "${@}"
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done

${WORKING_DIR}/runjava.sh $MAIN_CLASS "$@"
