#!/usr/bin/perl

# Uses perl to exec a shell as a login shell so that it will pick up
#   the user's login scripts and environment.
# Copyright (C) 2012 Help/Systems, LLC.

use strict;
use Carp;

my $whoami;
chomp($whoami = `whoami`);
if ( $whoami eq '') {
    chomp($whoami = `/usr/ucb/whoami`);
}

my $uname;
chomp($uname = `uname`);

my $userInfo;

if ( $uname eq 'Darwin' ) {
    my @output = `dscacheutil -q user -a name $whoami`;
    my %info = ();
    foreach my $line (@output) {
        my ($key,$value) = split /: /, $line;
        chomp($info{$key} = $value);
    }
    $userInfo = "$whoami:_pw_:%info{'uid'}:$info{'gid'}:_ignored_:$info{'dir'}:$info{'shell'}";

} else {
    $userInfo = `grep -i ^$whoami: /etc/passwd`;
}

if ( length($userInfo) == 0 ) {
    # try NIS
    my $ypw='yp.pw';
    if ( -f $ypw) {
        system("rm $ypw") == 0 || die("Unable to remove temp file $ypw");
    }
    system("ypcat passwd > $ypw 2> /dev/null");
    if ( -f $ypw) {
        $userInfo = `grep -i "^$whoami:" $ypw`;
    }
    system("rm $ypw");
}

my $fullshell;
if ( length($userInfo) > 0 ) {
    my ($user, $pw, $uid, $gid, $ignored, $dir, $shell) = split /:/, $userInfo;
    $fullshell = $shell;
    chomp($dir);
    chomp($shell);
    chomp($user);
    $ENV{'HOME'} = $dir;
    $ENV{'SHELL'} = $shell;
    $ENV{'LOGNAME'} = $user;
    $ENV{'USER'} = $user;
} else {
    die("Unable to resolve user info for $whoami");
}
chomp($fullshell);

if ($fullshell eq '') {
    die("Unable to resolve the login shell for $whoami");
}

my @pieces = split /\//, $fullshell;
my $theshell = $pieces[-1];

#exec the shell as a login shell
exec $fullshell "-$theshell";



