#!/bin/sh
#
# Starts and Stops the Automate Schedule Server or Agent. This script
# uses the name by which it was invoked to determine whether
# it should control the server or the agent

# the directory in which Automate Schedule is installed
SKYBOT_DIR=/opt/automate-schedule

# the user who should start/own the automate schedule process
SKYBOT_USER=automate

# Look at the name by which this script was invoked
IS_SERVER=`echo $0 | grep -i -c server`
IS_AGENT=`echo $0 | grep -i -c agent`

if [ $IS_AGENT -eq 0 -a $IS_SERVER -eq 0 ]; then
    echo "Unable to control Automate Schedule - the file entry \'$0\' needs to contain 'server' or 'agent'"
    exit $RETVAL
fi

if [ $IS_AGENT -eq 1 -a $IS_SERVER -eq 1 ]; then
    echo "Unable to control Automate Schedule - the file entry \'$0\' cannot contain both 'server' and 'agent'"
    exit $RETVAL
fi

if [ $IS_SERVER -eq 1 ]; then
    SUBDIR=server
    START_SCRIPT=startscheduler.sh
    STOP_SCRIPT=stopscheduler.sh
    MESSAGE=Server
    USE_NOPWD=0
fi

if [ $IS_AGENT -eq 1 ]; then
    SUBDIR=agent
    START_SCRIPT=start.sh
    STOP_SCRIPT=stop.sh
    MESSAGE=Agent
    USE_NOPWD=`echo $0 | grep -i -c nopwd`
fi


if [ ! -d $SKYBOT_DIR ]; then
    echo "Automate Schedule $MESSAGE directory $SKYBOT_DIR not found"
    exit $RETVAL
fi

if [ ! -d $SKYBOT_DIR/$SUBDIR ]; then
    echo "Automate Schedule $MESSAGE directory $SKYBOT_DIR/$SUBDIR not found"
    exit $RETVAL
fi

skyStart() {
    LOG=$SKYBOT_DIR/$SUBDIR/autostart.log
    echo "Starting Automate Schedule $MESSAGE ..."
    su $SKYBOT_USER -c "$SKYBOT_DIR/$SUBDIR/$START_SCRIPT > $LOG  2>&1 &"
    if [ $USE_NOPWD -eq 1 ]; then
        sleep 10
        cd $SKYBOT_DIR/$SUBDIR; ./allownopwd.sh
    fi
    return $RETVAL
}

skyStop() {
    echo "Stopping Automate Schedule $MESSAGE ..."
    su $SKYBOT_USER $SKYBOT_DIR/$SUBDIR/$STOP_SCRIPT
    return $RETVAL
}

skyRestart() {
    skyStop
    sleep 30
    skyStart
}


case "$1" in
  start)
        skyStart
        ;;
  stop)
        skyStop
        ;;
  restart)
        skyRestart
        ;;
  *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
esac

exit $?
