/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.MissedJobsAccountant;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.ForecastAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobStartEndRollupDM;
import com.helpsystems.enterprise.core.dm.JobStatusCountRollupDM;
import com.helpsystems.enterprise.core.dm.JobSuiteAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class JobSubmitter {
    private static final Logger logger = Logger.getLogger(JobSubmitter.class);
    private ScheduleJobDM scheduleJobDM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private ActivityMatcherAM activityMatcherAM;
    private JobStartEndRollupDM jobStartEndRollupDM;
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private PrereqDM prereqDM;
    private JobSuiteAM jobSuiteAM;
    private JobSuiteDM jobSuiteDM;
    private JobStatusCountRollupDM jobStatusCountRollupDM;
    private SAPInterceptedJobsDM sapInterceptedJobsDM;

    public JobSubmitter(ScheduleJobDM scheduleJobDM) {
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        this.scheduleJobDM = scheduleJobDM;
        this.init();
    }

    private void init() {
        this.jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManager((String)"ENTERPRISE.JobMonitorManagerAM");
        this.activityMatcherAM = (ActivityMatcherAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ActivityMatcherAM");
        this.jobStartEndRollupDM = (JobStartEndRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobStartEndRollupDM");
        this.jobStatusCountRollupDM = (JobStatusCountRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobStatusCountRollupDM");
        this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        this.prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
        this.jobSuiteAM = (JobSuiteAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteAM");
        this.jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteDM");
    }

    public boolean submit(int n, int n2, JobInfo jobInfo, Date date, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        return this.submitJobOrSuite(n, n2, jobInfo, date, calendar, jobInitCode, string, bl, scheduleJobProxy);
    }

    public boolean submit(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        return this.submitJobOrSuite(n, n2, jobInfo, date, calendar, jobInitCode, string, bl, scheduleJobProxy);
    }

    private boolean submitJobOrSuite(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        JobType jobType = scheduleJobProxy.getJobType();
        if (jobType == JobType.SUITE) {
            logger.debug((Object)MessageUtil.formatMsg((String)"Starting suite {0}.", (Object[])new Object[]{jobInfo.getJobNameOrID()}));
            if (this.isSuiteHeldOrSkipped(n, n2, jobInfo, date, calendar, jobInitCode, string, bl, scheduleJobProxy)) {
                return false;
            }
            return this.jobSuiteAM.startSuite((long)n, jobInfo.getJobName(), date, calendar, jobInitCode, string, bl, scheduleJobProxy.getJobParameters());
        }
        logger.debug((Object)MessageUtil.formatMsg((String)"Submitting job {0} on agent {1}.", (Object[])new Object[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID()}));
        if (this.isJobHeldOrSkipped(n, n2, jobInfo, date, calendar, jobInitCode, string, bl, scheduleJobProxy)) {
            return false;
        }
        return this.submitJob(n, n2, jobInfo, date, calendar, jobInitCode, string, bl, scheduleJobProxy);
    }

    private boolean submitJob(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        ScheduleLogEntry scheduleLogEntry;
        MovedNST movedNST;
        JobTrackerAM jobTrackerAM = null;
        long l = System.currentTimeMillis();
        long l2 = 180000L;
        while (jobTrackerAM == null && l < l + l2) {
            try {
                jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
            }
            catch (NullPointerException nullPointerException) {
                logger.debug((Object)"The Job Tracker is not available yet.");
            }
            if (jobTrackerAM != null) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)("Interrupted: The Job Tracker is not available yet, job " + n + " will be skipped..."));
                return false;
            }
        }
        if (jobTrackerAM == null) {
            logger.debug((Object)"The Job Tracker is not available yet, job will be skipped...");
            return false;
        }
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobID((long)n);
        jobHistory.setJobName(jobInfo.getJobName());
        jobHistory.setAgentID((long)n2);
        jobHistory.setAgentName(jobInfo.getAgentName());
        jobHistory.setAgentGroupID((long)jobInfo.getAgentGroupID());
        jobHistory.setAgentGroupName(jobInfo.getAgentGroupName());
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setJobQueueID(scheduleJobProxy.getJobQueueID());
        jobHistory.setJobQueueName(scheduleJobProxy.getJobQueueName());
        if (bl) {
            jobHistory.setMissedCode(JobMissedCode.MISSED);
        }
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        try {
            jobHistoryDM.setTimezoneValues(jobHistory, (long)n2, (long)n, scheduleJobProxy, null);
        }
        catch (DataException dataException) {
            logger.error((Object)"Error setting timezone values.", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error setting timezone values.", (Throwable)resourceUnavailableException);
        }
        if (string != null) {
            jobHistory.setInitiationData(string);
        }
        if (calendar != null) {
            jobHistory.setScheduledTime(calendar.getTimeInMillis());
            if (calendar instanceof MovedNST) {
                movedNST = (MovedNST)calendar;
                jobHistory.setMovedFromScheduledDateTime(movedNST.getOriginalDateTimeYYYYMMDDHHMM());
            }
        } else {
            jobHistory.setScheduledTime(date.getTime());
        }
        jobHistory.setInitiationCode(jobInitCode);
        jobHistory.setJobPriority(scheduleJobProxy.getDefaultPriority());
        jobHistory.setJobParameters(scheduleJobProxy.getJobParameters());
        movedNST = (ForecastAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.ForecastAM");
        long l3 = movedNST.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
        jobHistory.setEstimatedRuntime(l3);
        try {
            jobHistory = jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Job Submitter was unable to save new job history info", (Throwable)exception);
            return false;
        }
        jobHistory.setAgentEnvironmentType(scheduleJobProxy.getAgentEnvironmentType());
        try {
            jobTrackerAM.submitJob(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"JTAM Submit failed.", (Throwable)exception);
            return true;
        }
        this.activityMatcherAM.jobSubmitted((long)n, JobType.JOB, (long)n2, jobHistory.getId(), jobInitCode, jobHistory.getScheduledTime());
        String string2 = String.valueOf(jobHistory.getId());
        if (calendar != null) {
            String[] stringArray = new String[]{jobHistory.getJobName(), jobInitCode.toString(), ScheduleLogger.formatTimeStamp((Calendar)calendar), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp((Date)date), string2};
            scheduleLogEntry = RosettaMsg.SUBMITTED_SCHEDULED_JOB.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
        } else {
            String[] stringArray = new String[]{jobHistory.getJobName(), jobInitCode.toString(), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp((Date)date), string2};
            scheduleLogEntry = RosettaMsg.SUBMITTED_JOB.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
        }
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        return true;
    }

    public void submitSAPIntercept(SAPInterceptedJob sAPInterceptedJob, int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl) {
        ScheduleLogEntry scheduleLogEntry;
        MovedNST movedNST;
        JobHistoryDM jobHistoryDM;
        ScheduleJobProxy scheduleJobProxy;
        block35: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Submitting job " + jobInfo.getJobNameOrID() + " on agent " + jobInfo.getAgentNameOrID() + " to run an SAP intercepted job."));
            }
            scheduleJobProxy = null;
            try {
                if (jobInitCode != JobInitCode.SCHEDULE && jobInitCode != JobInitCode.REACTIVE && jobInitCode != JobInitCode.SCHEDULED_WITH_PREREQS) break block35;
                scheduleJobProxy = this.getScheduleJobProxy(n);
                if (this.isJobHeld(scheduleJobProxy, jobInfo, calendar, n2)) {
                    if (scheduleJobProxy.isLateStartMonitorSelected()) {
                        this.jobMonitorManagerAM.jobIsHeld(n, jobInfo.getAgentID(), calendar);
                    }
                    this.activityMatcherAM.jobSkipped_IsHeld((long)n, scheduleJobProxy.getJobType(), (long)n2, jobInitCode, calendar.getTimeInMillis());
                    sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.HELD);
                    this.updateSAPInterceptedJobRecord(sAPInterceptedJob, null);
                    return;
                }
                if (!scheduleJobProxy.isSkipOnNotCompleted()) break block35;
                try {
                    jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
                    if (jobHistoryDM.hasActiveStatus((long)n2, scheduleJobProxy.getSkybotJobNumber())) {
                        String[] stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID()};
                        ScheduleLogEntry scheduleLogEntry2 = RosettaMsg.JOB_ALREADY_ACTIVE.newLogEntry(stringArray, (long)n2, (long)n);
                        long l = 0L;
                        JobHistory jobHistory = null;
                        if (scheduleJobProxy.isGenerateSkippedHistory()) {
                            int n3 = scheduleJobProxy.getDefaultPriority();
                            jobHistory = new JobHistory();
                            JobMissedCode jobMissedCode = bl ? JobMissedCode.SKIPPED_AFTER_MISS : JobMissedCode.SKIPPED;
                            l = this.createSkippedHistory(jobHistory, n, n2, jobInfo, date, calendar, jobInitCode, JobEndedReasonCode.ALREADY_ACTIVE, n3, string, jobMissedCode, scheduleJobProxy.getJobType(), scheduleJobProxy);
                            JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
                            jobTrackerAM.notifyOfJobStatus(jobHistory, null, scheduleLogEntry2.getMessageText());
                            this.prereqDM.resetPrereqStatus(jobHistory.getAgentID(), jobHistory.getJobID(), PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, jobHistory.getId());
                        }
                        if (l > 0L) {
                            scheduleLogEntry2.setJobHistoryID(l);
                        }
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry2);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)scheduleLogEntry2.getMessageText());
                        }
                        if (scheduleJobProxy.isLateStartMonitorSelected()) {
                            this.jobMonitorManagerAM.jobSkipped(n, jobInfo.getAgentID(), calendar);
                        }
                        if (l > 0L) {
                            scheduleLogEntry2.setJobHistoryID(l);
                            this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, scheduleJobProxy.getJobType(), (long)n2, calendar.getTimeInMillis(), l);
                        } else {
                            this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, scheduleJobProxy.getJobType(), (long)n2, calendar.getTimeInMillis());
                        }
                        sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
                        this.updateSAPInterceptedJobRecord(sAPInterceptedJob, jobHistory);
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error getting history status for previous job.", (Throwable)exception);
                }
            }
            catch (NoDataException noDataException) {
                logger.debug((Object)("Error getting job proxy for job number: " + n), (Throwable)noDataException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.debug((Object)("Error getting job proxy for job number: " + n), (Throwable)resourceUnavailableException);
            }
        }
        jobHistoryDM = null;
        long l = System.currentTimeMillis();
        long l2 = 180000L;
        while (jobHistoryDM == null && l < l + l2) {
            try {
                jobHistoryDM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
            }
            catch (NullPointerException nullPointerException) {
                logger.debug((Object)"The Job Tracker is not available yet.");
            }
            if (jobHistoryDM != null) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)("Interrupted: The Job Tracker is not available yet, job " + n + " will be skipped..."));
                sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
                this.updateSAPInterceptedJobRecord(sAPInterceptedJob, null);
                return;
            }
        }
        if (jobHistoryDM == null) {
            logger.debug((Object)"The Job Tracker is not available yet, job will be skipped...");
            sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
            this.updateSAPInterceptedJobRecord(sAPInterceptedJob, null);
            return;
        }
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobID((long)n);
        jobHistory.setJobName(jobInfo.getJobName());
        jobHistory.setAgentID((long)n2);
        jobHistory.setAgentName(jobInfo.getAgentName());
        jobHistory.setAgentGroupID((long)jobInfo.getAgentGroupID());
        jobHistory.setAgentGroupName(jobInfo.getAgentGroupName());
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setJobPriority(scheduleJobProxy.getDefaultPriority());
        jobHistory.setJobQueueID(scheduleJobProxy.getJobQueueID());
        jobHistory.setJobQueueName(scheduleJobProxy.getJobQueueName());
        if (bl) {
            jobHistory.setMissedCode(JobMissedCode.MISSED);
        }
        JobHistoryDM jobHistoryDM2 = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        try {
            jobHistoryDM2.setTimezoneValues(jobHistory, (long)n2, (long)n, scheduleJobProxy, null);
        }
        catch (DataException dataException) {
            logger.error((Object)"Error setting timezone values.", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error setting timezone values.", (Throwable)resourceUnavailableException);
        }
        if (string != null) {
            jobHistory.setInitiationData(string);
            logger.debug((Object)("history initiation data set to " + jobHistory.getInitiationData()));
        }
        if (calendar != null) {
            jobHistory.setScheduledTime(calendar.getTimeInMillis());
            if (calendar instanceof MovedNST) {
                movedNST = (MovedNST)calendar;
                jobHistory.setMovedFromScheduledDateTime(movedNST.getOriginalDateTimeYYYYMMDDHHMM());
            }
        } else {
            jobHistory.setScheduledTime(date.getTime());
        }
        jobHistory.setInitiationCode(jobInitCode);
        movedNST = (ForecastAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.ForecastAM");
        long l3 = movedNST.runDuration(jobHistory.getJobID(), jobHistory.getAgentID());
        jobHistory.setEstimatedRuntime(l3);
        try {
            jobHistory = jobHistoryDM2.save(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"Job Submitter was unable to save new job history info", (Throwable)exception);
            sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
            this.updateSAPInterceptedJobRecord(sAPInterceptedJob, null);
            return;
        }
        this.updateSAPInterceptedJobRecord(sAPInterceptedJob, jobHistory);
        jobHistory.setAgentEnvironmentType(scheduleJobProxy.getAgentEnvironmentType());
        try {
            jobHistoryDM.submitJob(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)"JTAM Submit failed.", (Throwable)exception);
            return;
        }
        this.activityMatcherAM.jobSubmitted((long)n, scheduleJobProxy.getJobType(), (long)n2, jobHistory.getId(), jobInitCode, jobHistory.getScheduledTime());
        String string2 = String.valueOf(jobHistory.getId());
        if (calendar != null) {
            String[] stringArray = new String[]{jobHistory.getJobName(), jobInitCode.toString(), ScheduleLogger.formatTimeStamp((Calendar)calendar), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp((Date)date), string2};
            scheduleLogEntry = RosettaMsg.SUBMITTED_SCHEDULED_JOB.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
        } else {
            String[] stringArray = new String[]{jobHistory.getJobName(), jobInitCode.toString(), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp((Date)date), string2};
            scheduleLogEntry = RosettaMsg.SUBMITTED_JOB.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
        }
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    private void updateSAPInterceptedJobRecord(SAPInterceptedJob sAPInterceptedJob, JobHistory jobHistory) {
        String string = "Error updating SAP Intercepted Job " + sAPInterceptedJob.getNameAndCount();
        if (jobHistory != null) {
            sAPInterceptedJob.setSkybotJobHistoryID(jobHistory.getId());
            switch (jobHistory.getStatusCode()) {
                case SKIPPED: {
                    sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
                    break;
                }
                default: {
                    sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SUBMITTED);
                }
            }
            try {
                this.getSAPInterceptedJobsDM().update(sAPInterceptedJob);
            }
            catch (Exception exception) {
                logger.error((Object)string, (Throwable)exception);
            }
        } else {
            if (sAPInterceptedJob.getStatus().equals((Object)SAPInterceptedJob.InterceptedJobStatus.NO_MATCH)) {
                sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SKIPPED);
            }
            try {
                this.getSAPInterceptedJobsDM().update(sAPInterceptedJob);
            }
            catch (Exception exception) {
                logger.error((Object)string, (Throwable)exception);
            }
        }
    }

    private SAPInterceptedJobsDM getSAPInterceptedJobsDM() {
        if (this.sapInterceptedJobsDM == null) {
            this.sapInterceptedJobsDM = (SAPInterceptedJobsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPInterceptedJobsDM");
        }
        return this.sapInterceptedJobsDM;
    }

    public boolean isJobHeld(ScheduleJobProxy scheduleJobProxy, JobInfo jobInfo, Calendar calendar, long l) {
        String[] stringArray;
        if (scheduleJobProxy.getJobHoldFlag() == JobHoldFlag.HELD) {
            ScheduleLogEntry scheduleLogEntry;
            if (scheduleJobProxy.isSuite()) {
                String[] stringArray2 = new String[]{scheduleJobProxy.getName(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
                long l2 = scheduleJobProxy.getSkybotJobNumber();
                scheduleLogEntry = RosettaMsg.SUITE_WAS_HELD.newLogEntryForSuite(stringArray2, l2);
            } else {
                String[] stringArray3 = new String[]{jobInfo.getJobName(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
                scheduleLogEntry = RosettaMsg.JOB_WAS_HELD.newLogEntry(stringArray3, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
            }
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            logger.info((Object)scheduleLogEntry.getMessageText());
            return true;
        }
        if (scheduleJobProxy.getJobHoldFlag() == JobHoldFlag.HELD_FOR_X_TIMES) {
            int n;
            int n2 = scheduleJobProxy.getHeldCount() + 1;
            if (n2 <= (n = scheduleJobProxy.getHoldTimes())) {
                ScheduleLogEntry scheduleLogEntry;
                if (scheduleJobProxy.isSuite()) {
                    String[] stringArray4 = new String[]{scheduleJobProxy.getName(), ScheduleLogger.formatTimeStamp((Calendar)calendar), String.valueOf(n2), String.valueOf(n)};
                    long l3 = scheduleJobProxy.getSkybotJobNumber();
                    scheduleLogEntry = RosettaMsg.SUITE_WAS_HELD_NTH_TIME.newLogEntryForSuite(stringArray4, l3);
                } else {
                    String[] stringArray5 = new String[]{jobInfo.getJobName(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar), String.valueOf(n2), String.valueOf(n)};
                    scheduleLogEntry = RosettaMsg.JOB_WAS_HELD_NTH_TIME.newLogEntry(stringArray5, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
                }
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.info((Object)scheduleLogEntry.getMessageText());
                if (n2 < n) {
                    this.updateHeldCount(scheduleJobProxy, n2);
                } else {
                    this.releaseHeldJob(scheduleJobProxy);
                }
                return true;
            }
            stringArray = MessageUtil.formatMsg((String)"Releasing job that was held {0} times and specified to be held {1} times.", (Object[])new Object[]{String.valueOf(scheduleJobProxy.getHeldCount()), String.valueOf(n)});
            logger.debug((Object)stringArray);
            this.releaseHeldJob(scheduleJobProxy);
        }
        if (scheduleJobProxy.getJobHoldFlag() == JobHoldFlag.HELD_UNTIL) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(scheduleJobProxy.getHoldUntil());
            if (scheduleJobProxy.getTimezoneType() == ScheduleInfo.TimeZoneType.AGENT) {
                calendar2 = this.getHoldUntilAgent(jobInfo, calendar2);
            } else if (scheduleJobProxy.getTimezoneType() == ScheduleInfo.TimeZoneType.JOB) {
                calendar2.set(1, calendar2.get(1));
                calendar2.setTimeZone(this.jobSpecificTimeZone(scheduleJobProxy));
                calendar2.getTimeInMillis();
            }
            if (calendar2.after(calendar)) {
                ScheduleLogEntry scheduleLogEntry;
                if (scheduleJobProxy.isSuite()) {
                    stringArray = new String[]{scheduleJobProxy.getName(), ScheduleLogger.formatTimeStamp((Calendar)calendar), ScheduleLogger.formatTimeStampTZ((Calendar)calendar2)};
                    long l4 = scheduleJobProxy.getSkybotJobNumber();
                    scheduleLogEntry = RosettaMsg.SUITE_WAS_HELD_UNTIL.newLogEntryForSuite(stringArray, l4);
                } else {
                    stringArray = new String[]{jobInfo.getJobName(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar), ScheduleLogger.formatTimeStampTZ((Calendar)calendar2)};
                    scheduleLogEntry = RosettaMsg.JOB_WAS_HELD_UNTIL.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
                }
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.info((Object)scheduleLogEntry.getMessageText());
                return true;
            }
            if (scheduleJobProxy.getTimezoneType() == ScheduleInfo.TimeZoneType.SERVER || scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT || scheduleJobProxy.getJobType() == JobType.SUITE) {
                logger.debug((Object)("Releasing 'held until' job: " + scheduleJobProxy.getName()));
                this.releaseHeldJob(scheduleJobProxy);
            } else {
                TimeZone timeZone = TimeZone.getTimeZone("GMT-12:00");
                stringArray = Calendar.getInstance(timeZone);
                stringArray.clear();
                stringArray.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12));
                if (calendar.getTimeInMillis() > stringArray.getTimeInMillis()) {
                    logger.debug((Object)("Releasing 'held until' agent group job: " + scheduleJobProxy.getName() + " - " + ScheduleLogger.formatTimeStamp((Calendar)calendar) + " > " + ScheduleLogger.formatTimeStamp((Calendar)stringArray)));
                    this.releaseHeldJob(scheduleJobProxy);
                } else {
                    logger.debug((Object)("NOT releasing 'held until' agent group job: " + scheduleJobProxy.getName() + " - " + ScheduleLogger.formatTimeStamp((Calendar)calendar) + " > " + ScheduleLogger.formatTimeStamp((Calendar)stringArray)));
                }
            }
        }
        return scheduleJobProxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP && this.isAgentIgnoredInGroup(l, scheduleJobProxy.getTargetId(), calendar, scheduleJobProxy.getTimezoneType(), jobInfo);
    }

    private boolean isJobHeldOrSkipped(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        JobType jobType = scheduleJobProxy.getJobType();
        if (jobInitCode == JobInitCode.SCHEDULE || jobInitCode == JobInitCode.REACTIVE || jobInitCode == JobInitCode.SCHEDULED_WITH_PREREQS) {
            if (this.isJobHeld(scheduleJobProxy, jobInfo, calendar, n2)) {
                if (scheduleJobProxy.isLateStartMonitorSelected()) {
                    this.sendJobIsHeld(n, jobInfo, calendar);
                }
                this.activityMatcherAM.jobSkipped_IsHeld((long)n, jobType, (long)n2, jobInitCode, calendar.getTimeInMillis());
                return true;
            }
            if (scheduleJobProxy.isSkipOnNotCompleted()) {
                try {
                    JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
                    long l = n2;
                    if (jobHistoryDM.hasActiveStatus(l, scheduleJobProxy.getSkybotJobNumber())) {
                        String[] stringArray = new String[]{jobInfo.getJobNameOrID(), jobInfo.getAgentNameOrID()};
                        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_ALREADY_ACTIVE.newLogEntry(stringArray, (long)n2, (long)n);
                        long l2 = 0L;
                        if (scheduleJobProxy.isGenerateSkippedHistory()) {
                            int n3 = scheduleJobProxy.getDefaultPriority();
                            JobHistory jobHistory = new JobHistory();
                            JobMissedCode jobMissedCode = bl ? JobMissedCode.SKIPPED_AFTER_MISS : JobMissedCode.SKIPPED;
                            l2 = this.createSkippedHistory(jobHistory, n, n2, jobInfo, date, calendar, jobInitCode, JobEndedReasonCode.ALREADY_ACTIVE, n3, string, jobMissedCode, jobType, scheduleJobProxy);
                            JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
                            jobTrackerAM.notifyOfJobStatus(jobHistory, null, scheduleLogEntry.getMessageText());
                            this.prereqDM.resetPrereqStatus(jobHistory.getAgentID(), jobHistory.getJobID(), PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, jobHistory.getId());
                        }
                        if (l2 > 0L) {
                            scheduleLogEntry.setJobHistoryID(l2);
                        }
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)scheduleLogEntry.getMessageText());
                        }
                        if (scheduleJobProxy.isLateStartMonitorSelected()) {
                            this.jobMonitorManagerAM.jobSkipped(n, jobInfo.getAgentID(), calendar);
                        }
                        if (l2 > 0L) {
                            scheduleLogEntry.setJobHistoryID(l2);
                            this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, jobType, (long)n2, calendar.getTimeInMillis(), l2);
                        } else {
                            this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, jobType, (long)n2, calendar.getTimeInMillis());
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error getting history status for previous job.", (Throwable)exception);
                }
            }
        }
        return false;
    }

    private boolean isSuiteHeldOrSkipped(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, String string, boolean bl, ScheduleJobProxy scheduleJobProxy) {
        if (jobInitCode == JobInitCode.USER_DO || jobInitCode == JobInitCode.RESTART) {
            return false;
        }
        JobType jobType = scheduleJobProxy.getJobType();
        if (this.isJobHeld(scheduleJobProxy, jobInfo, calendar, n2)) {
            if (scheduleJobProxy.isLateStartMonitorSelected()) {
                this.sendJobIsHeld(n, jobInfo, calendar);
            }
            this.activityMatcherAM.suiteSkipped_IsHeld((long)n, jobInitCode, calendar.getTimeInMillis());
            return true;
        }
        if (scheduleJobProxy.isSkipOnNotCompleted()) {
            boolean bl2;
            String[] stringArray;
            long l = n;
            try {
                stringArray = (String[])ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
                bl2 = stringArray.hasActiveStatus(l, jobInfo);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to determine if suite {0} is active.", (Object[])new Object[]{jobInfo.getJobName()}), (Throwable)resourceUnavailableException);
                return false;
            }
            if (bl2) {
                stringArray = new String[]{jobInfo.getJobName()};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_ALREADY_ACTIVE.newLogEntryForSuite(stringArray, l);
                long l2 = 0L;
                if (scheduleJobProxy.isGenerateSkippedHistory()) {
                    try {
                        JobMissedCode jobMissedCode = bl ? JobMissedCode.SKIPPED_AFTER_MISS : JobMissedCode.SKIPPED;
                        JobHistory jobHistory = new JobHistory();
                        this.createSkippedHistory(jobHistory, n, n2, jobInfo, date, calendar, jobInitCode, JobEndedReasonCode.ALREADY_ACTIVE, scheduleJobProxy.getDefaultPriority(), string, jobMissedCode, jobType, scheduleJobProxy);
                        l2 = jobHistory.getId();
                        jobHistory.setJobSuiteHistoryID(l2);
                        try {
                            this.jobSuiteDM.populateSuiteHistoryID(l2);
                        }
                        catch (NotSavedException notSavedException) {
                            logger.error((Object)"", (Throwable)notSavedException);
                        }
                        this.prereqDM.createJobHistoryToEventXref(l, 0L, l2);
                        scheduleLogEntry.setJobSuiteHistoryID(l2);
                        JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
                        jobTrackerAM.notifyOfJobSuiteStatus(jobHistory, JobSuiteStatus.SKIPPED, scheduleLogEntry.getMessageText());
                    }
                    catch (Exception exception) {
                        logger.error((Object)MessageUtil.formatMsg((String)"Error while trying to generate a skipped history entry for suite {0}.", (Object[])new Object[]{jobInfo.getJobName()}), (Throwable)exception);
                    }
                }
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                if (scheduleJobProxy.isLateStartMonitorSelected()) {
                    this.jobMonitorManagerAM.jobSkipped(n, jobInfo.getAgentID(), calendar);
                }
                if (l2 > 0L) {
                    this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, jobType, (long)n2, calendar.getTimeInMillis(), l2);
                } else {
                    this.activityMatcherAM.jobSkipped_IntervalJobAlreadyActive((long)n, jobType, (long)n2, calendar.getTimeInMillis());
                }
                return true;
            }
        }
        return false;
    }

    public void sendJobIsHeld(int n, JobInfo jobInfo, Calendar calendar) {
        try {
            this.jobMonitorManagerAM.jobIsHeld(n, jobInfo.getAgentID(), calendar);
        }
        catch (Exception exception) {
            logger.error((Object)"Error notifying job monitor of held job.", (Throwable)exception);
        }
    }

    private boolean isAgentIgnoredInGroup(long l, long l2, Calendar calendar, ScheduleInfo.TimeZoneType timeZoneType, JobInfo jobInfo) {
        if (l != 0L) {
            try {
                AgentGroupAgent agentGroupAgent = this.agentGroupDM.getAgentGroupAgent(l2, l, null);
                if (agentGroupAgent.getIgnoreInGroup() == 1) {
                    String[] stringArray = new String[]{jobInfo.getJobName(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_WAS_IGNORED_IN_AGENT_GROUP.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
                    logger.info((Object)scheduleLogEntry.getMessageText());
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    return true;
                }
                if (agentGroupAgent.getIgnoreInGroup() == 2) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTimeInMillis(agentGroupAgent.getIgnoreUntilTimestamp());
                    Calendar calendar3 = calendar2;
                    Calendar calendar4 = this.getHoldUntilAgent(jobInfo, calendar2);
                    if (timeZoneType == ScheduleInfo.TimeZoneType.AGENT) {
                        calendar3 = calendar4;
                    }
                    if (calendar3.after(calendar)) {
                        String[] stringArray = new String[]{jobInfo.getJobName(), jobInfo.getAgentNameOrID(), ScheduleLogger.formatTimeStamp((Calendar)calendar), ScheduleLogger.formatTimeStamp((Calendar)calendar3)};
                        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_WAS_IGNORED_UNTIL_IN_AGENT_GROUP.newLogEntry(stringArray, (long)jobInfo.getAgentID(), (long)jobInfo.getJobID());
                        logger.info((Object)scheduleLogEntry.getMessageText());
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        return true;
                    }
                    if (calendar.after(calendar2) && calendar.after(calendar4)) {
                        this.releaseHeldAgentGroupAgent(agentGroupAgent.getOid());
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error agent status in agent group.", (Throwable)exception);
            }
        }
        return false;
    }

    private Calendar getHoldUntilAgent(JobInfo jobInfo, Calendar calendar) {
        Calendar calendar2 = null;
        try {
            Agent agent = this.agentDM.get((long)jobInfo.getAgentID());
            TimeZone timeZone = TimeZone.getTimeZone(agent.getTimeZone());
            calendar2 = Calendar.getInstance(timeZone);
            calendar2.setTimeInMillis(0L);
            calendar2.set(1, calendar.get(1));
            calendar2.set(2, calendar.get(2));
            calendar2.set(5, calendar.get(5));
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
        }
        catch (DataException dataException) {
            logger.error((Object)"Error getting agent.", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error gettting agent.", (Throwable)resourceUnavailableException);
        }
        return calendar2;
    }

    private TimeZone jobSpecificTimeZone(ScheduleJobProxy scheduleJobProxy) {
        TimeZone timeZone;
        String string = scheduleJobProxy.getJobTimezone();
        if (string != null && !string.isEmpty()) {
            timeZone = this.timezone(string, scheduleJobProxy.getName());
        } else {
            timeZone = this.serverTimeZone();
            String string2 = timeZone.getID();
            logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{scheduleJobProxy.getName(), string2}));
        }
        return timeZone;
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private void updateHeldCount(ScheduleJobProxy scheduleJobProxy, int n) {
        try {
            this.scheduleJobDM.updateHeldInfo(scheduleJobProxy.getSkybotJobNumber(), scheduleJobProxy.getJobHoldFlag(), scheduleJobProxy.getHoldTimes(), n, 0L);
        }
        catch (Throwable throwable) {
            String string = MessageUtil.formatMsg((String)"Error updating held count for Schedule Job {0}.", (Object[])new Object[]{String.valueOf(scheduleJobProxy.getName())});
            logger.error((Object)string, throwable);
        }
    }

    private void releaseHeldJob(ScheduleJobProxy scheduleJobProxy) {
        try {
            this.scheduleJobDM.release(scheduleJobProxy.getSkybotJobNumber());
        }
        catch (Throwable throwable) {
            String string = MessageUtil.formatMsg((String)"Error releasing held Schedule Job {0}.", (Object[])new Object[]{String.valueOf(scheduleJobProxy.getName())});
            logger.error((Object)string, throwable);
        }
    }

    private void releaseHeldAgentGroupAgent(long l) {
        try {
            this.agentGroupDM.release(l);
        }
        catch (Throwable throwable) {
            String string = MessageUtil.formatMsg((String)"Error releasing held Agent Group Agent {0}.", (Object[])new Object[]{String.valueOf(l)});
            logger.error((Object)string, throwable);
        }
    }

    public long createSkippedHistory(JobHistory jobHistory, int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, JobInitCode jobInitCode, JobEndedReasonCode jobEndedReasonCode, int n3, String string, JobMissedCode jobMissedCode, JobType jobType, ScheduleJobProxy scheduleJobProxy) {
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        jobHistory.setJobID((long)n);
        jobHistory.setJobName(jobInfo.getJobName());
        if (jobType != JobType.SUITE) {
            jobHistory.setAgentID((long)n2);
            jobHistory.setAgentName(jobInfo.getAgentName());
            jobHistory.setAgentGroupID((long)jobInfo.getAgentGroupID());
            jobHistory.setAgentGroupName(jobInfo.getAgentGroupName());
            jobHistory.setJobPriority(n3);
            jobHistory.setJobParameters(scheduleJobProxy.getJobParameters());
            jobHistory.setJobQueueID(jobInfo.getJobQueueID());
            jobHistory.setJobQueueName(jobInfo.getJobQueueName());
        } else {
            jobHistory.setDefaultSuiteParameters(scheduleJobProxy.getJobParameters());
            jobHistory.setJobSuiteID((long)n);
        }
        try {
            jobHistoryDM.setTimezoneValues(jobHistory, (long)n2, (long)n, null, null);
        }
        catch (DataException dataException) {
            logger.error((Object)"Error while setting timezone values", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error while setting timezone values", (Throwable)resourceUnavailableException);
        }
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setInitiationCode(jobInitCode);
        jobHistory.setStatusCode(JobStatusCode.SKIPPED);
        jobHistory.setJobEndedReasonCode(jobEndedReasonCode);
        jobHistory.setMissedCode(jobMissedCode);
        jobHistory.setInitiationData(string);
        if (calendar != null) {
            jobHistory.setScheduledTime(calendar.getTimeInMillis());
            if (calendar instanceof MovedNST) {
                MovedNST movedNST = (MovedNST)calendar;
                jobHistory.setMovedFromScheduledDateTime(movedNST.getOriginalDateTimeYYYYMMDDHHMM());
            }
        } else {
            jobHistory.setScheduledTime(date.getTime());
        }
        try {
            jobHistory = jobHistoryDM.save(jobHistory, true);
        }
        catch (Exception exception) {
            logger.error((Object)"Job Submitter was unable to save new job history info", (Throwable)exception);
        }
        return jobHistory.getId();
    }

    public boolean submitMissedJob(int n, int n2, JobInfo jobInfo, Date date, Calendar calendar, boolean bl, boolean bl2, JobInitCode jobInitCode, String string, MissedJobsAccountant missedJobsAccountant, boolean bl3, Date date2, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        MissedJobAction missedJobAction = MissedJobAction.MANAGE;
        ScheduleJobProxy scheduleJobProxy2 = null;
        boolean bl4 = false;
        long l = System.currentTimeMillis();
        try {
            scheduleJobProxy2 = this.getScheduleJobProxy(n);
            missedJobAction = scheduleJobProxy2.getMissedJobAction();
            bl4 = scheduleJobProxy2.isSuite();
        }
        catch (DataException dataException) {
            String string2 = "Data error loading missed job or suite: " + n;
            logger.error((Object)string2, (Throwable)dataException);
            throw new ResourceUnavailableException(string2, (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string3 = "Error loading missed job or suit: " + n;
            logger.error((Object)string3, (Throwable)resourceUnavailableException);
            throw new ResourceUnavailableException(string3, (Throwable)resourceUnavailableException);
        }
        JobType jobType = scheduleJobProxy2.getJobType();
        if (this.isJobHeld(scheduleJobProxy2, jobInfo, calendar, n2)) {
            this.activityMatcherAM.jobSkipped_IsHeld((long)n, jobType, (long)n2, jobInitCode, calendar.getTimeInMillis());
            return false;
        }
        String string4 = jobInfo.getJobNameOrID();
        String string5 = jobInfo.getAgentNameOrID();
        String string6 = jobInfo.getAgentGroupNameOrID();
        int n3 = jobInfo.getAgentGroupID();
        String string7 = ScheduleLogger.formatTimeStamp((Calendar)calendar);
        if (bl3 && (date2 == null || date2.after(calendar.getTime()))) {
            JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_IGNORING, string4, string5, string7, n2, n);
            this.jobMonitorManagerAM.jobIgnored(n, n2, calendar);
            missedJobsAccountant.incrementIgnoredMissedJobsCount();
            this.activityMatcherAM.jobMissedIgnored((long)n, jobType, (long)n2, jobInitCode, calendar.getTimeInMillis());
            return false;
        }
        JobHistory jobHistory = null;
        switch (missedJobAction) {
            case COMPLETE: {
                jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.COMPLETED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_COMPLETING, string4, string7, jobHistory);
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_COMPLETING, string4, string5, string7, jobHistory);
                }
                missedJobsAccountant.incrementCompletedMissedJobsCount();
                this.updateRollupTables(JobStatusCode.COMPLETED, l, jobInfo.getAgentID());
                break;
            }
            case IGNORE: {
                if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_IGNORING, string4, string7, n);
                    this.activityMatcherAM.suiteMissed_Ignored((long)n, calendar.getTimeInMillis());
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_IGNORING, string4, string5, string7, n2, n);
                    this.activityMatcherAM.jobMissedIgnored((long)n, jobType, (long)n2, jobInitCode, calendar.getTimeInMillis());
                }
                this.jobMonitorManagerAM.jobIgnored(n, n2, calendar);
                missedJobsAccountant.incrementIgnoredMissedJobsCount();
                break;
            }
            case FAIL: {
                jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.FAILED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_FAILING, string4, string7, jobHistory);
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_FAILING, string4, string5, string7, jobHistory);
                }
                missedJobsAccountant.incrementFailedMissedJobsCount();
                this.updateRollupTables(JobStatusCode.FAILED, l, jobInfo.getAgentID());
                break;
            }
            case MANAGE: {
                jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.MANAGED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_MANAGING, string4, string7, jobHistory);
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_MANAGING, string4, string5, string7, jobHistory);
                }
                missedJobsAccountant.incrementManagedMissedJobsCount();
                break;
            }
            case RUN_ALL: {
                if (bl) {
                    if (bl4) {
                        JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_SUBMITTING_FIRST, string4, string7, n);
                    } else {
                        JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_SUBMITTING_FIRST, string4, string5, string7, n2, n);
                    }
                } else if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_SUBMITTING_AN_ADDITIONAL, string4, string7, n);
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_SUBMITTING_AN_ADDITIONAL, string4, string5, string7, n2, n);
                }
                if (!bl2) {
                    boolean bl5 = this.submitJobOrSuite(n, n2, jobInfo, date, calendar, jobInitCode, string, true, scheduleJobProxy);
                    missedJobsAccountant.incrementRanMissedJobsCount();
                    return bl5;
                }
                logger.info((Object)("TEST MODE: Skipping submission for: " + string4));
                break;
            }
            case RUN_ONCE_COMPLETE_OTHERS: 
            case RUN_ONCE_IGNORE_OTHERS: 
            case RUN_ONCE_FAIL_OTHERS: 
            case RUN_ONCE_MANAGE_OTHERS: {
                if (bl) {
                    if (bl4) {
                        JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_SUBMITTING_FIRST, string4, string7, n);
                    } else {
                        JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_SUBMITTING_FIRST, string4, string5, string7, n2, n);
                    }
                    if (!bl2) {
                        boolean bl6 = this.submitJobOrSuite(n, n2, jobInfo, date, calendar, jobInitCode, string, true, scheduleJobProxy);
                        missedJobsAccountant.incrementRanMissedJobsCount();
                        return bl6;
                    }
                    logger.info((Object)("TEST MODE: Skipping submission for: " + string4));
                    break;
                }
                switch (missedJobAction) {
                    case RUN_ONCE_COMPLETE_OTHERS: {
                        jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.COMPLETED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                        if (bl4) {
                            JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_COMPLETING_AN_ADDITIONAL, string4, string7, jobHistory);
                        } else {
                            JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_COMPLETING_AN_ADDITIONAL, string4, string5, string7, jobHistory);
                        }
                        missedJobsAccountant.incrementCompletedMissedJobsCount();
                        this.updateRollupTables(JobStatusCode.COMPLETED, l, jobInfo.getAgentID());
                        break;
                    }
                    case RUN_ONCE_IGNORE_OTHERS: {
                        if (bl4) {
                            JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_IGNORING_AN_ADDITIONAL, string4, string7, n);
                        } else {
                            JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_IGNORING_AN_ADDITIONAL, string4, string5, string7, n2, n);
                        }
                        missedJobsAccountant.incrementIgnoredMissedJobsCount();
                        this.jobMonitorManagerAM.jobIgnored(n, n2, calendar);
                        this.activityMatcherAM.jobMissedIgnored((long)n, jobType, (long)n2, jobInitCode, calendar.getTimeInMillis());
                        break;
                    }
                    case RUN_ONCE_FAIL_OTHERS: {
                        jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.FAILED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                        if (bl4) {
                            JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_FAILING_AN_ADDITIONAL, string4, string7, jobHistory);
                        } else {
                            JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_FAILING_AN_ADDITIONAL, string4, string5, string7, jobHistory);
                        }
                        missedJobsAccountant.incrementFailedMissedJobsCount();
                        this.updateRollupTables(JobStatusCode.FAILED, l, jobInfo.getAgentID());
                        break;
                    }
                    case RUN_ONCE_MANAGE_OTHERS: {
                        jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.MANAGED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                        if (bl4) {
                            JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_MANAGING_AN_ADDITIONAL, string4, string7, jobHistory);
                        } else {
                            JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_MANAGING_AN_ADDITIONAL, string4, string5, string7, jobHistory);
                        }
                        missedJobsAccountant.incrementManagedMissedJobsCount();
                    }
                }
                break;
            }
            default: {
                logger.error((Object)"Undefined missed job or suit action.");
                jobHistory = this.createMissedHistory(bl4, n, string4, n2, string5, n3, string6, JobStatusCode.MANAGED, jobInitCode, date, calendar, string, scheduleJobProxy2);
                if (bl4) {
                    JobSubmitter.logMissedSuite(RosettaMsg.MISSED_SUITE_MANAGING, string4, string7, jobHistory);
                } else {
                    JobSubmitter.logMissedJob(RosettaMsg.MISSED_JOB_MANAGING, string4, string5, string7, jobHistory);
                }
                missedJobsAccountant.incrementManagedMissedJobsCount();
            }
        }
        return false;
    }

    private void updateRollupTables(JobStatusCode jobStatusCode, long l, long l2) {
        try {
            this.jobStartEndRollupDM.saveSubmitCount(l);
            this.jobStartEndRollupDM.saveEndCount(l);
        }
        catch (Exception exception) {
            logger.debug((Object)"Error saving jobStartEndRollup for job termination", (Throwable)exception);
        }
        try {
            this.jobStatusCountRollupDM.saveStatusCount(jobStatusCode, l, l2, 0L);
        }
        catch (Exception exception) {
            logger.debug((Object)"Error saving job_status_count_rollups for job ending", (Throwable)exception);
        }
    }

    private JobHistory createMissedHistory(boolean bl, int n, String string, int n2, String string2, int n3, String string3, JobStatusCode jobStatusCode, JobInitCode jobInitCode, Date date, Calendar calendar, String string4, ScheduleJobProxy scheduleJobProxy) throws ResourceUnavailableException {
        JobType jobType;
        Object object;
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobPriority(scheduleJobProxy.getDefaultPriority());
        jobHistory.setJobID((long)n);
        if (bl) {
            jobHistory.setJobSuiteID((long)n);
        } else {
            jobHistory.setAgentID((long)n2);
            jobHistory.setAgentName(string2);
            jobHistory.setAgentGroupID((long)n3);
            jobHistory.setAgentGroupName(string3);
        }
        jobHistory.setJobName(string);
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setScheduledTime(calendar.getTimeInMillis());
        jobHistory.setMovedFromScheduledDateTime(0L);
        jobHistory.setJobQueueID(scheduleJobProxy.getJobQueueID());
        jobHistory.setJobQueueName(scheduleJobProxy.getJobQueueName());
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        String string5 = "Error setting timezone values.";
        try {
            jobHistoryDM.setTimezoneValues(jobHistory, (long)n2, (long)n, scheduleJobProxy, null);
        }
        catch (DataException dataException) {
            logger.error((Object)string5, (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)string5, (Throwable)resourceUnavailableException);
        }
        if (calendar instanceof MovedNST) {
            object = (MovedNST)calendar;
            jobHistory.setMovedFromScheduledDateTime(object.getOriginalDateTimeYYYYMMDDHHMM());
        }
        jobHistory.setStatusCode(jobStatusCode);
        if (jobStatusCode.equals((Object)JobStatusCode.COMPLETED) || jobStatusCode.equals((Object)JobStatusCode.FAILED) || jobStatusCode.equals((Object)JobStatusCode.CANCELED)) {
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.MISSED_JOB_ACTION);
        }
        jobHistory.setInitiationCode(jobInitCode);
        jobHistory.setInitiationData(string4);
        jobHistory.setMissedCode(JobMissedCode.MISSED);
        if (scheduleJobProxy.isSuite()) {
            jobHistory.setDefaultSuiteParameters(scheduleJobProxy.getJobParameters());
        } else {
            jobHistory.setJobParameters(scheduleJobProxy.getJobParameters());
        }
        switch (jobStatusCode) {
            case CANCELED: 
            case COMPLETED: 
            case FAILED: {
                jobHistory.setServerEndedTime(date.getTime());
            }
        }
        object = "job";
        if (bl) {
            object = "suite";
        }
        try {
            jobHistory = jobHistoryDM.save(jobHistory);
        }
        catch (Exception exception) {
            String string6 = "Error creating " + (String)object + " history info.";
            throw new ResourceUnavailableException(string6, (Throwable)exception);
        }
        if (bl) {
            jobHistory.setJobSuiteHistoryID(jobHistory.getId());
            try {
                this.jobSuiteDM.populateSuiteHistoryID(jobHistory.getId());
            }
            catch (NotSavedException notSavedException) {
                logger.error((Object)"", (Throwable)notSavedException);
            }
        }
        try {
            this.jobMonitorManagerAM.loadLateStartJobMonitor(jobHistory);
        }
        catch (EndJobException endJobException) {
        }
        catch (Exception exception) {
            String string7 = "Error updating  " + (String)object + "  monitor info.";
            throw new ResourceUnavailableException(string7, (Throwable)exception);
        }
        if (bl && (jobStatusCode == JobStatusCode.COMPLETED || jobStatusCode == JobStatusCode.FAILED)) {
            this.activityMatcherAM.suiteMissed_Ended((long)n, calendar.getTimeInMillis(), jobHistory.getId());
        } else {
            jobType = scheduleJobProxy.getJobType();
            this.activityMatcherAM.jobSubmitted((long)n, jobType, (long)n2, jobHistory.getId(), jobInitCode, calendar.getTimeInMillis());
        }
        if (jobStatusCode == JobStatusCode.FAILED) {
            if (bl) {
                this.jobSuiteAM.holdFailedSuite(jobHistory);
            } else {
                jobType = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
                jobType.holdFailedJob(jobHistory);
            }
        }
        return jobHistory;
    }

    private static void logMissedJob(RosettaMsg rosettaMsg, String string, String string2, String string3, long l, long l2) {
        JobSubmitter.logMissedJob(rosettaMsg, string, string2, string3, l, l2, 0L);
    }

    private static void logMissedSuite(RosettaMsg rosettaMsg, String string, String string2, long l) {
        JobSubmitter.logMissedSuite(rosettaMsg, string, string2, l, 0L);
    }

    private static void logMissedJob(RosettaMsg rosettaMsg, String string, String string2, String string3, JobHistory jobHistory) {
        JobSubmitter.logMissedJob(rosettaMsg, string, string2, string3, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId());
    }

    private static void logMissedSuite(RosettaMsg rosettaMsg, String string, String string2, JobHistory jobHistory) {
        JobSubmitter.logMissedSuite(rosettaMsg, string, string2, jobHistory.getJobID(), jobHistory.getId());
    }

    private static void logMissedJob(RosettaMsg rosettaMsg, String string, String string2, String string3, long l, long l2, long l3) {
        String[] stringArray = new String[]{string, string2, string3};
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, l, l2, l3);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    private static void logMissedSuite(RosettaMsg rosettaMsg, String string, String string2, long l, long l2) {
        String[] stringArray = new String[]{string, string2};
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntryForSuite(stringArray, l, l2);
        logger.info((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    private ScheduleJobProxy getScheduleJobProxy(long l) throws NoDataException, ResourceUnavailableException {
        return this.scheduleJobDM.getScheduleJobProxy(l);
    }
}

