/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.scheduler.Drivable;
import com.helpsystems.enterprise.scheduler.DriverStatus;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public abstract class Driver
implements Runnable,
InterruptibleProcess {
    private static Logger logger = Logger.getLogger(Driver.class);
    private Drivable drivable = null;
    private volatile boolean keepRunning;
    private DriverStatus status = DriverStatus.ENDED;

    public Driver(Drivable drivable) {
        this.drivable = drivable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScheduleLogEntry scheduleLogEntry;
        this.status = DriverStatus.STARTING;
        boolean bl = false;
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SCHEDULER.getMDCKeyValue());
        try {
            this.keepRunning = true;
            do {
                if (bl) {
                    this.drivable.prepareForRestart();
                }
                this.drivable.start();
                scheduleLogEntry = RosettaMsg.DRIVER_STARTED.newLogEntry(this.drivable.getName());
                logger.debug((Object)scheduleLogEntry.getMessageText());
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                this.status = DriverStatus.RUNNING;
                this.drivable.run();
                this.keepRunning = !this.drivable.isShuttingDown();
                bl = true;
                try {
                    if (!this.keepRunning) continue;
                    logger.debug((Object)(this.drivable.getName() + " driver is waiting 20 seconds before restarting."));
                    Thread.sleep(20000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (this.keepRunning);
        }
        catch (Throwable throwable) {
            this.status = DriverStatus.FAILED;
            Object object = RosettaMsg.DRIVER_ENDED_IN_ERROR.newLogEntry(this.drivable.getName());
            logger.error((Object)object.getMessageText(), throwable);
            ScheduleLogger.write((ScheduleLogEntry)object);
        }
        finally {
            block34: {
                try {
                    if (this.status == DriverStatus.FAILED) break block34;
                    this.status = DriverStatus.ENDED;
                    scheduleLogEntry = RosettaMsg.DRIVER_ENDED.newLogEntry(this.drivable.getName());
                    String string = scheduleLogEntry.getMessageText();
                    try {
                        logger.debug((Object)string);
                    }
                    catch (Exception exception) {
                        System.out.println(Thread.currentThread().getName() + " - Driver ending: " + string);
                    }
                    try {
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    try {
                        logger.error((Object)("Error handling error in Driver: " + exception.getMessage()));
                    }
                    catch (Exception exception2) {}
                    return;
                }
            }
        }
    }

    public void interrupt() {
        this.keepRunning = false;
        this.status = DriverStatus.END_REQUESTED;
        if (this.drivable != null) {
            this.drivable.shutdown();
        }
    }

    public boolean isInterruptible() {
        return this.keepRunning;
    }

    public boolean wasInterrupted() {
        return !this.keepRunning;
    }

    public DriverStatus getStatus() {
        return this.status;
    }
}

