/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.ThrowableCommandResponse;
import org.apache.log4j.Logger;

public abstract class Processor {
    private static Logger logger = Logger.getLogger(Processor.class);
    private String suffix;

    public abstract void processObject(HeavyweightPeer var1, Envelope var2, Processable var3) throws Exception;

    public abstract String[] listCommands();

    public String getSuffix() {
        return this.suffix;
    }

    protected void sendReplyEnvelope(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) throws EnvelopeException {
        Envelope envelope2 = new Envelope();
        envelope2.setPayload(processable);
        envelope2.setDestination(envelope.getSource());
        envelope2.setResponseToEnvelopeID(envelope.getArbitraryID());
        heavyweightPeer.sendEnvelope(envelope2);
    }

    protected void sendReplyException(HeavyweightPeer heavyweightPeer, Envelope envelope, Command command, Exception exception) throws EnvelopeException {
        logger.debug((Object)"Preparing to send return an exception command", (Throwable)exception);
        ThrowableCommandResponse throwableCommandResponse = new ThrowableCommandResponse(exception);
        throwableCommandResponse.setSource(heavyweightPeer.getRemotePeerID());
        throwableCommandResponse.setCommand(command);
        Envelope envelope2 = new Envelope();
        envelope2.setPayload(throwableCommandResponse);
        envelope2.setDestination(envelope.getSource());
        envelope2.setResponseToEnvelopeID(envelope.getArbitraryID());
        heavyweightPeer.sendEnvelope(envelope2);
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }
}

