/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.module;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.module.Module;
import com.helpsystems.common.tl.module.ModuleClassLoader;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.common.tl.module.ModuleException;
import com.helpsystems.common.tl.module.ModuleInfo;
import com.helpsystems.common.tl.module.ModuleLifecycle;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.ThrowableCommandResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class GenericJarModule
implements Module {
    public static Logger logger = Logger.getLogger(GenericJarModule.class);
    protected ModuleClassLoader classloader;
    protected HeavyweightPeer peer;
    protected ModuleDescriptor desc;
    protected String moduleName;
    protected ModuleInfo moduleInfo;
    protected ModuleLifecycle lifecycleHandler;

    public GenericJarModule(String string) throws IOException {
        this.loadModuleInfo(string);
        this.classloader = new ModuleClassLoader(this, string);
        this.loadLifecycleHandler();
    }

    @Override
    public boolean canHandle(Envelope envelope, Processable processable) {
        Processor processor = this.classloader.getProcessor(processable);
        return processor != null;
    }

    public ModuleInfo getInfo() {
        return this.moduleInfo;
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public ModuleDescriptor getDescriptor() {
        return this.desc;
    }

    @Override
    public HeavyweightPeer getHeavyweightPeer() {
        return this.peer;
    }

    @Override
    public Class loadClass(String string) {
        if (!this.classloader.containsClass(string)) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classloader.loadClass(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    @Override
    public void processEnvelope(Envelope envelope, Processable processable) {
        try {
            if (this.peer == null) {
                throw new NullPointerException("The HeavyweightPeer for this module is currently null.");
            }
            Processor processor = this.classloader.getProcessor(processable);
            processor.setSuffix(this.desc.getSuffix());
            processor.processObject(this.peer, envelope, processable);
        }
        catch (Exception exception) {
            logger.debug((Object)("Error processing envelope " + (Object)((Object)envelope)), (Throwable)exception);
            ThrowableCommandResponse throwableCommandResponse = new ThrowableCommandResponse(exception);
            throwableCommandResponse.setSource(this.peer.getRemotePeerID());
            Envelope envelope2 = new Envelope();
            envelope2.setDestination(envelope.getSource());
            envelope2.setResponseToEnvelopeID(envelope.getArbitraryID());
            try {
                envelope2.setPayload(throwableCommandResponse);
                this.peer.sendEnvelope(envelope2);
            }
            catch (Exception exception2) {
                logger.debug((Object)("Unable to send an Exception response back to peer: " + envelope.getSource()));
            }
        }
    }

    public void setName(String string) {
        this.moduleName = string;
    }

    @Override
    public void setHeavyweightPeer(HeavyweightPeer heavyweightPeer) {
        this.peer = heavyweightPeer;
    }

    protected void loadModuleInfo(String string) throws IOException {
        JarFile jarFile = new JarFile(string);
        Manifest manifest = jarFile.getManifest();
        jarFile.close();
        if (manifest == null) {
            throw new IOException("The manifest in " + string + " is missing.");
        }
        Attributes attributes = manifest.getAttributes("Help/Systems");
        if (attributes == null) {
            throw new IOException("The manifest in " + string + " is missing the 'Help/Systems' section.");
        }
        String string2 = attributes.getValue("Module-Name");
        if (string2 == null || string2.length() == 0) {
            throw new NullPointerException("The manifest for " + string + " is missing the Module-Name attribute.");
        }
        this.setName(string2);
        String string3 = attributes.getValue("Module-Version");
        String string4 = attributes.getValue("Build-Date");
        String string5 = attributes.getValue("Build-Time");
        String string6 = attributes.getValue("Module-Init-Class");
        if (string6 == null || string6.length() == 0) {
            throw new NullPointerException("The manifest for" + string + " is missing the Module-Init-Class attribute.");
        }
        this.moduleInfo = new ModuleInfo(string2, new File(string), string3);
        this.moduleInfo.setBuildDate(string4);
        this.moduleInfo.setBuildTime(string5);
        this.moduleInfo.setInitClassname(string6);
        Set<Map.Entry<Object, Object>> set = attributes.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String string7 = entry.getKey().toString();
            if (!string7.startsWith("NotAProcessor")) continue;
            this.moduleInfo.addNonProcessor((String)entry.getValue());
        }
    }

    protected void loadLifecycleHandler() throws IOException {
        String string;
        if (this.moduleInfo == null) {
            // empty if block
        }
        if ((string = this.moduleInfo.getInitClassname()) == null) {
            throw new NullPointerException("The module init classname  is null.");
        }
        this.lifecycleHandler = null;
        try {
            Class<?> clazz = null;
            clazz = ModuleClassLoader.bypassEnabled ? Class.forName(string) : this.classloader.loadClass(string);
            this.lifecycleHandler = (ModuleLifecycle)clazz.newInstance();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("The Module-Init-Class " + string + " listed in the Manifest for module " + this.moduleName + " could not be instantiated.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(HeavyweightPeer heavyweightPeer, ModuleDescriptor moduleDescriptor) throws ModuleException {
        this.setHeavyweightPeer(heavyweightPeer);
        this.desc = moduleDescriptor;
        if (this.lifecycleHandler != null) {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.classloader);
            try {
                this.lifecycleHandler.startup(heavyweightPeer, moduleDescriptor);
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        } else {
            logger.debug((Object)("Module " + this.moduleName + " does not have a " + " lifecycle handler to perform a startup."));
        }
    }

    @Override
    public void shutdown() throws ModuleException {
        if (this.lifecycleHandler != null) {
            this.lifecycleHandler.shutdown();
        }
        this.classloader.close();
    }
}

