/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.IRemoteLingeringObject;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.PeerDisconnectedException;
import com.helpsystems.common.tl.ex.PeerResourceDisconnectedException;
import com.helpsystems.common.tl.ex.RuntimePeerDisconnectedException;
import com.helpsystems.common.tl.processor.CommandResponse;
import com.helpsystems.common.tl.processor.impl.DataManagerCommand;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class TLInvocationHandler
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(TLInvocationHandler.class);
    private static final int TIMEOUT;
    protected Peer localPeer;
    private PeerID remotePeerID;
    private String remoteDataManagerName;
    private int envelopePriority;
    private String cachedName;
    private Integer cachedVersion;

    protected TLInvocationHandler(Peer peer) {
        if (peer == null) {
            throw new NullPointerException("The local peer passed in is null.");
        }
        this.localPeer = peer;
    }

    public TLInvocationHandler(Peer peer, PeerID peerID, String string, int n) {
        this(peer);
        if (peerID == null) {
            throw new NullPointerException("The remote peer passed in is null.");
        }
        this.remotePeerID = peerID;
        this.remoteDataManagerName = string;
        this.envelopePriority = n;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.doInvoke(this.remotePeerID, this.remoteDataManagerName, object, method, objectArray);
    }

    protected Object doInvoke(PeerID peerID, String string, Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (this.localPeer == null) {
            throw new NullPointerException("The local peer is null.");
        }
        if (peerID == null) {
            throw new NullPointerException("The remote peer descriptor is null.");
        }
        if (string == null) {
            throw new NullPointerException("The remote DataManager name is null.");
        }
        String string2 = method.getName();
        if (method.getName().equals("managerRemoved") && object instanceof IAbstractManager) {
            logger.debug((Object)("TLInvocationHandler blocking a 'managerRemoved' call on virtual proxy " + object));
            return null;
        }
        if (string2.equals("getName") && this.cachedName != null) {
            return this.cachedName;
        }
        if (string2.equals("getInterfaceVersion") && this.cachedVersion != null) {
            return this.cachedVersion;
        }
        if (logger.isTraceEnabled()) {
            object2 = new StringBuffer("Invoking ");
            ((StringBuffer)object2).append(string2);
            ((StringBuffer)object2).append("(");
            if (objectArray == null || objectArray.length == 0) {
                ((StringBuffer)object2).append("NULL");
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)object2).append(",  ");
                    }
                    if (objectArray[i] == null) {
                        ((StringBuffer)object2).append("null");
                        continue;
                    }
                    ((StringBuffer)object2).append(objectArray[i].getClass().getName());
                    ((StringBuffer)object2).append("= ");
                    if (objectArray[i] instanceof File) {
                        ((StringBuffer)object2).append(((File)objectArray[i]).getAbsolutePath());
                        continue;
                    }
                    ((StringBuffer)object2).append(objectArray[i]);
                }
            }
            ((StringBuffer)object2).append(")");
            ((StringBuffer)object2).append(" on peer.DM " + peerID + "." + string);
            logger.trace((Object)((StringBuffer)object2).toString());
        }
        object2 = new Envelope();
        ((Envelope)((Object)object2)).setDestination(peerID);
        ((Envelope)((Object)object2)).setPriority(this.envelopePriority);
        DataManagerCommand dataManagerCommand = new DataManagerCommand(string, string2, method.getParameterTypes(), objectArray);
        dataManagerCommand.setSource(this.localPeer.getRemotePeerID());
        Envelope envelope = null;
        CommandResponse commandResponse = null;
        ((Envelope)((Object)object2)).setPayload(dataManagerCommand);
        ((Envelope)((Object)object2)).setPriority(this.envelopePriority);
        try {
            envelope = this.localPeer.sendEnvelopeAndWait((Envelope)((Object)object2), TIMEOUT);
        }
        catch (EnvelopeException envelopeException) {
            this.handleThrownObject(method, envelopeException);
        }
        if (envelope == null) {
            throw new RuntimeException("Timeout while waiting for a response from peer " + peerID);
        }
        commandResponse = (CommandResponse)envelope.getPayload();
        if (commandResponse == null) {
            logger.debug((Object)"Remote DataManager exec got a null Response back.");
            return null;
        }
        Object object3 = commandResponse.getResponse();
        if (object3 != null && object3 instanceof Throwable) {
            this.handleThrownObject(method, (Throwable)object3);
        }
        if (object3 instanceof IRemoteLingeringObject) {
            IRemoteLingeringObject iRemoteLingeringObject = (IRemoteLingeringObject)object3;
            iRemoteLingeringObject.setLocalPeer(this.localPeer);
        }
        if (string2.equals("getName") && object3 instanceof String) {
            this.cachedName = (String)object3;
        } else if (string2.equals("getInterfaceVersion") && object3 instanceof Integer) {
            this.cachedVersion = (Integer)object3;
        }
        return object3;
    }

    private void handleThrownObject(Method method, Throwable throwable) throws Throwable {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        Throwable throwable2 = throwable;
        Class<?> clazz = throwable.getClass();
        Class<?>[] classArray = method.getExceptionTypes();
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isAssignableFrom(clazz)) {
                throw throwable2;
            }
            if (!classArray[i].isAssignableFrom(ResourceUnavailableException.class)) continue;
            bl = true;
        }
        if (throwable instanceof PeerDisconnectedException) {
            if (bl) {
                throw new PeerResourceDisconnectedException(throwable.getMessage(), throwable);
            }
            throw new RuntimePeerDisconnectedException(throwable.getMessage(), throwable);
        }
        if (bl) {
            throw new ResourceUnavailableException(throwable2.getMessage(), throwable2);
        }
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw new RuntimeException(throwable2.getMessage(), throwable2);
    }

    static {
        long l = HSJvmProperties.getTLTimeout() * 1000L;
        if (l < 1L) {
            l = 300000L;
        }
        TIMEOUT = (int)l;
    }
}

