/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.PeerStats;
import java.util.Date;

public abstract class PeerStatsHelper {
    private static final String WHEN_CONNECTION_ESTABLISHED_KEY = "WhenConEstKey";
    private static final String ENVELOPE_TX_COUNT = "EnvTXCount";
    private static final String ENVELOPE_RX_COUNT = "EnvRXCount";
    private static final String WHEN_LAST_ENVELOPE_TX = "WhenLastEnvTX";
    private static final String WHEN_LAST_ENVELOPE_RX = "WhenLastEnvRX";
    private static final String PEER_ID = "PeerID";
    private static final String QUEUE_BACKLOG = "QueueBacklog";

    public static PeerID getRemotePeerID(PeerStats peerStats) {
        return (PeerID)peerStats.get(PEER_ID);
    }

    public static Date getWhenConnectionEstablished(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(WHEN_CONNECTION_ESTABLISHED_KEY);
        if (lArray != null && lArray.length > 0) {
            return new Date(lArray[0]);
        }
        return null;
    }

    public static Date getWhenLastEnvelopeRX(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(WHEN_LAST_ENVELOPE_RX);
        if (lArray != null && lArray.length > 0) {
            return new Date(lArray[0]);
        }
        return null;
    }

    public static Date getWhenLastEnvelopeTX(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(WHEN_LAST_ENVELOPE_TX);
        if (lArray != null && lArray.length > 0) {
            return new Date(lArray[0]);
        }
        return null;
    }

    public static long getEnvelopeRXCount(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(ENVELOPE_RX_COUNT);
        if (lArray != null && lArray.length > 0) {
            return lArray[0];
        }
        return 0L;
    }

    public static long getEnvelopeTXCount(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(ENVELOPE_TX_COUNT);
        if (lArray != null && lArray.length > 0) {
            return lArray[0];
        }
        return 0L;
    }

    public static int getQueueBacklog(PeerStats peerStats) {
        int[] nArray = (int[])peerStats.get(QUEUE_BACKLOG);
        if (nArray != null && nArray.length > 0) {
            return nArray[0];
        }
        return 0;
    }

    public static void incrementEnvelopeRXCount(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(ENVELOPE_RX_COUNT);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = lArray[0] + 1L;
        } else {
            lArray = new long[]{1L};
            peerStats.put(ENVELOPE_RX_COUNT, lArray);
        }
        PeerStatsHelper.setWhenLastEnvelopeRX(peerStats, System.currentTimeMillis());
    }

    public static void incrementEnvelopeTXCount(PeerStats peerStats) {
        long[] lArray = (long[])peerStats.get(ENVELOPE_TX_COUNT);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = lArray[0] + 1L;
        } else {
            lArray = new long[]{1L};
            peerStats.put(ENVELOPE_TX_COUNT, lArray);
        }
        PeerStatsHelper.setWhenLastEnvelopeTX(peerStats, System.currentTimeMillis());
    }

    public static void setRemotePeerID(PeerStats peerStats, PeerID peerID) {
        peerStats.put(PEER_ID, peerID);
    }

    public static void setQueueBacklog(PeerStats peerStats, int n) {
        int[] nArray = (int[])peerStats.get(QUEUE_BACKLOG);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n;
        } else {
            nArray = new int[]{n};
            peerStats.put(QUEUE_BACKLOG, nArray);
        }
    }

    public static void setWhenLastEnvelopeRX(PeerStats peerStats, long l) {
        long[] lArray = (long[])peerStats.get(WHEN_LAST_ENVELOPE_RX);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = l;
        } else {
            lArray = new long[]{l};
            peerStats.put(WHEN_LAST_ENVELOPE_RX, lArray);
        }
    }

    public static void setWhenLastEnvelopeTX(PeerStats peerStats, long l) {
        long[] lArray = (long[])peerStats.get(WHEN_LAST_ENVELOPE_TX);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = l;
        } else {
            lArray = new long[]{l};
            peerStats.put(WHEN_LAST_ENVELOPE_TX, lArray);
        }
    }

    public static void setWhenConnectionEstablished(PeerStats peerStats, long l) {
        long[] lArray = new long[]{l};
        peerStats.put(WHEN_CONNECTION_ESTABLISHED_KEY, lArray);
    }
}

