/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.LoadDM;
import com.helpsystems.common.tl.LoadHost;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LoadNode
extends HeavyweightPeer {
    static String FAKE_LIBRARY = "BlahLib";
    private static final String[] SPINNER = new String[]{"|", "/", "-", "\\", "|", "/", "-", "\\", ".", ":"};
    private long myNumber;
    private long failureCount;
    private Random random = new Random();
    private HashMap<ProductIID, Long> deadNodeMap = new HashMap();
    private static final long DEAD_INTERVAL = 30000L;
    private static final Logger logger = Logger.getLogger(LoadNode.class);

    public LoadNode(PeerDescriptor peerDescriptor) throws PeerStartupException {
        super(peerDescriptor, (Serializable)((Object)(FAKE_LIBRARY + peerDescriptor.getPort())), new HeavyweightPeerConfig());
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                LoadNode.this.updateDisplay();
            }
        }, 0L, 250L);
    }

    private void updateDisplay() {
        if (this.getHostsFromRoutingTable().length > 0) {
            System.out.print("\r" + LoadNode.getSpinChar() + " " + this.myNumber + ", failures = " + this.failureCount);
        }
    }

    @Override
    protected void checkCredentials(ConnectRequest connectRequest) throws InvalidCredentialsException {
        logger.info((Object)("Accepting connect from " + connectRequest.getPeerID()));
    }

    public static void main(String[] stringArray) throws Exception {
        int n = LoadHost.findOpenPort(3000);
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.WARN);
        String string = "n" + (n - 3000) + ".log";
        logger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} %t> %m\n"), string, false));
        PeerDescriptor peerDescriptor = PeerDescriptor.createLocalPeerDescriptor(n, 2);
        LoadNode loadNode = null;
        try {
            loadNode = new LoadNode(peerDescriptor);
            loadNode.myNumber = (long)n * 10000000L;
            loadNode.startup();
            loadNode.connectToHost();
            loadNode.loadManagers();
        }
        catch (Throwable throwable) {
            LoadNode.logger.error((Object)"Unable to start the node.", throwable);
            System.exit(-1);
        }
        try {
            loadNode.makeTraffic();
            loadNode.shutdown();
            System.exit(0);
        }
        catch (Throwable throwable) {
            LoadNode.logger.error((Object)"Node is exiting", throwable);
            System.exit(-1);
        }
    }

    private void connectToHost() {
        int n = this.getRemotePeerID().getPeerDescriptor().getPort();
        int n2 = n - 1000;
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.addAddress("localhost");
        peerDescriptor.setPort(n2);
        peerDescriptor.setType(1);
        try {
            this.connectToPeer(peerDescriptor, (Serializable)((Object)"me"));
            System.out.println("Connected to host " + n2);
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to connect to peer " + peerDescriptor), (Throwable)exception);
        }
    }

    private void makeTraffic() {
        while (true) {
            Object object;
            if (this.getHostsFromRoutingTable().length == 0) {
                System.out.println("\nWaiting for our host....");
                try {
                    this.connectToHost();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            int n = 0;
            ProductIID productIID = null;
            while (productIID == null) {
                n = this.random.nextInt(5) + 3000;
                if (n > 3004) {
                    n = 3000;
                }
                if ((object = this.deadNodeMap.get(productIID = new ProductIID(n))) == null) continue;
                long l = (Long)object + 30000L;
                if (l > System.currentTimeMillis()) {
                    productIID = null;
                    continue;
                }
                this.deadNodeMap.remove(productIID);
            }
            try {
                object = (LoadDM)ManagerRegistry.getManagerStartsWith(productIID, (String)"BLAH.LoadDM");
                ++this.myNumber;
                Long l = new Long(this.myNumber);
                logger.info((Object)("Sending up number " + this.myNumber + " to node " + productIID));
                Long l2 = (Long)object.echo(l);
                if (l.equals(l2)) continue;
                logger.fatal((Object)("!!!! Mismatched response !!!!\nSent: " + l + "\nGot:  " + l2));
                System.exit(2);
                continue;
            }
            catch (Exception exception) {
                ++this.failureCount;
                logger.warn((Object)("Could not reach peer piid " + n), (Throwable)exception);
                this.deadNodeMap.put(productIID, new Long(System.currentTimeMillis()));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void loadManagers() {
        ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin(this));
        ManagerRegistry.registerManager((IAbstractManager)new MyLoadDM());
    }

    static String getSpinChar() {
        long l = System.currentTimeMillis();
        int n = (int)((l /= 1000L) % 10L);
        return SPINNER[n];
    }

    public class MyLoadDM
    extends AbstractManager
    implements LoadDM {
        public MyLoadDM() {
            this.setName("BLAH.LoadDM");
        }

        @Override
        public Object echo(Object object) {
            return this.echo(object, 0);
        }

        @Override
        public Object echo(Object object, int n) {
            logger.info((Object)("Echoing " + object));
            if (n > 0) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return object;
        }
    }
}

