/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.network;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.network.NodeProxy;
import com.helpsystems.common.core.network.ProductProxy;
import com.helpsystems.common.core.network.SystemIID;
import com.helpsystems.common.core.network.SystemProxy;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.network.RuntimeNodeProxy;
import com.helpsystems.common.tl.network.RuntimeNodeProxyDM;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class RuntimeNodeProxyDMJdbc
extends AbstractHelpingDatabaseManager
implements RuntimeNodeProxyDM {
    private static final Logger logger = Logger.getLogger(RuntimeNodeProxyDMJdbc.class);
    private static final String BASE_XML = "<database-mappings><association class=\"com.helpsystems.common.core.network.SystemProxy\" table=\"RBNSYS\" defaultSortField=\"10101\" defaultSortDirection=\"asc\"><mapping field=\"SYSSIID\" method=\"setSystemIID\" type=\"int\"/><mapping field=\"SYSNAME\" method=\"setName\" type=\"String\" sort=\"10101\"/><mapping field=\"SYSDESC\" method=\"setDescription\" type=\"String\"/><mapping field=\"SYSADDR\" method=\"setAddress\" type=\"String\"/><mapping field=\"SYSHKEY\" method=\"setHardwareKey\" type=\"String\"/><mapping field=\"SYSTIMZON\" method=\"setTimeZone\" type=\"int\"/></association><association class=\"com.helpsystems.common.core.network.ProductProxy\" table=\"RBNPRD\"><mapping field=\"PRDSIID\" method=\"setSystemIID\" type=\"int\"/><mapping field=\"PRDNAME\" method=\"setName\" type=\"String\"/><mapping field=\"PRDDESC\" method=\"setDescription\" type=\"String\"/><mapping field=\"PRDLOC\" method=\"setLocation\" type=\"String\"/><mapping field=\"PRDPIID\" method=\"setProductIIDInt\" type=\"int\"/><mapping field=\"PRDNPIID\" method=\"setNodeProductIID\" type=\"int\"/><mapping field=\"PRDRELMOD\" method=\"setRelmod\" type=\"String\"/></association><association class=\"com.helpsystems.common.core.network.NodeProxy\" table=\"RBNCS\"><mapping field=\"CSSIID\" method=\"setSystemIIDInt\" type=\"int\"/><mapping field=\"CSPIID\" method=\"setProductIIDInt\" type=\"int\"/><mapping field=\"CSISHOST\" method=\"setType\" type=\"int\"/></association></database-mappings>";

    public RuntimeNodeProxyDMJdbc(String string, String string2, String string3) throws ResourceUnavailableException {
        super(string, string2, RuntimeNodeProxyDMJdbc.createHelper());
        this.setName(string3);
    }

    private static SQLManagerHelper createHelper() throws ResourceUnavailableException {
        try {
            Document document = XMLUtil.stringToDocument((String)BASE_XML);
            SQLManagerHelper sQLManagerHelper = new SQLManagerHelper(document);
            return sQLManagerHelper;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to prepare a SQL Helper.", (Throwable)exception);
        }
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        SystemProxy systemProxy = new SystemProxy();
        ProductProxy productProxy = new ProductProxy();
        NodeProxy nodeProxy = new NodeProxy();
        try {
            SystemProxy[] systemProxyArray = (SystemProxy[])ArrayDataSet.toArray((DataSet)super.getDataSet(systemProxy, null, null), (boolean)true);
            ProductProxy[] productProxyArray = (ProductProxy[])ArrayDataSet.toArray((DataSet)super.getDataSet(productProxy, null, null), (boolean)true);
            NodeProxy[] nodeProxyArray = (NodeProxy[])ArrayDataSet.toArray((DataSet)super.getDataSet(nodeProxy, null, null), (boolean)false);
            Object[] objectArray = new RuntimeNodeProxy[systemProxyArray.length];
            for (int i = 0; i < systemProxyArray.length; ++i) {
                systemProxy = systemProxyArray[i];
                RuntimeNodeProxy runtimeNodeProxy = new RuntimeNodeProxy();
                runtimeNodeProxy.setSystemName(systemProxy.getName());
                runtimeNodeProxy.setSystemDescription(systemProxy.getDescription());
                runtimeNodeProxy.setAddress(systemProxy.getAddress());
                runtimeNodeProxy.setHardwareIdentifier(systemProxy.getHardwareKey());
                for (int j = 0; j < nodeProxyArray.length; ++j) {
                    if (nodeProxyArray[j].getSystemIIDInt() != systemProxy.getSystemIID()) continue;
                    runtimeNodeProxy.setType(nodeProxyArray[j].getType());
                    if (nodeProxyArray[j].getType() == 0 || nodeProxyArray[j].getType() == 2 || nodeProxyArray[j].getType() == 3) break;
                }
                String string = null;
                String string2 = null;
                for (int j = 0; j < productProxyArray.length; ++j) {
                    productProxy = productProxyArray[j];
                    if (productProxy.getSystemIID() != systemProxy.getSystemIID()) continue;
                    runtimeNodeProxy.addProduct(productProxy);
                    if ("NETNODE".equals(productProxy.getName())) {
                        string = productProxy.getLocation();
                    }
                    if (!"NETHOST".equals(productProxy.getName())) continue;
                    string2 = productProxy.getLocation();
                }
                String string3 = string2;
                if (string2 == null) {
                    string3 = string;
                }
                if (string3 == null) continue;
                runtimeNodeProxy.setSystemIID(new SystemIID(systemProxy.getSystemIID()));
                runtimeNodeProxy.setTimeZone(systemProxy.getTimeZone());
                objectArray[i] = runtimeNodeProxy;
            }
            return new ArrayDataSet(objectArray);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve a DataSet.", (Throwable)exception);
        }
    }

    public RuntimeNodeProxy[] getList() throws ResourceUnavailableException {
        return this.getList(false, null);
    }

    public RuntimeNodeProxy[] getList(boolean bl) throws ResourceUnavailableException {
        return this.getList(bl, null);
    }

    public RuntimeNodeProxy[] getList(String string) throws ResourceUnavailableException {
        return this.getList(false, string);
    }

    public RuntimeNodeProxy[] getList(boolean bl, String string) throws ResourceUnavailableException {
        String string2 = string;
        if (string != null) {
            if (string.equalsIgnoreCase("SCHEDULE")) {
                string2 = "ROBOT";
            }
            if (string.equalsIgnoreCase("SAVE")) {
                string2 = "ROBOTSAV";
            }
        }
        try {
            Vector<RuntimeNodeProxy> vector = new Vector<RuntimeNodeProxy>();
            RuntimeNodeProxy[] runtimeNodeProxyArray = new RuntimeNodeProxy[]{};
            DataSet dataSet = this.getDataSet(null, null, null);
            if (dataSet.size() > 0) {
                runtimeNodeProxyArray = (RuntimeNodeProxy[])ArrayDataSet.toArray((DataSet)dataSet, (boolean)false);
            }
            if (runtimeNodeProxyArray != null) {
                logger.trace((Object)("Found " + runtimeNodeProxyArray.length + " RuntimeNodeProxy objects."));
                for (int i = 0; i < runtimeNodeProxyArray.length; ++i) {
                    RuntimeNodeProxy runtimeNodeProxy = null;
                    runtimeNodeProxy = string2 != null && runtimeNodeProxyArray[i] != null ? this.keepProducts(string2, runtimeNodeProxyArray[i]) : runtimeNodeProxyArray[i];
                    if (runtimeNodeProxy != null) {
                        if (runtimeNodeProxy.getType() == 0 || runtimeNodeProxy.getType() == 3 && bl) {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Including Node " + runtimeNodeProxy.getName()));
                            }
                            vector.add(runtimeNodeProxy);
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("Exluding Node " + runtimeNodeProxy.getSystemName() + " with Type " + runtimeNodeProxy.getType() + " - Type is invalid."));
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    if (runtimeNodeProxyArray[i] != null) {
                        logger.trace((Object)("Exluding Node " + runtimeNodeProxyArray[i].getSystemName() + " with Type " + runtimeNodeProxyArray[i].getType() + " - No Matching Product found."));
                        continue;
                    }
                    logger.trace((Object)("Excluding runtimeNodeProxyElement " + i + " RuntimeNodeProxy is null, possible bad data. "));
                }
                if (vector.size() > 0) {
                    RuntimeNodeProxy[] runtimeNodeProxyArray2 = new RuntimeNodeProxy[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        runtimeNodeProxyArray2[i] = (RuntimeNodeProxy)vector.elementAt(i);
                    }
                    return runtimeNodeProxyArray2;
                }
                return null;
            }
            logger.debug((Object)"No RuntimeNodeProxy objects were found.");
            return null;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve a list of RuntimeNodeProxy objects.", (Throwable)exception);
        }
    }

    private RuntimeNodeProxy keepProducts(String string, RuntimeNodeProxy runtimeNodeProxy) {
        logger.trace((Object)("RuntimeNodeProxy object found for " + runtimeNodeProxy.getSystemName()));
        ProductProxy[] productProxyArray = runtimeNodeProxy.getProducts();
        ArrayList<ProductProxy> arrayList = new ArrayList<ProductProxy>();
        for (int i = 0; i < productProxyArray.length; ++i) {
            ProductProxy productProxy = productProxyArray[i];
            logger.trace((Object)("Product name is " + productProxy.getName()));
            if (!productProxy.getName().equalsIgnoreCase(string)) continue;
            logger.trace((Object)(string + " exists on the Node " + runtimeNodeProxy.getSystemName()));
            arrayList.add(productProxy);
        }
        if (arrayList.size() == 0) {
            logger.trace((Object)("Node " + runtimeNodeProxy.getSystemName() + " does not have the Product " + string + " installed."));
            return null;
        }
        runtimeNodeProxy.clearProducts();
        for (ProductProxy productProxy : arrayList) {
            runtimeNodeProxy.addProduct(productProxy);
        }
        return runtimeNodeProxy;
    }
}

