/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.UtilLoggingLevel;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.UtilLoggingEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UtilLoggingXMLDecoder
implements Decoder {
    private static final String BEGIN_PART = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE log SYSTEM \"logger.dtd\"><log>";
    private static final String END_PART = "</log>";
    private DocumentBuilderFactory dbf;
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private static final String RECORD_END = "</record>";
    private Component owner = null;

    public UtilLoggingXMLDecoder(Component component) {
        this();
        this.owner = component;
    }

    public UtilLoggingXMLDecoder() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setValidating(false);
        try {
            this.docBuilder = this.dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler(new SAXErrorHandler());
            this.docBuilder.setEntityResolver(new UtilLoggingEntityResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Unable to get document builder");
        }
    }

    public void setAdditionalProperties(Map map) {
        this.additionalProperties.putAll(map);
    }

    private Document parse(String string) {
        if (this.docBuilder == null || string == null) {
            return null;
        }
        Document document = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(1024);
            if (!string.startsWith("<?xml")) {
                stringBuffer.append(BEGIN_PART);
            }
            stringBuffer.append(string);
            if (!string.endsWith(END_PART)) {
                stringBuffer.append(END_PART);
            }
            InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
            inputSource.setSystemId("dummy://logger.dtd");
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector decode(URL uRL) throws IOException {
        LineNumberReader lineNumberReader = null;
        lineNumberReader = this.owner != null ? new LineNumberReader(new InputStreamReader(new ProgressMonitorInputStream(this.owner, "Loading " + uRL, uRL.openStream()))) : new LineNumberReader(new InputStreamReader(uRL.openStream()));
        Vector vector = new Vector();
        String string = null;
        try {
            while ((string = lineNumberReader.readLine()) != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int i = 0; i < 100; ++i) {
                    stringBuffer.append(lineNumberReader.readLine());
                }
                vector.addAll(this.decodeEvents(stringBuffer.toString()));
            }
            Object var8_7 = null;
            this.partialEvent = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.partialEvent = null;
            try {
                if (lineNumberReader != null) {
                    lineNumberReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (lineNumberReader != null) {
                lineNumberReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public Vector decodeEvents(String string) {
        if (string != null) {
            if (string.equals("")) {
                return null;
            }
            String string2 = null;
            String string3 = null;
            if (string.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + string;
                return null;
            }
            if (string.lastIndexOf(RECORD_END) + RECORD_END.length() < string.length()) {
                string2 = string.substring(0, string.lastIndexOf(RECORD_END) + RECORD_END.length());
                string3 = string.substring(string.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                string2 = string;
            }
            if (this.partialEvent != null) {
                string2 = this.partialEvent + string2;
            }
            this.partialEvent = string3;
            Document document = this.parse(string2);
            if (document == null) {
                return null;
            }
            return this.decodeEvents(document);
        }
        return null;
    }

    public LoggingEvent decode(String string) {
        Document document = this.parse(string);
        if (document == null) {
            return null;
        }
        Vector vector = this.decodeEvents(document);
        if (vector.size() > 0) {
            return (LoggingEvent)vector.firstElement();
        }
        return null;
    }

    private Vector decodeEvents(Document document) {
        Vector<Object> vector = new Vector<Object>();
        NodeList nodeList = document.getElementsByTagName("record");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Map.Entry entry;
            Node node = nodeList.item(i);
            Logger logger = null;
            long l = 0L;
            Level level = null;
            String string = null;
            String string2 = null;
            Object var12_11 = null;
            String[] stringArray = null;
            String string3 = null;
            String string4 = null;
            Object var16_15 = null;
            Object var17_16 = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            NodeList nodeList2 = node.getChildNodes();
            int n = nodeList2.getLength();
            if (n == 0) continue;
            for (int j = 0; j < n; ++j) {
                entry = nodeList2.item(j).getNodeName();
                if (((String)((Object)entry)).equalsIgnoreCase("logger")) {
                    logger = Logger.getLogger(this.getCData(nodeList2.item(j)));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("millis")) {
                    l = Long.parseLong(this.getCData(nodeList2.item(j)));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("level")) {
                    level = UtilLoggingLevel.toLevel(this.getCData(nodeList2.item(j)));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("thread")) {
                    string = this.getCData(nodeList2.item(j));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("sequence")) {
                    hashtable.put("log4jid", this.getCData(nodeList2.item(j)));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("message")) {
                    string2 = this.getCData(nodeList2.item(j));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("class")) {
                    string3 = this.getCData(nodeList2.item(j));
                }
                if (((String)((Object)entry)).equalsIgnoreCase("method")) {
                    string4 = this.getCData(nodeList2.item(j));
                }
                if (!((String)((Object)entry)).equalsIgnoreCase("exception")) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                NodeList nodeList3 = nodeList2.item(j).getChildNodes();
                int n2 = nodeList3.getLength();
                for (int k = 0; k < n2; ++k) {
                    Node node2 = nodeList3.item(k);
                    String string5 = nodeList3.item(k).getNodeName();
                    if (string5.equalsIgnoreCase("message")) {
                        arrayList.add(this.getCData(nodeList3.item(k)));
                    }
                    if (!string5.equalsIgnoreCase("frame")) continue;
                    NodeList nodeList4 = node2.getChildNodes();
                    int n3 = nodeList4.getLength();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        arrayList.add(this.getCData(nodeList4.item(i2)) + "\n");
                    }
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            if (this.additionalProperties.size() > 0) {
                if (hashtable == null) {
                    hashtable = new Hashtable(this.additionalProperties);
                } else {
                    Iterator iterator = this.additionalProperties.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        if (hashtable.containsKey(entry.getKey())) continue;
                        hashtable.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            LocationInfo locationInfo = null;
            locationInfo = var16_15 != null || string3 != null || string4 != null || var17_16 != null ? new LocationInfo(var16_15, string3, string4, var17_16) : LocationInfo.NA_LOCATION_INFO;
            if (stringArray == null) {
                stringArray = new String[]{""};
            }
            entry = new LoggingEvent();
            ((LoggingEvent)((Object)entry)).setLogger(logger);
            ((LoggingEvent)((Object)entry)).setTimeStamp(l);
            ((LoggingEvent)((Object)entry)).setLevel(level);
            ((LoggingEvent)((Object)entry)).setThreadName(string);
            ((LoggingEvent)((Object)entry)).setMessage(string2);
            ((LoggingEvent)((Object)entry)).setNDC(var12_11);
            ((LoggingEvent)((Object)entry)).setThrowableInformation(new ThrowableInformation(stringArray));
            ((LoggingEvent)((Object)entry)).setLocationInformation(locationInfo);
            ((LoggingEvent)((Object)entry)).setProperties(hashtable);
            vector.add(entry);
            logger = null;
            l = 0L;
            level = null;
            string = null;
            string2 = null;
            var12_11 = null;
            stringArray = null;
            string3 = null;
            string4 = null;
            var16_15 = null;
            var17_16 = null;
            hashtable = null;
        }
        return vector;
    }

    private String getCData(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
            stringBuffer.append(node2.getNodeValue());
        }
        return stringBuffer.toString();
    }
}

