/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rule.AndRule;
import org.apache.log4j.rule.EqualsRule;
import org.apache.log4j.rule.ExistsRule;
import org.apache.log4j.rule.InequalityRule;
import org.apache.log4j.rule.LikeRule;
import org.apache.log4j.rule.NotEqualsRule;
import org.apache.log4j.rule.NotRule;
import org.apache.log4j.rule.OrRule;
import org.apache.log4j.rule.PartialTextMatchRule;
import org.apache.log4j.rule.Rule;

public class RuleFactory {
    private static final RuleFactory factory_ = new RuleFactory();
    private static final Collection rules = new LinkedList();
    private static final String AND_RULE = "&&";
    private static final String OR_RULE = "||";
    private static final String NOT_RULE = "!";
    private static final String NOT_EQUALS_RULE = "!=";
    private static final String EQUALS_RULE = "==";
    private static final String PARTIAL_TEXT_MATCH_RULE = "~=";
    private static final String LIKE_RULE = "like";
    private static final String EXISTS_RULE = "exists";
    private static final String LESS_THAN_RULE = "<";
    private static final String GREATER_THAN_RULE = ">";
    private static final String LESS_THAN_EQUALS_RULE = "<=";
    private static final String GREATER_THAN_EQUALS_RULE = ">=";

    private RuleFactory() {
    }

    public static RuleFactory getInstance() {
        return factory_;
    }

    public boolean isRule(String string) {
        return string != null && rules.contains(string.toLowerCase());
    }

    public Rule getRule(String string, Stack stack) {
        if (AND_RULE.equals(string)) {
            return AndRule.getRule(stack);
        }
        if (OR_RULE.equals(string)) {
            return OrRule.getRule(stack);
        }
        if (NOT_RULE.equals(string)) {
            return NotRule.getRule(stack);
        }
        if (NOT_EQUALS_RULE.equals(string)) {
            return NotEqualsRule.getRule(stack);
        }
        if (EQUALS_RULE.equals(string)) {
            return EqualsRule.getRule(stack);
        }
        if (PARTIAL_TEXT_MATCH_RULE.equals(string)) {
            return PartialTextMatchRule.getRule(stack);
        }
        if (rules.contains(LIKE_RULE) && LIKE_RULE.equalsIgnoreCase(string)) {
            return LikeRule.getRule(stack);
        }
        if (EXISTS_RULE.equalsIgnoreCase(string)) {
            return ExistsRule.getRule(stack);
        }
        if (LESS_THAN_RULE.equals(string)) {
            return InequalityRule.getRule(LESS_THAN_RULE, stack);
        }
        if (GREATER_THAN_RULE.equals(string)) {
            return InequalityRule.getRule(GREATER_THAN_RULE, stack);
        }
        if (LESS_THAN_EQUALS_RULE.equals(string)) {
            return InequalityRule.getRule(LESS_THAN_EQUALS_RULE, stack);
        }
        if (GREATER_THAN_EQUALS_RULE.equals(string)) {
            return InequalityRule.getRule(GREATER_THAN_EQUALS_RULE, stack);
        }
        throw new IllegalArgumentException("Invalid rule: " + string);
    }

    static {
        rules.add(AND_RULE);
        rules.add(OR_RULE);
        rules.add(NOT_RULE);
        rules.add(NOT_EQUALS_RULE);
        rules.add(EQUALS_RULE);
        rules.add(PARTIAL_TEXT_MATCH_RULE);
        try {
            Class.forName("org.apache.oro.text.regex.Perl5Compiler");
            rules.add(LIKE_RULE);
        }
        catch (Exception exception) {
            LogLog.info("ORO classes not found - Like rule not supported");
        }
        rules.add(EXISTS_RULE);
        rules.add(LESS_THAN_RULE);
        rules.add(GREATER_THAN_RULE);
        rules.add(LESS_THAN_EQUALS_RULE);
        rules.add(GREATER_THAN_EQUALS_RULE);
    }
}

