/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ExistsRule
extends AbstractRule {
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private final String field;

    private ExistsRule(String string) {
        if (!resolver.isField(string)) {
            throw new IllegalArgumentException("Invalid EXISTS rule - " + string + " is not a supported field");
        }
        this.field = string;
    }

    public static Rule getRule(String string) {
        return new ExistsRule(string);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("Invalid EXISTS rule - expected one parameter but received " + stack.size());
        }
        return new ExistsRule(stack.pop().toString());
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        Object object = resolver.getValue(this.field, loggingEvent);
        return object != null && (object == null || !object.toString().equals(""));
    }
}

