/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.lang.reflect.Method;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.action.Action;
import org.apache.joran.helper.Option;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.ActionConst;
import org.apache.log4j.spi.LoggerRepository;
import org.xml.sax.Attributes;

public class LoggerAction
extends Action {
    Logger logger = Logger.getLogger(class$org$apache$log4j$joran$action$LoggerAction == null ? (class$org$apache$log4j$joran$action$LoggerAction = LoggerAction.class$("org.apache.log4j.joran.action.LoggerAction")) : class$org$apache$log4j$joran$action$LoggerAction);
    boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$joran$action$LoggerAction;

    /*
     * WARNING - void declaration
     */
    public void begin(ExecutionContext ec, String name, Attributes attributes) {
        void var6_7;
        Logger l;
        this.inError = false;
        LoggerRepository repository = (LoggerRepository)ec.getObject(0);
        String loggerName = attributes.getValue("name");
        if (Option.isEmpty(loggerName)) {
            this.inError = true;
            String line = ", around line " + this.getLineNumber(ec) + " column " + this.getColumnNumber(ec);
            String errorMsg = "No 'name' attribute in element " + name + line;
            this.logger.warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        this.logger.debug("Logger name is [" + loggerName + "].");
        String className = attributes.getValue("class");
        if (Option.isEmpty(className)) {
            this.logger.debug("Retreiving an instance of org.apache.log4j.Logger.");
            l = repository.getLogger(loggerName);
        } else {
            this.logger.debug("Desired logger sub-class: [" + className + ']');
            try {
                Class clazz = Loader.loadClass(className);
                Method getInstanceMethod = clazz.getMethod("getLogger", ActionConst.ONE_STRING_PARAM);
                l = (Logger)getInstanceMethod.invoke(null, loggerName);
            }
            catch (Exception oops) {
                this.logger.error("Could not retrieve category [" + loggerName + "]. Reported error follows.", oops);
                return;
            }
        }
        boolean additivity = OptionConverter.toBoolean(attributes.getValue("additivity"), true);
        this.logger.debug("Setting [" + var6_7.getName() + "] additivity to [" + additivity + "].");
        var6_7.setAdditivity(additivity);
        this.logger.debug("Pushing logger named [" + loggerName + "].");
        ec.pushObject(var6_7);
    }

    public void end(ExecutionContext ec, String e) {
        this.logger.debug("end() called.");
        if (!this.inError) {
            this.logger.debug("Removing logger from stack.");
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

