/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;

public class LoggerTraverse {
    private Map loggerMap = new TreeMap();
    private Logger rootLogger;

    public LoggerTraverse() {
    }

    public LoggerTraverse(LoggerRepository repository) {
        this.update(repository);
    }

    public void update(LoggerRepository repository) {
        this.loggerMap.clear();
        this.rootLogger = repository.getRootLogger();
        Enumeration loggerEnum = repository.getCurrentLoggers();
        while (loggerEnum.hasMoreElements()) {
            Logger logger = (Logger)loggerEnum.nextElement();
            this.loggerMap.put(logger.getName(), logger);
        }
    }

    public List getLoggerNames() {
        ArrayList<String> loggerList = new ArrayList<String>(this.loggerMap.size());
        Iterator loggerIter = this.loggerMap.keySet().iterator();
        while (loggerIter.hasNext()) {
            loggerList.add((String)loggerIter.next());
        }
        return loggerList;
    }

    public List getLoggerPackageNames(String startPattern) {
        String name = "";
        ArrayList<String> packageList = new ArrayList<String>(1);
        Iterator loggerIter = this.loggerMap.keySet().iterator();
        while (loggerIter.hasNext()) {
            String loggerName = (String)loggerIter.next();
            if (!loggerName.startsWith(startPattern) || (loggerName = loggerName.substring(startPattern.length())).length() <= 0) continue;
            if (loggerName.startsWith(".")) {
                loggerName = loggerName.substring(1);
            } else if (startPattern.length() > 0) break;
            int index = loggerName.indexOf(46);
            if (index != -1) {
                loggerName = loggerName.substring(0, index);
            }
            if (loggerName.equals(name)) continue;
            packageList.add(loggerName);
            name = loggerName;
        }
        return packageList;
    }

    public boolean loggerHasSubPackages(String startPattern) {
        int len = startPattern.length();
        Iterator loggerIter = this.loggerMap.keySet().iterator();
        while (loggerIter.hasNext()) {
            String loggerName = (String)loggerIter.next();
            if (!loggerName.startsWith(startPattern) || loggerName.length() <= len) continue;
            return true;
        }
        return false;
    }

    public Level getLevelForRootLogger() {
        return this.rootLogger.getEffectiveLevel();
    }

    public Level getLevelForPackage(String packageName) {
        String name = packageName;
        Logger logger = (Logger)this.loggerMap.get(packageName);
        while (logger == null && name != null) {
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index - 1);
                logger = (Logger)this.loggerMap.get(packageName);
                continue;
            }
            name = null;
        }
        if (logger != null) {
            return logger.getEffectiveLevel();
        }
        return this.rootLogger.getEffectiveLevel();
    }

    public boolean getLevelIsSetForPackage(String packageName) {
        String name = packageName;
        Logger logger = (Logger)this.loggerMap.get(packageName);
        while (logger == null && name != null) {
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index - 1);
                logger = (Logger)this.loggerMap.get(packageName);
                continue;
            }
            name = null;
        }
        if (logger != null) {
            if (logger == this.rootLogger) {
                return true;
            }
            return logger.getLevel() != null;
        }
        return false;
    }

    public static void main(String[] args) {
        Logger.getRootLogger().setLevel(Level.ERROR);
        Logger.getLogger("org.womacknet.wgntool.Researcher");
        Logger.getLogger("org.womacknet.wgntool.ResearcherList");
        Logger.getLogger("org.womacknet.wgntool").setLevel(Level.WARN);
        Logger.getLogger("org.womacknet.util.NameUtil");
        Logger.getLogger("com.widgets_r_us.util.StringUtil").setLevel(Level.DEBUG);
        LoggerTraverse info = new LoggerTraverse(LogManager.getLoggerRepository());
        System.out.println("NOTE: '*' indicates the level has not been explicitly configured for that logger");
        System.out.println("root - " + info.getLevelForRootLogger());
        LoggerTraverse.iteratePackages("", 1, info);
    }

    static void iteratePackages(String startPackageName, int level, LoggerTraverse info) {
        List packageInfo = info.getLoggerPackageNames(startPackageName);
        Iterator iter = packageInfo.iterator();
        while (iter.hasNext()) {
            String packageName = (String)iter.next();
            for (int x = 0; x < level; ++x) {
                System.out.print(" ");
            }
            System.out.print(packageName);
            String subpackageName = startPackageName.length() > 0 ? startPackageName + "." + packageName : packageName;
            System.out.print(" - " + info.getLevelForPackage(subpackageName));
            System.out.println(info.getLevelIsSetForPackage(subpackageName) ? "" : "*");
            if (!info.loggerHasSubPackages(subpackageName)) continue;
            LoggerTraverse.iteratePackages(subpackageName, level + 1, info);
        }
    }
}

