/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.layout;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.layout.EventDetailLayout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class LayoutEditorPane
extends JPanel {
    private final Action copyAction;
    private final Action cutAction;
    private final JToolBar editorToolbar = new JToolBar();
    private final JToolBar okCancelToolbar = new JToolBar();
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private final JEditorPane patternEditor = new JEditorPane("text/plain", "");
    private final JEditorPane previewer = new JEditorPane("text/html", "");
    private final JScrollPane patternEditorScroll = new JScrollPane(22, 32);
    private final JScrollPane previewEditorScroll = new JScrollPane(22, 32);
    private LoggingEvent event;
    private EventDetailLayout layout = new EventDetailLayout();

    public LayoutEditorPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.createEvent();
        this.copyAction = this.createCopyAction();
        this.cutAction = this.createCutAction();
        this.initComponents();
        this.setupListeners();
    }

    private Action createCutAction() {
        AbstractAction abstractAction = new AbstractAction("Cut", ChainsawIcons.ICON_CUT){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action createCopyAction() {
        AbstractAction abstractAction = new AbstractAction("Copy", ChainsawIcons.ICON_COPY){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private void setupListeners() {
        this.patternEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                LayoutEditorPane.this.updatePreview();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                LayoutEditorPane.this.updatePreview();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                LayoutEditorPane.this.updatePreview();
            }
        });
        this.patternEditor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                LayoutEditorPane.this.updateTextActions(caretEvent.getMark() != caretEvent.getDot());
            }
        });
    }

    private void updatePreview() {
        String string = this.patternEditor.getText();
        this.layout.setConversionPattern(string);
        this.previewer.setText(this.layout.format(this.event));
    }

    private void updateTextActions(boolean bl) {
        this.cutAction.setEnabled(bl);
        this.copyAction.setEnabled(bl);
    }

    private void createEvent() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("key1", "val1");
        hashtable.put("key2", "val2");
        hashtable.put("key3", "val3");
        LocationInfo locationInfo = new LocationInfo("myfile.java", "com.mycompany.util.MyClass", "myMethod", "321");
        ThrowableInformation throwableInformation = new ThrowableInformation(new Exception());
        this.event = new LoggingEvent();
        this.event.setLogger(Logger.getLogger("com.mycompany.mylogger"));
        this.event.setTimeStamp(new Date().getTime());
        this.event.setLevel(Level.DEBUG);
        this.event.setThreadName("Thread-1");
        this.event.setMessage("The quick brown fox jumped over the lazy dog");
        this.event.setNDC("NDC string");
        this.event.setThrowableInformation(throwableInformation);
        this.event.setLocationInformation(locationInfo);
        this.event.setProperties(hashtable);
    }

    private void initComponents() {
        this.editorToolbar.setFloatable(false);
        this.okCancelToolbar.setFloatable(false);
        this.okButton.setToolTipText("Accepts the current Pattern layout and will apply it to the Log Panel");
        this.cancelButton.setToolTipText("Closes this dialog and discards your changes");
        this.previewer.setEditable(false);
        this.patternEditor.setPreferredSize(new Dimension(240, 240));
        this.patternEditor.setMaximumSize(new Dimension(320, 240));
        this.previewer.setPreferredSize(new Dimension(360, 240));
        this.patternEditorScroll.setViewportView(this.patternEditor);
        this.previewEditorScroll.setViewportView(this.previewer);
        this.patternEditor.setToolTipText("Edit the Pattern here");
        this.previewer.setToolTipText("The result of the layout of the pattern is shown here");
        this.patternEditorScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Pattern Editor"));
        this.previewEditorScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Pattern Preview"));
        this.editorToolbar.add(Box.createHorizontalGlue());
        this.okCancelToolbar.add(Box.createHorizontalGlue());
        this.okCancelToolbar.add(this.okButton);
        this.okCancelToolbar.addSeparator();
        this.okCancelToolbar.add(this.cancelButton);
        this.add(this.editorToolbar);
        this.add(this.patternEditorScroll);
        this.add(this.previewEditorScroll);
        this.add(this.okCancelToolbar);
    }

    public void setConversionPattern(String string) {
        this.patternEditor.setText(string);
    }

    public String getConversionPattern() {
        return this.patternEditor.getText();
    }

    public void addOkActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog((Frame)null, "Pattern Editor");
        jDialog.getContentPane().add(new LayoutEditorPane());
        jDialog.setResizable(true);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setSize(new Dimension(640, 480));
        jDialog.setVisible(true);
    }
}

