/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;

public class WelcomePanel
extends JPanel {
    private Stack urlStack = new Stack();
    private final JEditorPane textInfo = new JEditorPane();
    private final URLToolbar urlToolbar = new URLToolbar();

    public WelcomePanel() {
        super(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.urlToolbar, "North");
        URL uRL = ChainsawConstants.WELCOME_URL;
        if (uRL != null) {
            this.textInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.textInfo.setEditable(false);
            this.textInfo.setPreferredSize(new Dimension(320, 240));
            JScrollPane jScrollPane = new JScrollPane(this.textInfo);
            jScrollPane.setBorder(null);
            this.add((Component)jScrollPane, "Center");
            try {
                this.textInfo.setPage(uRL);
                this.textInfo.addHyperlinkListener(new HyperlinkListener(){

                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            WelcomePanel.this.urlStack.add(WelcomePanel.this.textInfo.getPage());
                            try {
                                WelcomePanel.this.textInfo.setPage(hyperlinkEvent.getURL());
                                WelcomePanel.this.urlToolbar.updateToolbar();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void setURL(final URL uRL) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    WelcomePanel.this.urlStack.push(WelcomePanel.this.textInfo.getPage());
                    WelcomePanel.this.textInfo.setPage(uRL);
                    WelcomePanel.this.urlToolbar.updateToolbar();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public JToolBar getToolbar() {
        return this.urlToolbar;
    }

    private class URLToolbar
    extends JToolBar {
        private final Action previousAction = new AbstractAction(this, null, new ImageIcon(ChainsawIcons.ICON_BACK)){
            private final /* synthetic */ URLToolbar this$1;
            {
                this.this$1 = uRLToolbar;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (WelcomePanel.access$200(URLToolbar.access$400(this.this$1)).isEmpty()) {
                    return;
                }
                URLToolbar.access$400(this.this$1).setURL((URL)WelcomePanel.access$200(URLToolbar.access$400(this.this$1)).pop());
            }
        };
        private final Action homeAction = new AbstractAction(this, null, new ImageIcon(ChainsawIcons.ICON_HOME)){
            private final /* synthetic */ URLToolbar this$1;
            {
                this.this$1 = uRLToolbar;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                URLToolbar.access$400(this.this$1).setURL(ChainsawConstants.WELCOME_URL);
                WelcomePanel.access$200(URLToolbar.access$400(this.this$1)).clear();
            }
        };

        private URLToolbar() {
            this.setFloatable(false);
            this.updateToolbar();
            this.previousAction.putValue("ShortDescription", "Back");
            this.homeAction.putValue("ShortDescription", "Home");
            SmallButton smallButton = new SmallButton(this.homeAction);
            this.add(smallButton);
            this.addSeparator();
            SmallButton smallButton2 = new SmallButton(this.previousAction);
            smallButton2.setEnabled(false);
            this.add(smallButton2);
            this.addSeparator();
        }

        void updateToolbar() {
            this.previousAction.setEnabled(!WelcomePanel.this.urlStack.isEmpty());
        }

        static /* synthetic */ WelcomePanel access$400(URLToolbar uRLToolbar) {
            return uRLToolbar.WelcomePanel.this;
        }
    }
}

