/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.chainsaw.AbstractPreferencePanel;
import org.apache.log4j.chainsaw.BasicPrefPanel;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.CheckListCellRenderer;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.ModifiableListModel;
import org.apache.log4j.helpers.LogLog;

public class LogPanelPreferencePanel
extends AbstractPreferencePanel {
    private final LogPanelPreferenceModel committedPreferenceModel;
    private JTextField loggerPrecision = new JTextField(5);
    private final LogPanelPreferenceModel uncommittedPreferenceModel = new LogPanelPreferenceModel();

    public LogPanelPreferencePanel(LogPanelPreferenceModel logPanelPreferenceModel) {
        this.committedPreferenceModel = logPanelPreferenceModel;
        this.initComponents();
        this.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanelPreferencePanel.this.uncommittedPreferenceModel.setLoggerPrecision(LogPanelPreferencePanel.this.loggerPrecision.getText());
                LogPanelPreferencePanel.this.committedPreferenceModel.apply(LogPanelPreferencePanel.this.uncommittedPreferenceModel);
                LogPanelPreferencePanel.this.hidePanel();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanelPreferencePanel.this.hidePanel();
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Preferences Panel Test Bed");
        LogPanelPreferenceModel logPanelPreferenceModel = new LogPanelPreferenceModel();
        LogPanelPreferencePanel logPanelPreferencePanel = new LogPanelPreferencePanel(logPanelPreferenceModel);
        jFrame.getContentPane().add(logPanelPreferencePanel);
        logPanelPreferenceModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogLog.warn(propertyChangeEvent.toString());
            }
        });
        logPanelPreferencePanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        });
        jFrame.setSize(640, 480);
        jFrame.show();
    }

    public void updateModel() {
        this.uncommittedPreferenceModel.apply(this.committedPreferenceModel);
    }

    protected TreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new VisualsPrefPanel());
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new FormattingPanel());
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new ColumnSelectorPanel());
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        return defaultTreeModel;
    }

    private LogPanelPreferenceModel getModel() {
        return this.uncommittedPreferenceModel;
    }

    private class VisualsPrefPanel
    extends BasicPrefPanel {
        private final JCheckBox detailPanelVisible = new JCheckBox("Show Event Detail panel");
        private final JCheckBox loggerTreePanel = new JCheckBox("Show Logger Tree panel");
        private final JCheckBox scrollToBottom = new JCheckBox("Scroll to bottom (view tracks with new events)");
        private final JCheckBox toolTips = new JCheckBox("Show Event Detail Tooltips");

        private VisualsPrefPanel() {
            super("Visuals");
            this.initPanelComponents();
            this.setupListeners();
        }

        private void initPanelComponents() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.toolTips);
            this.add(this.detailPanelVisible);
            this.add(this.loggerTreePanel);
            this.add(this.scrollToBottom);
            this.toolTips.setSelected(LogPanelPreferencePanel.this.getModel().isToolTips());
            this.detailPanelVisible.setSelected(LogPanelPreferencePanel.this.getModel().isDetailPaneVisible());
            this.loggerTreePanel.setSelected(LogPanelPreferencePanel.this.getModel().isLogTreePanelVisible());
        }

        private void setupListeners() {
            this.toolTips.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(VisualsPrefPanel.access$1400(this.this$1)).setToolTips(VisualsPrefPanel.access$1300(this.this$1).isSelected());
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("toolTips", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VisualsPrefPanel.access$1300(this.this$1).setSelected(bl);
                }
            });
            this.detailPanelVisible.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(VisualsPrefPanel.access$1400(this.this$1)).setDetailPaneVisible(VisualsPrefPanel.access$1500(this.this$1).isSelected());
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VisualsPrefPanel.access$1500(this.this$1).setSelected(bl);
                }
            });
            this.scrollToBottom.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(VisualsPrefPanel.access$1400(this.this$1)).setScrollToBottom(VisualsPrefPanel.access$1600(this.this$1).isSelected());
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VisualsPrefPanel.access$1600(this.this$1).setSelected(bl);
                }
            });
            this.loggerTreePanel.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(VisualsPrefPanel.access$1400(this.this$1)).setLogTreePanelVisible(VisualsPrefPanel.access$1700(this.this$1).isSelected());
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(this){
                private final /* synthetic */ VisualsPrefPanel this$1;
                {
                    this.this$1 = visualsPrefPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VisualsPrefPanel.access$1700(this.this$1).setSelected(bl);
                }
            });
        }

        static /* synthetic */ JCheckBox access$1300(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.toolTips;
        }

        static /* synthetic */ LogPanelPreferencePanel access$1400(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.LogPanelPreferencePanel.this;
        }

        static /* synthetic */ JCheckBox access$1500(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.detailPanelVisible;
        }

        static /* synthetic */ JCheckBox access$1600(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.scrollToBottom;
        }

        static /* synthetic */ JCheckBox access$1700(VisualsPrefPanel visualsPrefPanel) {
            return visualsPrefPanel.loggerTreePanel;
        }
    }

    private class FormattingPanel
    extends BasicPrefPanel {
        private JTextField customFormatText = new JTextField("", 10);
        private JRadioButton rdCustom = new JRadioButton("Custom Format");
        private final JRadioButton rdISO = new JRadioButton("<html><b>Fast</b> ISO 8601 format (yyyy-MM-dd HH:mm:ss)</html>");
        private final JRadioButton rdLevelIcons = new JRadioButton("Icons");
        private final JRadioButton rdLevelText = new JRadioButton("Text");

        private FormattingPanel() {
            super("Formatting");
            this.initComponents();
            this.setupListeners();
        }

        private void initComponents() {
            Serializable serializable;
            Object object;
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Timestamp"));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            this.customFormatText.setPreferredSize(new Dimension(100, 20));
            this.customFormatText.setMaximumSize(this.customFormatText.getPreferredSize());
            this.customFormatText.setMinimumSize(this.customFormatText.getPreferredSize());
            this.customFormatText.setEnabled(false);
            this.rdCustom.setSelected(LogPanelPreferencePanel.this.getModel().isCustomDateFormat());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rdISO.setAlignmentX(0.0f);
            this.rdISO.setSelected(LogPanelPreferencePanel.this.getModel().isUseISO8601Format());
            buttonGroup.add(this.rdISO);
            jPanel.add(this.rdISO);
            Object object2 = LogPanelPreferenceModel.DATE_FORMATS.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                serializable = new JRadioButton((String)object);
                ((JComponent)serializable).setAlignmentX(0.0f);
                buttonGroup.add((AbstractButton)serializable);
                ((AbstractButton)serializable).addActionListener(new ActionListener(this, (String)object){
                    private final /* synthetic */ String val$format;
                    private final /* synthetic */ FormattingPanel this$1;
                    {
                        this.this$1 = formattingPanel;
                        this.val$format = string;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).setDateFormatPattern(this.val$format);
                        FormattingPanel.access$900(this.this$1).setEnabled(FormattingPanel.access$800(this.this$1).isSelected());
                    }
                });
                LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(this, (JRadioButton)serializable, (String)object){
                    private final /* synthetic */ JRadioButton val$rdFormat;
                    private final /* synthetic */ String val$format;
                    private final /* synthetic */ FormattingPanel this$1;
                    {
                        this.this$1 = formattingPanel;
                        this.val$rdFormat = jRadioButton;
                        this.val$format = string;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$rdFormat.setSelected(LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).getDateFormatPattern().equals(this.val$format));
                    }
                });
                jPanel.add((Component)serializable);
            }
            if (LogPanelPreferencePanel.this.getModel().isCustomDateFormat()) {
                this.customFormatText.setText(LogPanelPreferencePanel.this.getModel().getDateFormatPattern());
                this.customFormatText.setEnabled(true);
            }
            this.rdCustom.setAlignmentX(0.0f);
            buttonGroup.add(this.rdCustom);
            object2 = Box.createHorizontalBox();
            ((Container)object2).add(this.rdCustom);
            ((Container)object2).add(this.customFormatText);
            ((Container)object2).add(Box.createHorizontalGlue());
            jPanel.add((Component)object2);
            this.add(jPanel);
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Level"));
            ((JComponent)object).setAlignmentX(0.0f);
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this.rdLevelIcons);
            ((ButtonGroup)serializable).add(this.rdLevelText);
            this.rdLevelIcons.setSelected(LogPanelPreferencePanel.this.getModel().isLevelIcons());
            ((Container)object).add(this.rdLevelIcons);
            ((Container)object).add(this.rdLevelText);
            this.add((Component)object);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logger"));
            jPanel2.setAlignmentX(0.0f);
            JLabel jLabel = new JLabel("Number of package levels to hide)");
            JLabel jLabel2 = new JLabel("leave blank to display full logger");
            jPanel2.add(jLabel);
            jPanel2.add(jLabel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(LogPanelPreferencePanel.this.loggerPrecision);
            jPanel2.add(jPanel3);
            this.add(jPanel2);
            this.add(Box.createVerticalGlue());
        }

        private void setupListeners() {
            this.rdCustom.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FormattingPanel.access$900(this.this$1).setEnabled(FormattingPanel.access$800(this.this$1).isSelected());
                    FormattingPanel.access$900(this.this$1).setText("");
                    FormattingPanel.access$900(this.this$1).grabFocus();
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).isCustomDateFormat() && !FormattingPanel.access$900(this.this$1).getText().equals(propertyChangeEvent.getNewValue().toString())) {
                        FormattingPanel.access$900(this.this$1).setText(LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).getDateFormatPattern());
                        FormattingPanel.access$800(this.this$1).setSelected(true);
                        FormattingPanel.access$900(this.this$1).setEnabled(true);
                    } else {
                        FormattingPanel.access$800(this.this$1).setSelected(false);
                    }
                }
            });
            this.rdISO.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).setDateFormatPattern("ISO8601");
                    FormattingPanel.access$900(this.this$1).setEnabled(FormattingPanel.access$800(this.this$1).isSelected());
                }
            });
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("dateFormatPattern", new PropertyChangeListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FormattingPanel.access$1000(this.this$1).setSelected(LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).isUseISO8601Format());
                }
            });
            this.customFormatText.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void textChanged() {
                    LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).setDateFormatPattern(FormattingPanel.access$900(this.this$1).getText());
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }
            });
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanelPreferencePanel.access$600(FormattingPanel.access$700(this.this$1)).setLevelIcons(FormattingPanel.access$1100(this.this$1).isSelected());
                }
            };
            this.rdLevelIcons.addActionListener(actionListener);
            this.rdLevelText.addActionListener(actionListener);
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("levelIcons", new PropertyChangeListener(this){
                private final /* synthetic */ FormattingPanel this$1;
                {
                    this.this$1 = formattingPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    FormattingPanel.access$1100(this.this$1).setSelected(bl);
                    FormattingPanel.access$1200(this.this$1).setSelected(!bl);
                }
            });
        }

        static /* synthetic */ LogPanelPreferencePanel access$700(FormattingPanel formattingPanel) {
            return formattingPanel.LogPanelPreferencePanel.this;
        }

        static /* synthetic */ JRadioButton access$800(FormattingPanel formattingPanel) {
            return formattingPanel.rdCustom;
        }

        static /* synthetic */ JTextField access$900(FormattingPanel formattingPanel) {
            return formattingPanel.customFormatText;
        }

        static /* synthetic */ JRadioButton access$1000(FormattingPanel formattingPanel) {
            return formattingPanel.rdISO;
        }

        static /* synthetic */ JRadioButton access$1100(FormattingPanel formattingPanel) {
            return formattingPanel.rdLevelIcons;
        }

        static /* synthetic */ JRadioButton access$1200(FormattingPanel formattingPanel) {
            return formattingPanel.rdLevelText;
        }
    }

    public class ColumnSelectorPanel
    extends BasicPrefPanel {
        ColumnSelectorPanel() {
            super("Columns");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            Box box = new Box(1);
            JList jList = new JList();
            jList.setVisibleRowCount(10);
            ModifiableListModel modifiableListModel = new ModifiableListModel();
            Object object = ChainsawColumns.getColumnsNames().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                modifiableListModel.addElement(string);
            }
            jList.setModel(modifiableListModel);
            object = new CheckListCellRenderer(this){
                private final /* synthetic */ ColumnSelectorPanel this$1;
                {
                    this.this$1 = columnSelectorPanel;
                }

                protected boolean isSelected(Object object) {
                    return LogPanelPreferencePanel.access$600(ColumnSelectorPanel.access$500(this.this$1)).isColumnVisible(object.toString());
                }
            };
            LogPanelPreferencePanel.this.getModel().addPropertyChangeListener("visibleColumns", new PropertyChangeListener(this, modifiableListModel){
                private final /* synthetic */ ModifiableListModel val$listModel;
                private final /* synthetic */ ColumnSelectorPanel this$1;
                {
                    this.this$1 = columnSelectorPanel;
                    this.val$listModel = modifiableListModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$listModel.fireContentsChanged();
                }
            });
            jList.addMouseListener(new MouseAdapter(this, jList, modifiableListModel){
                private final /* synthetic */ JList val$columnList;
                private final /* synthetic */ ModifiableListModel val$listModel;
                private final /* synthetic */ ColumnSelectorPanel this$1;
                {
                    this.this$1 = columnSelectorPanel;
                    this.val$columnList = jList;
                    this.val$listModel = modifiableListModel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 0x10) > 0 && (n = this.val$columnList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                        E e = this.val$listModel.get(n);
                        LogPanelPreferencePanel.access$600(ColumnSelectorPanel.access$500(this.this$1)).toggleColumn(e.toString());
                    }
                }
            });
            jList.setCellRenderer(object);
            box.add(new JScrollPane(jList));
            this.add(box);
            this.add(Box.createVerticalGlue());
        }

        static /* synthetic */ LogPanelPreferencePanel access$500(ColumnSelectorPanel columnSelectorPanel) {
            return columnSelectorPanel.LogPanelPreferencePanel.this;
        }
    }
}

