/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import org.apache.log4j.Layout;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.ChainsawCyclicBufferTableModel;
import org.apache.log4j.chainsaw.ChainsawEventBatchEntry;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.JSortTable;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.LogPanelPreferencePanel;
import org.apache.log4j.chainsaw.LoggerNameTreePanel;
import org.apache.log4j.chainsaw.NewKeyEvent;
import org.apache.log4j.chainsaw.NewKeyListener;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.RuleMediator;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.TableColorizingRenderer;
import org.apache.log4j.chainsaw.ThrowableRenderPanel;
import org.apache.log4j.chainsaw.color.ColorPanel;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.layout.DefaultLayoutFactory;
import org.apache.log4j.chainsaw.layout.EventDetailLayout;
import org.apache.log4j.chainsaw.layout.LayoutEditorPane;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.Profileable;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.ExpressionRuleContext;
import org.apache.log4j.rule.PartialTextMatchRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LogPanel
extends DockablePanel
implements EventBatchListener,
Profileable {
    private static final double DEFAULT_DETAIL_SPLIT_LOCATION = 0.5;
    private static final double DEFAULT_LOG_TREE_SPLIT_LOCATION = 0.25;
    private final String identifier;
    private final ChainsawStatusBar statusBar;
    private final JFrame preferencesFrame = new JFrame();
    private final JFrame colorFrame = new JFrame();
    private final JFrame undockedFrame;
    private final DockablePanel externalPanel;
    private final Action dockingAction;
    private final JToolBar undockedToolbar;
    private final JSortTable table;
    private final TableColorizingRenderer renderer;
    private final EventContainer tableModel;
    private final ThrowableRenderPanel throwableRenderPanel;
    private final JEditorPane detail;
    private final JSplitPane lowerPanel;
    private final DetailPaneUpdater detailPaneUpdater;
    private final JPanel detailPanel = new JPanel(new BorderLayout());
    private final JSplitPane nameTreeAndMainPanelSplit;
    private final LoggerNameTreePanel logTreePanel;
    private final LogPanelPreferenceModel preferenceModel = new LogPanelPreferenceModel();
    private final LogPanelPreferencePanel preferencesPanel = new LogPanelPreferencePanel(this.preferenceModel);
    private final FilterModel filterModel = new FilterModel();
    private final RuleColorizer colorizer = new RuleColorizer();
    private final RuleMediator ruleMediator = new RuleMediator();
    private Layout detailLayout = new EventDetailLayout();
    private double lastDetailPanelSplitLocation = 0.5;
    private double lastLogTreePanelSplitLocation = 0.25;
    private boolean bypassScrollFind;
    private Point currentPoint;
    private boolean scroll;
    private boolean paused = false;
    private Rule findRule;
    private final JPanel findPanel;
    private JTextField findField;
    private int dividerSize;
    static final String TABLE_COLUMN_ORDER = "table.columns.order";
    static final String TABLE_COLUMN_WIDTHS = "table.columns.widths";
    static final String COLUMNS_EXTENSION = ".columns";
    static final String COLORS_EXTENSION = ".colors";
    private int previousLastIndex = -1;
    private final DateFormat timestampExpressionFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static /* synthetic */ Class class$java$lang$Object;

    public LogPanel(final ChainsawStatusBar chainsawStatusBar, String string, int n) {
        this.identifier = string;
        this.statusBar = chainsawStatusBar;
        this.setLayout(new BorderLayout());
        this.scroll = true;
        this.findPanel = new JPanel();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Class", "CLASS");
        hashMap.put("File", "FILE");
        hashMap.put("Level", "LEVEL");
        hashMap.put("Line", "LINE");
        hashMap.put("Logger", "LOGGER");
        hashMap.put("NDC", "NDC");
        hashMap.put("Message", "MSG");
        hashMap.put("Thread", "THREAD");
        hashMap.put("Throwable", "EXCEPTION");
        hashMap.put("Timestamp", "TIMESTAMP");
        this.preferencesFrame.setTitle("'" + string + "' Log Panel Preferences");
        this.preferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.preferencesFrame.getContentPane().add(this.preferencesPanel);
        this.preferencesFrame.setSize(640, 480);
        this.preferencesPanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferencesFrame.setVisible(false);
            }
        });
        this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        ((EventDetailLayout)this.detailLayout).setConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        this.undockedFrame = new JFrame(string);
        this.undockedFrame.setDefaultCloseOperation(0);
        if (ChainsawIcons.UNDOCKED_ICON != null) {
            this.undockedFrame.setIconImage(new ImageIcon(ChainsawIcons.UNDOCKED_ICON).getImage());
        }
        this.externalPanel = new DockablePanel();
        this.externalPanel.setLayout(new BorderLayout());
        this.undockedFrame.getContentPane().add(this.externalPanel);
        this.undockedFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LogPanel.this.dock();
            }
        });
        this.undockedToolbar = this.createDockwindowToolbar();
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.undockedFrame.pack();
        final JPopupMenu jPopupMenu = new JPopupMenu();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction("Use ISO8601Format"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setDateFormatPattern("ISO8601");
            }
        });
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction("Use simple time"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setDateFormatPattern("HH:mm:ss");
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem.setSelected(true);
        jPopupMenu.add(jRadioButtonMenuItem);
        jPopupMenu.add(jRadioButtonMenuItem2);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show ToolTips");
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setToolTips(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem.setIcon(new ImageIcon(ChainsawIcons.TOOL_TIP));
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Show Logger Tree panel");
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setLogTreePanelVisible(jCheckBoxMenuItem2.isSelected());
            }
        });
        jCheckBoxMenuItem2.setIcon(new ImageIcon(ChainsawIcons.WINDOW_ICON));
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Scroll to bottom");
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setScrollToBottom(jCheckBoxMenuItem3.isSelected());
            }
        });
        jCheckBoxMenuItem3.setIcon(new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Show Detail Pane");
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setDetailPaneVisible(jCheckBoxMenuItem4.isSelected());
            }
        });
        jCheckBoxMenuItem4.setIcon(new ImageIcon(ChainsawIcons.INFO));
        this.preferenceModel.addPropertyChangeListener("levelIcons", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogPanel.this.renderer.setLevelUseIcons((Boolean)propertyChangeEvent.getNewValue());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    LogPanel.this.showDetailPane();
                } else {
                    LogPanel.this.hideDetailPane();
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    LogPanel.this.showLogTreePanel();
                } else {
                    LogPanel.this.hideLogTreePanel();
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogPanel.this.renderer.setToolTipsVisible((Boolean)propertyChangeEvent.getNewValue());
            }
        });
        this.preferenceModel.addPropertyChangeListener("visibleColumns", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                Object object2;
                TableColumnModel tableColumnModel = LogPanel.this.table.getColumnModel();
                for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                    object2 = tableColumnModel.getColumn(i);
                    if (LogPanel.this.preferenceModel.isColumnVisible(((TableColumn)object2).getHeaderValue().toString())) continue;
                    tableColumnModel.removeColumn((TableColumn)object2);
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                object2 = tableColumnModel.getColumns();
                while (object2.hasMoreElements()) {
                    object = (TableColumn)object2.nextElement();
                    hashSet.add(((TableColumn)object).getHeaderValue());
                }
                object = ChainsawColumns.getColumnsNames().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (!LogPanel.this.preferenceModel.isColumnVisible(string) || hashSet.contains(string)) continue;
                    TableColumn tableColumn = new TableColumn(ChainsawColumns.getColumnsNames().indexOf(string));
                    tableColumn.setHeaderValue(string);
                    tableColumnModel.addColumn(tableColumn);
                }
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogPanelPreferenceModel logPanelPreferenceModel = (LogPanelPreferenceModel)propertyChangeEvent.getSource();
                jRadioButtonMenuItem.setSelected(logPanelPreferenceModel.isUseISO8601Format());
                jRadioButtonMenuItem2.setSelected(!logPanelPreferenceModel.isUseISO8601Format() && !logPanelPreferenceModel.isCustomDateFormat());
                if (logPanelPreferenceModel.isUseISO8601Format()) {
                    LogPanel.this.renderer.setDateFormatter(new ISO8601DateFormat());
                } else {
                    LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat(logPanelPreferenceModel.getDateFormatPattern()));
                }
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        };
        this.preferenceModel.addPropertyChangeListener("dateFormatPattern", propertyChangeListener);
        this.preferenceModel.addPropertyChangeListener("dateFormatPattern", propertyChangeListener);
        this.preferenceModel.addPropertyChangeListener("loggerPrecision", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogPanelPreferenceModel logPanelPreferenceModel = (LogPanelPreferenceModel)propertyChangeEvent.getSource();
                LogPanel.this.renderer.setLoggerPrecision(logPanelPreferenceModel.getLoggerPrecision());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jCheckBoxMenuItem.setSelected(bl);
            }
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jCheckBoxMenuItem2.setSelected(bl);
            }
        });
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jCheckBoxMenuItem3.setSelected(bl);
                LogPanel.this.scroll = bl;
                if (LogPanel.this.scroll) {
                    LogPanel.this.table.scrollToBottom(LogPanel.this.table.columnAtPoint(LogPanel.this.table.getVisibleRect().getLocation()));
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jCheckBoxMenuItem4.setSelected(bl);
            }
        });
        this.tableModel = new ChainsawCyclicBufferTableModel(n);
        this.table = new JSortTable(this.tableModel);
        this.tableModel.addNewKeyListener(new NewKeyListener(){

            public void newKeyAdded(NewKeyEvent newKeyEvent) {
                hashMap.put(newKeyEvent.getKey(), "PROP." + newKeyEvent.getKey());
            }
        });
        this.tableModel.setDisplayRule(this.ruleMediator);
        this.tableModel.addEventCountListener(new EventCountListener(){

            public void eventCountChanged(int n, int n2) {
                if (LogPanel.this.isVisible()) {
                    chainsawStatusBar.setSelectedLine(LogPanel.this.table.getSelectedRow() + 1, n, n2);
                }
            }
        });
        this.tableModel.addEventCountListener(new EventCountListener(){
            final NumberFormat formatter = NumberFormat.getPercentInstance();
            boolean warning75 = false;
            boolean warning100 = false;

            public void eventCountChanged(int n, int n2) {
                if (LogPanel.this.tableModel.isCyclic()) {
                    double d = (double)n2 / (double)((ChainsawCyclicBufferTableModel)LogPanel.this.tableModel).getMaxSize();
                    String string = null;
                    if (d > 0.75 && d < 1.0 && !this.warning75) {
                        string = "Warning :: " + this.formatter.format(d) + " of the '" + LogPanel.this.getIdentifier() + "' buffer has been used";
                        this.warning75 = true;
                    } else if (d >= 1.0 && !this.warning100) {
                        string = "Warning :: " + this.formatter.format(d) + " of the '" + LogPanel.this.getIdentifier() + "' buffer has been used.  Older events are being discarded.";
                        this.warning100 = true;
                    }
                    if (string != null) {
                        MessageCenter.getInstance().getLogger().info(string);
                    }
                }
            }
        });
        LogPanelLoggerTreeModel logPanelLoggerTreeModel = new LogPanelLoggerTreeModel();
        this.logTreePanel = new LoggerNameTreePanel(logPanelLoggerTreeModel, this.preferenceModel);
        this.tableModel.addLoggerNameListener(logPanelLoggerTreeModel);
        this.ruleMediator.setLoggerRule(this.logTreePanel);
        this.colorizer.setLoggerRule(this.logTreePanel.getLoggerColorRule());
        this.colorFrame.setTitle("'" + string + "' Color Filter");
        this.colorFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        ColorPanel colorPanel = new ColorPanel(this.colorizer, this.filterModel);
        this.colorFrame.getContentPane().add(colorPanel);
        colorPanel.setCloseActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.colorFrame.setVisible(false);
            }
        });
        this.colorizer.addPropertyChangeListener("colorrule", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
            }
        });
        this.table.setRowHeight(20);
        this.table.setShowGrid(false);
        this.table.getColumnModel().addColumnModelListener(new ChainsawTableColumnModelListener());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.addMouseMotionListener(new TableColumnDetailMouseListener());
        this.table.setAutoResizeMode(0);
        this.table.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent keyEvent) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(true);
                    LogPanel.this.detail.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent keyEvent) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(false);
                    LogPanel.this.detail.notify();
                }
            }
        });
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                if (listSelectionEvent.getFirstIndex() == listSelectionEvent.getLastIndex() && listSelectionEvent.getFirstIndex() > 0 || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl2 = listSelectionEvent.getLastIndex() == LogPanel.this.table.getRowCount() - 1;
                boolean bl3 = LogPanel.this.previousLastIndex == listSelectionEvent.getLastIndex();
                boolean bl4 = bl = bl2 && bl3 && LogPanel.this.previousLastIndex != listSelectionEvent.getFirstIndex();
                if (bl && LogPanel.this.scroll && LogPanel.this.table.getRowCount() > 0) {
                    LogPanel.this.preferenceModel.setScrollToBottom(false);
                }
                LogPanel.this.previousLastIndex = listSelectionEvent.getLastIndex();
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    if (LogPanel.this.isVisible()) {
                        chainsawStatusBar.setNothingSelected();
                    }
                    if (LogPanel.this.detail.getDocument().getDefaultRootElement() != null) {
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                } else if (LogPanel.this.table.getSelectedRow() > -1) {
                    int n = LogPanel.this.table.getSelectedRow();
                    if (LogPanel.this.isVisible()) {
                        LogPanel.this.updateStatusBar();
                    }
                    try {
                        if (LogPanel.this.tableModel.getRowCount() >= n) {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(LogPanel.this.table.getSelectedRow());
                        } else {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                }
            }
        });
        this.renderer = new TableColorizingRenderer(this.colorizer);
        this.renderer.setToolTipsVisible(this.preferenceModel.isToolTips());
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = LogPanel.class$("java.lang.Object")) : class$java$lang$Object, this.renderer);
        this.throwableRenderPanel = new ThrowableRenderPanel();
        final JDialog jDialog = new JDialog((Frame)null, true);
        Container container = jDialog.getContentPane();
        final JTextArea jTextArea = new JTextArea(10, 40);
        jTextArea.setEditable(false);
        container.setLayout(new BoxLayout(container, 1));
        container.add(new JScrollPane(jTextArea));
        jDialog.pack();
        this.throwableRenderPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = LogPanel.this.table.getValueAt(LogPanel.this.table.getSelectedRow(), LogPanel.this.table.getSelectedColumn());
                if (object == null) {
                    LogLog.debug("no row selected - unable to display throwable popup");
                    return;
                }
                jDialog.setTitle(LogPanel.this.table.getColumnName(LogPanel.this.table.getSelectedColumn()) + " detail...");
                if (object instanceof String[]) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = (String[])object;
                    stringBuffer.append(stringArray[0]).append("\n");
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]).append("\n    ");
                    }
                    jTextArea.setText(stringBuffer.toString());
                } else {
                    jTextArea.setText(object == null ? "" : object.toString());
                }
                jDialog.setLocation(LogPanel.this.lowerPanel.getLocationOnScreen());
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 27 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        27.access$2000(this.this$1).setVisible(true);
                    }
                });
            }

            static /* synthetic */ JDialog access$2000(27 var0) {
                return var0.jDialog;
            }
        });
        this.tableModel.addNewKeyListener(new NewKeyListener(){

            public void newKeyAdded(NewKeyEvent newKeyEvent) {
                TableColumn tableColumn = new TableColumn(newKeyEvent.getNewModelIndex());
                tableColumn.setHeaderValue(newKeyEvent.getKey());
                LogPanel.this.table.addColumn(tableColumn);
            }
        });
        this.tableModel.addPropertyChangeListener("cyclic", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (LogPanel.this.tableModel.isCyclic()) {
                    MessageCenter.getInstance().getLogger().warn("Changed to Cyclic Mode. Maximum # events kept: " + LogPanel.this.tableModel.getMaxSize());
                } else {
                    MessageCenter.getInstance().getLogger().warn("Changed to Unlimited Mode. Warning, you may run out of memory.");
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.checkEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkEvent(mouseEvent);
            }

            private void checkEvent(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel;
                int n2;
                if (mouseEvent.isPopupTrigger() && (n2 = (tableColumnModel = LogPanel.this.table.getColumnModel()).getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex()) + 1 == 2) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JLabel jLabel = new JLabel("Search messages for: ");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        jPanel.add(jLabel);
        JComboBox jComboBox = new JComboBox();
        final JTextField jTextField = new JTextField(20);
        jTextField.setToolTipText("Enter search text");
        jTextField.setEditable(true);
        jTextField.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.doSearch(jTextField.getText().trim());
            }
        });
        jPanel.add(jTextField);
        JButton jButton = new JButton("Search");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.doSearch(jTextField.getText());
            }
        });
        jPanel.add(jButton);
        this.detail = new JEditorPane("text/html", "");
        this.detail.setEditable(false);
        this.detailPaneUpdater = new DetailPaneUpdater();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                LogPanel.this.detailPaneUpdater.updateDetailPane();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                LogPanel.this.detailPaneUpdater.setSelectedRow(LogPanel.this.table.getSelectedRow());
            }
        });
        this.addPropertyChangeListener("detailPaneConversionPattern", this.detailPaneUpdater);
        JScrollPane jScrollPane = new JScrollPane(this.detail);
        jScrollPane.setPreferredSize(new Dimension(900, 50));
        this.detailPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel2.add((Component)jPanel3, "North");
        this.lowerPanel = new JSplitPane(0, jPanel2, this.detailPanel);
        this.dividerSize = this.lowerPanel.getDividerSize();
        this.lowerPanel.setDividerLocation(-1);
        this.lowerPanel.setResizeWeight(1.0);
        this.lowerPanel.setBorder(null);
        this.lowerPanel.setContinuousLayout(true);
        if (this.preferenceModel.isDetailPaneVisible()) {
            this.showDetailPane();
        } else {
            this.hideDetailPane();
        }
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        final LayoutEditorPane layoutEditorPane = new LayoutEditorPane();
        final JDialog jDialog2 = new JDialog((Frame)null, "Pattern Editor");
        jDialog2.getContentPane().add(layoutEditorPane);
        jDialog2.setSize(640, 480);
        layoutEditorPane.addCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.setVisible(false);
            }
        });
        layoutEditorPane.addOkActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setDetailPaneConversionPattern(layoutEditorPane.getConversionPattern());
                jDialog2.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction("Edit...", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER)){

            public void actionPerformed(ActionEvent actionEvent) {
                layoutEditorPane.setConversionPattern(LogPanel.this.getDetailPaneConversionPattern());
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = new Point((int)(dimension.getWidth() / 2.0 - jDialog2.getSize().getWidth() / 2.0), (int)(dimension.getHeight() / 2.0 - jDialog2.getSize().getHeight() / 2.0));
                jDialog2.setLocation(point);
                jDialog2.setVisible(true);
            }
        };
        abstractAction.putValue("ShortDescription", "opens a Dialog window to Edit the Pattern Layout text");
        SmallButton smallButton = new SmallButton(abstractAction);
        smallButton.setText(null);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(smallButton);
        jToolBar.addSeparator();
        jToolBar.add(Box.createHorizontalStrut(5));
        AbstractAction abstractAction2 = new AbstractAction(null, LineIconFactory.createCloseIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.preferenceModel.setDetailPaneVisible(false);
            }
        };
        abstractAction2.putValue("ShortDescription", "Hides the Detail Panel");
        SmallButton smallButton2 = new SmallButton(abstractAction2);
        jToolBar.add(smallButton2);
        this.detailPanel.add((Component)jToolBar, "North");
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        jPopupMenu2.add(abstractAction);
        jPopupMenu2.addSeparator();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new AbstractAction("Set to Default Layout"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
            }
        });
        jPopupMenu2.add(jRadioButtonMenuItem3);
        buttonGroup2.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem3.setSelected(true);
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(new AbstractAction("Set to TCCLayout"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setDetailPaneConversionPattern("%r [%t] %p %c %x - %m%n");
            }
        });
        jPopupMenu2.add(jRadioButtonMenuItem4);
        buttonGroup2.add(jRadioButtonMenuItem4);
        PopupListener popupListener = new PopupListener(jPopupMenu2);
        this.detail.addMouseListener(popupListener);
        this.nameTreeAndMainPanelSplit = new JSplitPane(1, this.logTreePanel, this.lowerPanel);
        this.nameTreeAndMainPanelSplit.setToolTipText("Still under development....");
        this.nameTreeAndMainPanelSplit.setDividerLocation(-1);
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        if (this.isLogTreeVisible()) {
            this.showLogTreePanel();
        } else {
            this.hideLogTreePanel();
        }
        JMenuItem jMenuItem = new JMenuItem("Best fit column");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LogPanel.this.currentPoint != null) {
                    int n = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int n2 = LogPanel.this.getMaxColumnWidth(n);
                    LogPanel.this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("LogPanel Color Filter...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.showColorPreferences();
            }
        });
        jMenuItem2.setIcon(ChainsawIcons.ICON_PREFERENCES);
        JMenuItem jMenuItem3 = new JMenuItem("LogPanel Preferences...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.showPreferences();
            }
        });
        jMenuItem3.setIcon(ChainsawIcons.ICON_PREFERENCES);
        JMenuItem jMenuItem4 = new JMenuItem("Set 'refine focus' field");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LogPanel.this.currentPoint != null) {
                    String string = "==";
                    int n = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int n2 = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String string2 = LogPanel.this.table.getColumnName(n);
                    String string3 = "";
                    if (string2.equalsIgnoreCase("Timestamp")) {
                        string3 = LogPanel.this.timestampExpressionFormat.format(new Date(LogPanel.this.table.getValueAt(n2, n).toString()));
                    } else {
                        Object object = LogPanel.this.table.getValueAt(n2, n);
                        if (object != null) {
                            if (object instanceof String[]) {
                                string3 = ((String[])object)[0];
                                string = "~=";
                            } else {
                                string3 = object.toString();
                            }
                        }
                    }
                    if (hashMap.containsKey(string2)) {
                        jTextField.setText(hashMap.get(string2).toString() + " " + string + " '" + string3 + "'");
                    }
                }
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("Add to 'refine focus' field");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LogPanel.this.currentPoint != null) {
                    String string = "==";
                    int n = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int n2 = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String string2 = LogPanel.this.table.getColumnName(n);
                    String string3 = "";
                    if (string2.equalsIgnoreCase("Timestamp")) {
                        JComponent jComponent = (JComponent)((Object)LogPanel.this.table.getCellRenderer(n2, n));
                        if (jComponent instanceof JLabel) {
                            string3 = ((JLabel)jComponent).getText();
                        }
                    } else {
                        String string4 = LogPanel.this.table.getValueAt(n2, n).toString();
                        if (string4 instanceof String[]) {
                            string3 = ((String[])string4)[0];
                            string = "~=";
                        } else {
                            string3 = string4.toString();
                        }
                    }
                    if (hashMap.containsKey(string2)) {
                        jTextField.setText(jTextField.getText() + " && " + hashMap.get(string2).toString() + " " + string + " '" + string3 + "'");
                    }
                }
            }
        });
        JPopupMenu jPopupMenu3 = new JPopupMenu();
        AbstractAction abstractAction3 = new AbstractAction("Clear 'refine focus' field"){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.setText(null);
                LogPanel.this.ruleMediator.setRefinementRule(null);
            }
        };
        JMenuItem jMenuItem6 = new JMenuItem("Undock/dock");
        this.dockingAction = new AbstractAction("Undock"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LogPanel.this.isDocked()) {
                    LogPanel.this.undock();
                } else {
                    LogPanel.this.dock();
                }
            }
        };
        this.dockingAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UNDOCK));
        jMenuItem6.setAction(this.dockingAction);
        jPopupMenu3.add(abstractAction3);
        jPopupMenu3.add(jMenuItem4);
        jPopupMenu3.add(jMenuItem5);
        jPopupMenu3.add(new JSeparator());
        jPopupMenu3.add(jMenuItem);
        jPopupMenu3.add(new JSeparator());
        jPopupMenu3.add(jCheckBoxMenuItem4);
        jPopupMenu3.add(jCheckBoxMenuItem2);
        jPopupMenu3.add(jCheckBoxMenuItem);
        jPopupMenu3.add(new JSeparator());
        jPopupMenu3.add(jCheckBoxMenuItem3);
        jPopupMenu3.add(new JSeparator());
        jPopupMenu3.add(jMenuItem6);
        jPopupMenu3.add(new JSeparator());
        jPopupMenu3.add(jMenuItem2);
        jPopupMenu3.add(jMenuItem3);
        PopupListener popupListener2 = new PopupListener(jPopupMenu3);
        jScrollPane2.addMouseListener(popupListener2);
        this.table.addMouseListener(popupListener2);
    }

    public boolean isScrollToBottom() {
        return this.preferenceModel.isScrollToBottom();
    }

    public void toggleScrollToBottom() {
        this.preferenceModel.setScrollToBottom(!this.preferenceModel.isScrollToBottom());
    }

    public String getNamespace() {
        return this.getIdentifier();
    }

    public String getInterestedIdentifier() {
        return this.getIdentifier();
    }

    public void receiveEventBatch(String string, List list) {
        if (this.isPaused()) {
            return;
        }
        boolean bl = false;
        int n = this.tableModel.getLastAdded() + 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChainsawEventBatchEntry chainsawEventBatchEntry = (ChainsawEventBatchEntry)iterator.next();
            this.updateOtherModels(chainsawEventBatchEntry);
            boolean bl2 = this.tableModel.isAddRow(chainsawEventBatchEntry.getEvent(), true);
            bl = bl ? true : bl2;
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
        this.tableModel.notifyCountListeners();
        if (bl) {
            if (this.tableModel.isSortEnabled()) {
                this.tableModel.sort();
            }
            this.tableModel.fireTableEvent(n, this.tableModel.getLastAdded(), list.size());
            if (this.scroll && !this.bypassScrollFind) {
                this.table.scrollToBottom(this.table.columnAtPoint(this.table.getVisibleRect().getLocation()));
            }
            this.detailPaneUpdater.setSelectedRow(this.table.getSelectedRow());
        }
    }

    public void loadSettings(LoadSettingsEvent loadSettingsEvent) {
        this.preferenceModel.setLevelIcons(loadSettingsEvent.asBoolean("levelIcons"));
        this.preferenceModel.setDateFormatPattern(loadSettingsEvent.getSetting("dateFormatPattern"));
        this.preferenceModel.setLoggerPrecision(loadSettingsEvent.getSetting("loggerPrecision"));
        this.preferenceModel.setToolTips(loadSettingsEvent.asBoolean("toolTips"));
        this.preferenceModel.setScrollToBottom(loadSettingsEvent.asBoolean("scrollToBottom"));
        this.scroll = loadSettingsEvent.asBoolean("scrollToBottom");
        this.preferenceModel.setLogTreePanelVisible(loadSettingsEvent.asBoolean("logTreePanelVisible"));
        this.preferenceModel.setDetailPaneVisible(loadSettingsEvent.asBoolean("detailPaneVisible"));
        this.logTreePanel.ignore(loadSettingsEvent.getSettingsStartingWith("Logger.Ignore."));
        File file = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier) + COLUMNS_EXTENSION);
        if (!file.exists()) {
            file = new File(SettingsManager.getInstance().getSettingsDirectory(), this.identifier + COLUMNS_EXTENSION);
        }
        if (file.exists()) {
            this.loadColumnSettings(file);
        } else {
            this.loadDefaultColumnSettings(loadSettingsEvent);
        }
        File file2 = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier) + COLORS_EXTENSION);
        if (!file2.exists()) {
            file2 = new File(SettingsManager.getInstance().getSettingsDirectory(), this.identifier + COLORS_EXTENSION);
        }
        if (file2.exists()) {
            this.loadColorSettings(file2);
        }
    }

    public void saveSettings(SaveSettingsEvent saveSettingsEvent) {
        saveSettingsEvent.saveSetting("levelIcons", this.preferenceModel.isLevelIcons());
        saveSettingsEvent.saveSetting("dateFormatPattern", this.preferenceModel.getDateFormatPattern());
        saveSettingsEvent.saveSetting("loggerPrecision", this.preferenceModel.getLoggerPrecision());
        saveSettingsEvent.saveSetting("toolTips", this.preferenceModel.isToolTips());
        saveSettingsEvent.saveSetting("scrollToBottom", this.preferenceModel.isScrollToBottom());
        saveSettingsEvent.saveSetting("detailPaneVisible", this.preferenceModel.isDetailPaneVisible());
        saveSettingsEvent.saveSetting("logTreePanelVisible", this.preferenceModel.isLogTreePanelVisible());
        Set set = this.logTreePanel.getHiddenSet();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            saveSettingsEvent.saveSetting("Logger.Ignore." + n++, e.toString());
        }
        this.saveColumnSettings();
        this.saveColorSettings();
    }

    void showPreferences() {
        this.preferencesPanel.updateModel();
        this.preferencesFrame.show();
    }

    void showColorPreferences() {
        this.colorFrame.pack();
        this.colorFrame.show();
    }

    void toggleDetailVisible() {
        this.preferenceModel.setDetailPaneVisible(!this.preferenceModel.isDetailPaneVisible());
    }

    boolean isDetailVisible() {
        return this.preferenceModel.isDetailPaneVisible();
    }

    void toggleLogTreeVisible() {
        this.preferenceModel.setLogTreePanelVisible(!this.preferenceModel.isLogTreePanelVisible());
    }

    boolean isLogTreeVisible() {
        return this.preferenceModel.isLogTreePanelVisible();
    }

    List getEvents() {
        return this.tableModel.getAllEvents();
    }

    List getFilteredEvents() {
        return this.tableModel.getFilteredEvents();
    }

    List getMatchingEvents(Rule rule) {
        return this.tableModel.getMatchingEvents(rule);
    }

    public void clearEvents() {
        this.clearModel();
    }

    String getIdentifier() {
        return this.identifier;
    }

    void undock() {
        int n = this.table.getSelectedRow();
        this.setDocked(false);
        this.externalPanel.removeAll();
        this.findPanel.removeAll();
        this.findPanel.add(this.findField);
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.externalPanel.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(false);
        this.undockedFrame.setSize(this.getSize());
        this.undockedFrame.setLocation(this.getBounds().x, this.getBounds().y);
        this.undockedFrame.setVisible(true);
        this.dockingAction.putValue("Name", "Dock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_DOCK);
        if (n > -1) {
            this.table.scrollToRow(n, this.table.columnAtPoint(this.table.getVisibleRect().getLocation()));
        }
    }

    void addEventCountListener(EventCountListener eventCountListener) {
        this.tableModel.addEventCountListener(eventCountListener);
    }

    boolean isPaused() {
        return this.paused;
    }

    void setPaused(boolean bl) {
        boolean bl2 = this.paused;
        this.paused = bl;
        this.firePropertyChange("paused", bl2, bl);
    }

    void addPreferencePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.preferenceModel.addPropertyChangeListener(propertyChangeListener);
    }

    void toggleCyclic() {
        this.tableModel.setCyclic(!this.tableModel.isCyclic());
    }

    boolean isCyclic() {
        return this.tableModel.isCyclic();
    }

    public boolean updateRule(String string) {
        if (string == null || string != null && string.equals("")) {
            this.findRule = null;
            this.colorizer.setFindRule(null);
            this.bypassScrollFind = false;
            this.findField.setToolTipText("Enter expression - right click or ctrl-space for menu");
            return false;
        }
        this.bypassScrollFind = true;
        try {
            this.findField.setToolTipText("Enter expression - right click or ctrl-space for menu");
            this.findRule = ExpressionRule.getRule(string);
            this.colorizer.setFindRule(this.findRule);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.findField.setToolTipText(illegalArgumentException.getMessage());
            this.colorizer.setFindRule(null);
            return false;
        }
    }

    private void showDetailPane() {
        this.lowerPanel.setDividerSize(this.dividerSize);
        this.lowerPanel.setDividerLocation(this.lastDetailPanelSplitLocation);
        this.detailPanel.setVisible(true);
        this.lowerPanel.repaint();
    }

    private void hideDetailPane() {
        int n = this.lowerPanel.getHeight() - this.lowerPanel.getDividerSize();
        if (n > 0) {
            this.lastDetailPanelSplitLocation = (double)this.lowerPanel.getDividerLocation() / (double)n;
        }
        this.lowerPanel.setDividerSize(0);
        this.detailPanel.setVisible(false);
        this.lowerPanel.repaint();
    }

    private void showLogTreePanel() {
        this.nameTreeAndMainPanelSplit.setDividerSize(this.dividerSize);
        this.nameTreeAndMainPanelSplit.setDividerLocation(this.lastLogTreePanelSplitLocation);
        this.logTreePanel.setVisible(true);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private void hideLogTreePanel() {
        int n = this.nameTreeAndMainPanelSplit.getWidth() - this.nameTreeAndMainPanelSplit.getDividerSize() - 1;
        if (n > 0) {
            this.lastLogTreePanelSplitLocation = (double)this.nameTreeAndMainPanelSplit.getDividerLocation() / (double)n;
        }
        this.nameTreeAndMainPanelSplit.setDividerSize(0);
        this.logTreePanel.setVisible(false);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private JToolBar createDockwindowToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        AbstractAction abstractAction = new AbstractAction("Pause"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.setPaused(!LogPanel.this.isPaused());
            }
        };
        abstractAction.putValue("MnemonicKey", new Integer(80));
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        abstractAction.putValue("ShortDescription", "Halts the display, while still allowing events to stream in the background");
        abstractAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        final SmallToggleButton smallToggleButton = new SmallToggleButton(abstractAction);
        smallToggleButton.setText("");
        smallToggleButton.getModel().setSelected(this.isPaused());
        this.addPropertyChangeListener("paused", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                smallToggleButton.getModel().setSelected(LogPanel.this.isPaused());
            }
        });
        jToolBar.add(smallToggleButton);
        AbstractAction abstractAction2 = new AbstractAction(""){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.showPreferences();
            }
        };
        abstractAction2.putValue("ShortDescription", "Define preferences...");
        abstractAction2.putValue("SmallIcon", ChainsawIcons.ICON_PREFERENCES);
        jToolBar.add(new SmallButton(abstractAction2));
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.toggleLogTreeVisible();
            }
        };
        abstractAction3.putValue("ShortDescription", "Toggles the Logger Tree Pane");
        abstractAction3.putValue("enabled", Boolean.TRUE);
        abstractAction3.putValue("MnemonicKey", new Integer(84));
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
        abstractAction3.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        final SmallToggleButton smallToggleButton2 = new SmallToggleButton(abstractAction3);
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                smallToggleButton2.setSelected(LogPanel.this.preferenceModel.isLogTreePanelVisible());
            }
        });
        smallToggleButton2.setSelected(this.isLogTreeVisible());
        jToolBar.add(smallToggleButton2);
        jToolBar.addSeparator();
        AbstractAction abstractAction4 = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.clearModel();
            }
        };
        abstractAction4.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        abstractAction4.putValue("ShortDescription", "Removes all the events from the current view");
        SmallButton smallButton = new SmallButton(abstractAction4);
        smallButton.getInputMap(2).put(KeyStroke.getKeyStroke(8, 2), abstractAction4.getValue("Name"));
        smallButton.getActionMap().put(abstractAction4.getValue("Name"), abstractAction4);
        smallButton.setText("");
        jToolBar.add(smallButton);
        jToolBar.addSeparator();
        AbstractAction abstractAction5 = new AbstractAction("Toggles Scroll to Bottom"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.toggleScrollToBottom();
            }
        };
        abstractAction5.putValue("ShortDescription", "Toggles Scroll to Bottom");
        abstractAction5.putValue("enabled", Boolean.TRUE);
        abstractAction5.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        final SmallToggleButton smallToggleButton3 = new SmallToggleButton(abstractAction5);
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                smallToggleButton3.setSelected(LogPanel.this.preferenceModel.isScrollToBottom());
            }
        });
        smallToggleButton3.getInputMap(2).put(KeyStroke.getKeyStroke(66, 2), abstractAction5.getValue("Name"));
        smallToggleButton3.getActionMap().put(abstractAction5.getValue("Name"), abstractAction5);
        smallToggleButton3.setSelected(this.isScrollToBottom());
        smallToggleButton3.setText("");
        jToolBar.add(smallToggleButton3);
        jToolBar.addSeparator();
        this.findField = new JTextField();
        this.findField.addKeyListener(new ExpressionRuleContext(this.filterModel, this.findField));
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.findNext();
            }
        };
        abstractAction6.putValue("Name", "Find next");
        abstractAction6.putValue("ShortDescription", "Find the next occurrence of the rule from the current row");
        abstractAction6.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DOWN));
        SmallButton smallButton2 = new SmallButton(abstractAction6);
        smallButton2.setAction(abstractAction6);
        smallButton2.setText("");
        smallButton2.getActionMap().put(abstractAction6.getValue("Name"), abstractAction6);
        smallButton2.getInputMap(2).put(KeyStroke.getKeyStroke("F3"), abstractAction6.getValue("Name"));
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.findPrevious();
            }
        };
        abstractAction7.putValue("Name", "Find previous");
        abstractAction7.putValue("ShortDescription", "Find the previous occurrence of the rule from the current row");
        abstractAction7.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UP));
        SmallButton smallButton3 = new SmallButton(abstractAction7);
        smallButton3.setAction(abstractAction7);
        smallButton3.setText("");
        smallButton3.getActionMap().put(abstractAction7.getValue("Name"), abstractAction7);
        smallButton3.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), abstractAction7.getValue("Name"));
        Dimension dimension = new Dimension(170, 22);
        Dimension dimension2 = new Dimension(175, 30);
        this.findPanel.setPreferredSize(dimension2);
        this.findPanel.setMaximumSize(dimension2);
        this.findPanel.setMinimumSize(dimension2);
        this.findField.setPreferredSize(dimension);
        this.findField.setMaximumSize(dimension);
        this.findField.setMinimumSize(dimension);
        this.findPanel.setAlignmentY(0.5f);
        this.findField.setAlignmentY(0.5f);
        jToolBar.add(this.findPanel);
        jToolBar.add(smallButton2);
        jToolBar.add(smallButton3);
        jToolBar.addSeparator();
        AbstractAction abstractAction8 = new AbstractAction("", ChainsawIcons.ICON_DOCK){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel.this.dock();
            }
        };
        abstractAction8.putValue("ShortDescription", "Docks this window back with the main Chainsaw window");
        SmallButton smallButton4 = new SmallButton(abstractAction8);
        jToolBar.add(smallButton4);
        return jToolBar;
    }

    private void updateStatusBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogPanel.this.statusBar.setSelectedLine(LogPanel.this.table.getSelectedRow() + 1, LogPanel.this.tableModel.getRowCount(), LogPanel.this.tableModel.size());
            }
        });
    }

    public void setDetailPaneConversionPattern(String string) {
        String string2 = this.getDetailPaneConversionPattern();
        ((EventDetailLayout)this.detailLayout).setConversionPattern(string);
        this.firePropertyChange("detailPaneConversionPattern", string2, this.getDetailPaneConversionPattern());
    }

    private String getDetailPaneConversionPattern() {
        return ((EventDetailLayout)this.detailLayout).getConversionPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearModel() {
        this.tableModel.clearModel();
        JEditorPane jEditorPane = this.detail;
        synchronized (jEditorPane) {
            this.detailPaneUpdater.setSelectedRow(-1);
            this.detail.notify();
        }
        this.statusBar.setNothingSelected();
    }

    public void findNext() {
        this.updateRule(this.findField.getText());
        if (this.findRule != null) {
            try {
                int n = this.tableModel.find(this.findRule, this.table.getSelectedRow() + 1, true);
                if (n > -1) {
                    this.table.scrollToRow(n, this.table.columnAtPoint(this.table.getVisibleRect().getLocation()));
                    this.findField.setToolTipText("Enter an expression");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.findField.setToolTipText(illegalArgumentException.getMessage());
                this.colorizer.setFindRule(null);
            }
        }
    }

    public void findPrevious() {
        this.updateRule(this.findField.getText());
        if (this.findRule != null) {
            try {
                int n = this.tableModel.find(this.findRule, this.table.getSelectedRow() - 1, false);
                if (n > -1) {
                    this.table.scrollToRow(n, this.table.columnAtPoint(this.table.getVisibleRect().getLocation()));
                    this.findField.setToolTipText("Enter an expression");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.findField.setToolTipText(illegalArgumentException.getMessage());
            }
        }
    }

    private void dock() {
        int n = this.table.getSelectedRow();
        this.setDocked(true);
        this.undockedFrame.setVisible(false);
        this.removeAll();
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(true);
        this.dockingAction.putValue("Name", "Undock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_UNDOCK);
        if (n > -1) {
            this.table.scrollToRow(n, this.table.columnAtPoint(this.table.getVisibleRect().getLocation()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveColumnSettings() {
        block16: {
            ObjectOutputStream objectOutputStream = null;
            File file = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.getIdentifier() + COLUMNS_EXTENSION));
            LogLog.debug("writing columns to file: " + file);
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                if (tableColumn.getModelIndex() < ChainsawColumns.getColumnsNames().size()) {
                    objectOutputStream.writeObject(new TableColumnData((String)tableColumn.getHeaderValue(), tableColumn.getModelIndex(), tableColumn.getWidth()));
                    continue;
                }
                LogLog.debug("Not saving col ' " + tableColumn.getHeaderValue() + "' not part of standard columns");
            }
            objectOutputStream.flush();
            Object var6_7 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block16;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block16;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    Object var6_8 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break block16;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_9 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveColorSettings() {
        block14: {
            ObjectOutputStream objectOutputStream = null;
            File file = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.getIdentifier() + COLORS_EXTENSION));
            LogLog.debug("writing colors to file: " + file);
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(this.colorizer.getRules());
            objectOutputStream.flush();
            Object var4_5 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block14;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    Object var4_6 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var4_7 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumnSettings(File file) {
        if (file.exists()) {
            ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
            TableColumnData tableColumnData = null;
            ObjectInputStream objectInputStream = null;
            try {
                IOException iOException2;
                Object var7_10;
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    while (true) {
                        tableColumnData = (TableColumnData)objectInputStream.readObject();
                        TableColumn tableColumn = new TableColumn(tableColumnData.getIndex(), tableColumnData.getWidth());
                        tableColumn.setHeaderValue(tableColumnData.getColName());
                        arrayList.add(tableColumn);
                    }
                }
                catch (EOFException eOFException) {
                    var7_10 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                    var7_10 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    var7_10 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            if (arrayList.size() > 0) {
                for (int i = tableColumnModel.getColumnCount() - 1; i > -1; --i) {
                    tableColumnModel.removeColumn(tableColumnModel.getColumn(i));
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    tableColumnModel.addColumn((TableColumn)iterator.next());
                }
            }
        }
    }

    private void loadDefaultColumnSettings(LoadSettingsEvent loadSettingsEvent) {
        Object object;
        Object object2;
        int n;
        String string = loadSettingsEvent.getSetting(TABLE_COLUMN_ORDER);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        HashMap<String, TableColumn> hashMap = new HashMap<String, TableColumn>();
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            hashMap.put(this.table.getColumnName(n), tableColumnModel.getColumn(n));
        }
        n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        while (stringTokenizer.hasMoreElements()) {
            object2 = (String)stringTokenizer.nextElement();
            object = (TableColumn)hashMap.get(object2);
            if (object == null) continue;
            arrayList.add((TableColumn)object);
            this.table.removeColumn((TableColumn)object);
        }
        while (tableColumnModel.getColumnCount() > 0) {
            object2 = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)object2);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (TableColumn)object2.next();
            this.table.addColumn((TableColumn)object);
        }
        object2 = loadSettingsEvent.getSetting(TABLE_COLUMN_WIDTHS);
        stringTokenizer = new StringTokenizer((String)object2, ",");
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            object = (String)stringTokenizer.nextElement();
            try {
                int n2 = Integer.parseInt((String)object);
                if (n > tableColumnModel.getColumnCount() - 1) {
                    LogLog.warn("loadsettings - failed attempt to set width for index " + n + ", width " + (String)object);
                } else {
                    tableColumnModel.getColumn(n).setPreferredWidth(n2);
                }
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("Error decoding a Table width", numberFormatException);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogPanel.this.repaint();
            }
        });
    }

    public JTextField getFindTextField() {
        return this.findField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadColorSettings(File file) {
        if (!file.exists()) return;
        ObjectInputStream objectInputStream = null;
        objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Map map = (Map)objectInputStream.readObject();
        this.colorizer.setRules(map);
        Object var5_7 = null;
        if (objectInputStream == null) return;
        try {
            objectInputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (EOFException eOFException) {
                Object var5_8 = null;
                if (objectInputStream == null) return;
                try {
                    objectInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var5_9 = null;
                if (objectInputStream == null) return;
                try {
                    objectInputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                Object var5_10 = null;
                if (objectInputStream == null) return;
                try {
                    objectInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (objectInputStream == null) throw throwable;
            try {
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    private int getMaxColumnWidth(int n) {
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        int n2 = fontMetrics.stringWidth("  " + this.table.getColumnName(n) + "  ") + 2 * this.table.getColumnModel().getColumnMargin();
        int n3 = this.tableModel.getRowCount();
        for (int i = 0; i < n3; ++i) {
            Component component = this.renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(i, n), false, false, i, n);
            if (!(component instanceof JLabel)) continue;
            n2 = Math.max(n2, fontMetrics.stringWidth(((JLabel)component).getText()));
        }
        return n2 + 5;
    }

    private void updateOtherModels(ChainsawEventBatchEntry chainsawEventBatchEntry) {
        LoggingEvent loggingEvent = chainsawEventBatchEntry.getEvent();
        this.tableModel.addLoggerName(loggingEvent.getLoggerName());
        this.filterModel.processNewLoggingEvent(loggingEvent);
    }

    private void doSearch(String string) {
        Rule rule;
        int n;
        int n2 = this.table.getSelectedRow() + 1;
        if (n2 >= this.tableModel.size()) {
            n2 = 0;
        }
        if ((n = this.tableModel.find(rule = PartialTextMatchRule.getRule("MSG", string), n2, true)) == -1) {
            JOptionPane.showMessageDialog(null, "No matches found.", "Search results", 1);
        } else {
            this.table.changeSelection(n, 2, false, false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DetailPaneUpdater
    implements PropertyChangeListener {
        private int selectedRow = -1;

        private DetailPaneUpdater() {
        }

        private void setSelectedRow(int n) {
            this.selectedRow = n;
            this.updateDetailPane();
        }

        private void updateDetailPane() {
            Object object;
            if (!LogPanel.this.detail.isVisible()) {
                return;
            }
            LoggingEvent loggingEvent = null;
            if (this.selectedRow != -1 && (loggingEvent = LogPanel.this.tableModel.getRow(this.selectedRow)) != null) {
                object = new StringBuffer();
                ((StringBuffer)object).append(LogPanel.this.detailLayout.getHeader()).append(LogPanel.this.detailLayout.format(loggingEvent)).append(LogPanel.this.detailLayout.getFooter());
                if (((StringBuffer)object).length() > 0) {
                    try {
                        Document document = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                        LogPanel.this.detail.getEditorKit().read(new StringReader(((StringBuffer)object).toString()), document, 0);
                        SwingUtilities.invokeLater(new Runnable(this, document){
                            private final /* synthetic */ Document val$doc;
                            private final /* synthetic */ DetailPaneUpdater this$1;
                            {
                                this.this$1 = detailPaneUpdater;
                                this.val$doc = document;
                            }

                            public void run() {
                                LogPanel.access$1400(DetailPaneUpdater.access$3600(this.this$1)).setDocument(this.val$doc);
                                LogPanel.access$1400(DetailPaneUpdater.access$3600(this.this$1)).setCaretPosition(0);
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (loggingEvent == null) {
                try {
                    object = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                    LogPanel.this.detail.getEditorKit().read(new StringReader("<html>Nothing selected</html>"), (Document)object, 0);
                    SwingUtilities.invokeLater(new Runnable(this, (Document)object){
                        private final /* synthetic */ Document val$doc;
                        private final /* synthetic */ DetailPaneUpdater this$1;
                        {
                            this.this$1 = detailPaneUpdater;
                            this.val$doc = document;
                        }

                        public void run() {
                            LogPanel.access$1400(DetailPaneUpdater.access$3600(this.this$1)).setDocument(this.val$doc);
                            LogPanel.access$1400(DetailPaneUpdater.access$3600(this.this$1)).setCaretPosition(0);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ DetailPaneUpdater this$1;
                {
                    this.this$1 = detailPaneUpdater;
                }

                public void run() {
                    DetailPaneUpdater.access$2300(this.this$1);
                }
            });
        }

        static /* synthetic */ LogPanel access$3600(DetailPaneUpdater detailPaneUpdater) {
            return detailPaneUpdater.LogPanel.this;
        }
    }

    private class ChainsawTableColumnModelListener
    implements TableColumnModelListener {
        private ChainsawTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            Enumeration<TableColumn> enumeration = LogPanel.this.table.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                if (tableColumn.getModelIndex() + 1 == 7) {
                    tableColumn.setCellEditor(LogPanel.this.throwableRenderPanel);
                }
                if (tableColumn.getModelIndex() <= 0) continue;
                LogPanel.this.preferenceModel.setColumnVisible(tableColumn.getHeaderValue().toString(), true);
            }
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            LogPanel.this.table.updateSortedColumn();
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            LogPanel.this.table.updateSortedColumn();
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class TableColumnData
    implements Serializable {
        static final long serialVersionUID = 5350440293110513986L;
        private String colName;
        private int index;
        private int width;

        public TableColumnData(String string, int n, int n2) {
            this.colName = string;
            this.index = n;
            this.width = n2;
        }

        public String getColName() {
            return this.colName;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWidth() {
            return this.width;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.colName = (String)objectInputStream.readObject();
            this.index = objectInputStream.readInt();
            this.width = objectInputStream.readInt();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.colName);
            objectOutputStream.writeInt(this.index);
            objectOutputStream.writeInt(this.width);
        }
    }

    private final class TableColumnDetailMouseListener
    extends MouseMotionAdapter {
        private int currentRow = -1;

        private TableColumnDetailMouseListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            LogPanel.this.currentPoint = mouseEvent.getPoint();
            if (LogPanel.this.preferenceModel.isToolTips()) {
                int n = LogPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n == this.currentRow || n == -1) {
                    return;
                }
                this.currentRow = n;
                LoggingEvent loggingEvent = LogPanel.this.tableModel.getRow(this.currentRow);
                if (loggingEvent != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(LogPanel.this.detailLayout.getHeader()).append(LogPanel.this.detailLayout.format(loggingEvent)).append(LogPanel.this.detailLayout.getFooter());
                    LogPanel.this.table.setToolTipText(stringBuffer.toString());
                }
            } else {
                LogPanel.this.table.setToolTipText(null);
            }
        }
    }

    private final class DelayedFilterTextDocumentListener
    implements DocumentListener {
        private static final long CHECK_PERIOD = 1000L;
        private final JTextField filterText;
        private long lastTimeStamp = System.currentTimeMillis();
        private final Thread delayThread;
        private final String defaultToolTip;
        private String lastFilterText = null;

        private DelayedFilterTextDocumentListener(JTextField jTextField) {
            this.filterText = jTextField;
            this.defaultToolTip = jTextField.getToolTipText();
            this.delayThread = new Thread(new Runnable(this, jTextField){
                private final /* synthetic */ JTextField val$filterText;
                private final /* synthetic */ DelayedFilterTextDocumentListener this$1;
                {
                    this.this$1 = delayedFilterTextDocumentListener;
                    this.val$filterText = jTextField;
                }

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - DelayedFilterTextDocumentListener.access$3100(this.this$1) < 1000L || System.currentTimeMillis() - DelayedFilterTextDocumentListener.access$3100(this.this$1) >= 2000L || this.val$filterText == null || this.val$filterText.getText().equals(DelayedFilterTextDocumentListener.access$3200(this.this$1))) continue;
                        DelayedFilterTextDocumentListener.access$3202(this.this$1, this.val$filterText.getText());
                        DelayedFilterTextDocumentListener.access$3300(this.this$1);
                    }
                }
            });
            this.delayThread.setPriority(1);
            this.delayThread.start();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.notifyChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.notifyChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.notifyChange();
        }

        private void notifyChange() {
            this.lastTimeStamp = System.currentTimeMillis();
        }

        private void setFilter() {
            if (this.filterText.getText().equals("")) {
                LogPanel.this.ruleMediator.setRefinementRule(null);
                this.filterText.setToolTipText(this.defaultToolTip);
            } else {
                try {
                    LogPanel.this.ruleMediator.setRefinementRule(ExpressionRule.getRule(this.filterText.getText()));
                    this.filterText.setToolTipText(this.defaultToolTip);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.filterText.setToolTipText(illegalArgumentException.getMessage());
                }
            }
        }

        static /* synthetic */ long access$3100(DelayedFilterTextDocumentListener delayedFilterTextDocumentListener) {
            return delayedFilterTextDocumentListener.lastTimeStamp;
        }

        static /* synthetic */ String access$3200(DelayedFilterTextDocumentListener delayedFilterTextDocumentListener) {
            return delayedFilterTextDocumentListener.lastFilterText;
        }

        static /* synthetic */ String access$3202(DelayedFilterTextDocumentListener delayedFilterTextDocumentListener, String string) {
            delayedFilterTextDocumentListener.lastFilterText = string;
            return delayedFilterTextDocumentListener.lastFilterText;
        }

        static /* synthetic */ void access$3300(DelayedFilterTextDocumentListener delayedFilterTextDocumentListener) {
            delayedFilterTextDocumentListener.setFilter();
        }
    }
}

