/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.ColumnComparator;
import org.apache.log4j.chainsaw.CyclicBufferList;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.LoggerNameModel;
import org.apache.log4j.chainsaw.LoggerNameModelSupport;
import org.apache.log4j.chainsaw.NewKeyEvent;
import org.apache.log4j.chainsaw.NewKeyListener;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

class ChainsawCyclicBufferTableModel
extends AbstractTableModel
implements EventContainer,
PropertyChangeListener {
    private static final int DEFAULT_CAPACITY = 5000;
    private boolean cyclic = true;
    private int cyclicBufferSize = 5000;
    List unfilteredList;
    List filteredList;
    Set idSet = new HashSet(this.cyclicBufferSize);
    private boolean currentSortAscending;
    private int currentSortColumn;
    private EventListenerList eventListenerList = new EventListenerList();
    private List columnNames = new ArrayList(ChainsawColumns.getColumnsNames());
    private boolean sortEnabled = false;
    private boolean reachedCapacity = false;
    private LoggerNameModel loggerNameModelDelegate = new LoggerNameModelSupport();
    int uniqueRow;
    private Set uniquePropertyKeys = new HashSet();
    private Rule displayRule;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$EventCountListener;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$NewKeyListener;

    public ChainsawCyclicBufferTableModel(int n) {
        this.propertySupport.addPropertyChangeListener("cyclic", new ModelChanger());
        this.cyclicBufferSize = n;
        this.unfilteredList = new CyclicBufferList(n);
        this.filteredList = new CyclicBufferList(n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Rule) {
            this.reFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMatchingEvents(Rule rule) {
        ArrayList<LoggingEvent> arrayList = new ArrayList<LoggingEvent>();
        List list = this.unfilteredList;
        synchronized (list) {
            Iterator iterator = this.unfilteredList.iterator();
            while (iterator.hasNext()) {
                LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
                if (!rule.evaluate(loggingEvent)) continue;
                arrayList.add(loggingEvent);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reFilter() {
        List list = this.unfilteredList;
        synchronized (list) {
            int n = this.filteredList.size();
            try {
                this.filteredList.clear();
                Iterator iterator = this.unfilteredList.iterator();
                while (iterator.hasNext()) {
                    LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
                    if (this.displayRule != null && !this.displayRule.evaluate(loggingEvent)) continue;
                    this.filteredList.add(loggingEvent);
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(n){
                    private final /* synthetic */ int val$previousSize;
                    {
                        this.val$previousSize = n;
                    }

                    public void run() {
                        if (ChainsawCyclicBufferTableModel.this.filteredList.size() > 0) {
                            if (this.val$previousSize == ChainsawCyclicBufferTableModel.this.filteredList.size()) {
                                ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.filteredList.size() - 1);
                            } else if (this.val$previousSize > ChainsawCyclicBufferTableModel.this.filteredList.size()) {
                                ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.filteredList.size() - 1);
                                ChainsawCyclicBufferTableModel.this.fireTableRowsDeleted(ChainsawCyclicBufferTableModel.this.filteredList.size(), this.val$previousSize);
                            } else if (this.val$previousSize < ChainsawCyclicBufferTableModel.this.filteredList.size()) {
                                ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, Math.max(0, this.val$previousSize - 1));
                                ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(this.val$previousSize, ChainsawCyclicBufferTableModel.this.filteredList.size() - 1);
                            }
                        } else {
                            ChainsawCyclicBufferTableModel.this.fireTableDataChanged();
                        }
                        ChainsawCyclicBufferTableModel.this.notifyCountListeners();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(Rule rule, int n, boolean bl) {
        List list = this.filteredList;
        synchronized (list) {
            if (bl) {
                for (int i = n; i < this.filteredList.size(); ++i) {
                    if (!rule.evaluate((LoggingEvent)this.filteredList.get(i))) continue;
                    return i;
                }
            } else {
                for (int i = n; i > -1; --i) {
                    if (!rule.evaluate((LoggingEvent)this.filteredList.get(i))) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public void removeLoggerNameListener(LoggerNameListener loggerNameListener) {
        this.loggerNameModelDelegate.removeLoggerNameListener(loggerNameListener);
    }

    public boolean addLoggerName(String string) {
        return this.loggerNameModelDelegate.addLoggerName(string);
    }

    public void addLoggerNameListener(LoggerNameListener loggerNameListener) {
        this.loggerNameModelDelegate.addLoggerNameListener(loggerNameListener);
    }

    public Collection getLoggerNames() {
        return this.loggerNameModelDelegate.getLoggerNames();
    }

    public void addEventCountListener(EventCountListener eventCountListener) {
        this.eventListenerList.add(class$org$apache$log4j$chainsaw$EventCountListener == null ? (class$org$apache$log4j$chainsaw$EventCountListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.EventCountListener")) : class$org$apache$log4j$chainsaw$EventCountListener, eventCountListener);
    }

    public boolean isSortable(int n) {
        return true;
    }

    public void notifyCountListeners() {
        EventCountListener[] eventCountListenerArray = (EventCountListener[])this.eventListenerList.getListeners(class$org$apache$log4j$chainsaw$EventCountListener == null ? (class$org$apache$log4j$chainsaw$EventCountListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.EventCountListener")) : class$org$apache$log4j$chainsaw$EventCountListener);
        for (int i = 0; i < eventCountListenerArray.length; ++i) {
            eventCountListenerArray[i].eventCountChanged(this.filteredList.size(), this.unfilteredList.size());
        }
    }

    public void setDisplayRule(Rule rule) {
        if (this.displayRule != null) {
            this.displayRule.removePropertyChangeListener(this);
        }
        this.displayRule = rule;
        if (this.displayRule != null) {
            this.displayRule.addPropertyChangeListener(this);
        }
        this.reFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        if (this.sortEnabled && this.filteredList.size() > 0) {
            List list = this.filteredList;
            synchronized (list) {
                Collections.sort(this.filteredList, new ColumnComparator(this.getColumnName(this.currentSortColumn), this.currentSortColumn, this.currentSortAscending));
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, Math.max(ChainsawCyclicBufferTableModel.this.filteredList.size() - 1, 0));
                }
            });
        }
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void sortColumn(int n, boolean bl) {
        LogLog.debug("request to sort col=" + n);
        this.currentSortAscending = bl;
        this.currentSortColumn = n;
        this.sortEnabled = true;
        this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModel() {
        this.reachedCapacity = false;
        List list = this.unfilteredList;
        synchronized (list) {
            this.unfilteredList.clear();
            this.filteredList.clear();
            this.idSet.clear();
            this.uniqueRow = 0;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChainsawCyclicBufferTableModel.this.fireTableDataChanged();
            }
        });
        this.notifyCountListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllEvents() {
        ArrayList arrayList = new ArrayList(this.unfilteredList.size());
        List list = this.unfilteredList;
        synchronized (list) {
            arrayList.addAll(this.unfilteredList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilteredEvents() {
        ArrayList arrayList = new ArrayList(this.filteredList.size());
        List list = this.filteredList;
        synchronized (list) {
            arrayList.addAll(this.filteredList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowIndex(LoggingEvent loggingEvent) {
        List list = this.filteredList;
        synchronized (list) {
            return this.filteredList.indexOf(loggingEvent);
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int n) {
        return this.columnNames.get(n).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEvent getRow(int n) {
        List list = this.filteredList;
        synchronized (list) {
            if (n < this.filteredList.size()) {
                return (LoggingEvent)this.filteredList.get(n);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        List list = this.filteredList;
        synchronized (list) {
            return this.filteredList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        LoggingEvent loggingEvent = null;
        Object object = this.filteredList;
        synchronized (object) {
            if (n < this.filteredList.size() && n > -1) {
                loggingEvent = (LoggingEvent)this.filteredList.get(n);
            }
        }
        if (loggingEvent == null) {
            return null;
        }
        object = null;
        if (loggingEvent.locationInformationExists()) {
            object = loggingEvent.getLocationInformation();
        }
        if (loggingEvent == null) {
            LogLog.error("Invalid rowindex=" + n);
            throw new NullPointerException("Invalid rowIndex=" + n);
        }
        switch (n2 + 1) {
            case 12: {
                String string = loggingEvent.getProperty("log4jid");
                if (string != null) {
                    return string;
                }
                return new Integer(n);
            }
            case 3: {
                return loggingEvent.getLevel();
            }
            case 1: {
                return loggingEvent.getLoggerName();
            }
            case 2: {
                return new Date(loggingEvent.getTimeStamp());
            }
            case 5: {
                return loggingEvent.getRenderedMessage();
            }
            case 6: {
                return loggingEvent.getNDC();
            }
            case 4: {
                return loggingEvent.getThreadName();
            }
            case 7: {
                return loggingEvent.getThrowableStrRep();
            }
            case 8: {
                return object == null || object != null && ((LocationInfo)object).getClassName().equals("?") ? "" : ((LocationInfo)object).getClassName();
            }
            case 10: {
                return object == null || object != null && ((LocationInfo)object).getFileName().equals("?") ? "" : ((LocationInfo)object).getFileName();
            }
            case 11: {
                return object == null || object != null && ((LocationInfo)object).getLineNumber().equals("?") ? "" : ((LocationInfo)object).getLineNumber();
            }
            case 9: {
                return object == null || object != null && ((LocationInfo)object).getMethodName().equals("?") ? "" : ((LocationInfo)object).getMethodName();
            }
        }
        if (n2 <= this.columnNames.size()) {
            return loggingEvent.getProperty(this.columnNames.get(n2).toString());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddRow(LoggingEvent loggingEvent, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        Object object = loggingEvent.getProperty("log4jid");
        if (object == null) {
            object = new Integer(++this.uniqueRow);
            loggingEvent.setProperty("log4jid", object.toString());
        }
        if (this.idSet.contains(object)) {
            return false;
        }
        this.idSet.add(object);
        this.unfilteredList.add(loggingEvent);
        if (this.displayRule == null || this.displayRule.evaluate(loggingEvent)) {
            List list = this.filteredList;
            synchronized (list) {
                this.filteredList.add(loggingEvent);
                bl3 = true;
            }
        }
        if (bl2 = this.uniquePropertyKeys.addAll(loggingEvent.getPropertyKeySet())) {
            Iterator iterator = loggingEvent.getPropertyKeySet().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.columnNames.contains(e) || "log4jid".equalsIgnoreCase(e.toString())) continue;
                this.columnNames.add(e);
                LogLog.debug("Adding col '" + e + "', columNames=" + this.columnNames);
                this.fireNewKeyColumnAdded(new NewKeyEvent(this, this.columnNames.indexOf(e), e, loggingEvent.getProperty(e.toString())));
            }
        }
        if (!bl) {
            int n = this.getLastAdded();
            this.fireTableEvent(n, n, 1);
        }
        return bl3;
    }

    public int getLastAdded() {
        int n = 0;
        n = this.cyclic ? ((CyclicBufferList)this.filteredList).getLast() : this.filteredList.size();
        return n;
    }

    public void fireTableEvent(final int n, final int n2, final int n3) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ChainsawCyclicBufferTableModel.this.cyclic) {
                    if (!ChainsawCyclicBufferTableModel.this.reachedCapacity) {
                        if (n + n3 < ChainsawCyclicBufferTableModel.this.cyclicBufferSize) {
                            ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(n, n2);
                        } else {
                            ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(n, ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            ChainsawCyclicBufferTableModel.this.reachedCapacity = true;
                        }
                    } else {
                        ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                    }
                } else {
                    ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(n, n2);
                }
            }
        });
    }

    private void fireNewKeyColumnAdded(NewKeyEvent newKeyEvent) {
        NewKeyListener[] newKeyListenerArray = (NewKeyListener[])this.eventListenerList.getListeners(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener);
        for (int i = 0; i < newKeyListenerArray.length; ++i) {
            NewKeyListener newKeyListener = newKeyListenerArray[i];
            newKeyListener.newKeyAdded(newKeyEvent);
        }
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public int getMaxSize() {
        return this.cyclicBufferSize;
    }

    public void addNewKeyListener(NewKeyListener newKeyListener) {
        this.eventListenerList.add(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener, newKeyListener);
    }

    public void removeNewKeyListener(NewKeyListener newKeyListener) {
        this.eventListenerList.remove(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener, newKeyListener);
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2 + 1) {
            case 7: {
                return true;
            }
        }
        return super.isCellEditable(n, n2);
    }

    public void setCyclic(boolean bl) {
        if (this.cyclic == bl) {
            return;
        }
        boolean bl2 = this.cyclic;
        this.cyclic = bl;
        this.propertySupport.firePropertyChange("cyclic", bl2, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public int size() {
        return this.unfilteredList.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$500(ChainsawCyclicBufferTableModel chainsawCyclicBufferTableModel) {
        chainsawCyclicBufferTableModel.reFilter();
    }

    private class ModelChanger
    implements PropertyChangeListener {
        private ModelChanger() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ ModelChanger this$1;
                {
                    this.this$1 = modelChanger;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProgressMonitor progressMonitor = null;
                    int n = 0;
                    try {
                        List list = ModelChanger.access$400((ModelChanger)this.this$1).unfilteredList;
                        synchronized (list) {
                            progressMonitor = new ProgressMonitor(null, "Switching models...", "Transferring between data structures, please wait...", 0, ModelChanger.access$400((ModelChanger)this.this$1).unfilteredList.size() + 1);
                            progressMonitor.setMillisToDecideToPopup(250);
                            progressMonitor.setMillisToPopup(100);
                            LogLog.debug("Changing Model, isCyclic is now " + ModelChanger.access$400(this.this$1).isCyclic());
                            AbstractList abstractList = null;
                            AbstractList abstractList2 = null;
                            HashSet<Object> hashSet = null;
                            hashSet = new HashSet<Object>(ChainsawCyclicBufferTableModel.access$300(ModelChanger.access$400(this.this$1)));
                            if (ModelChanger.access$400(this.this$1).isCyclic()) {
                                abstractList = new CyclicBufferList(ChainsawCyclicBufferTableModel.access$300(ModelChanger.access$400(this.this$1)));
                                abstractList2 = new CyclicBufferList(ChainsawCyclicBufferTableModel.access$300(ModelChanger.access$400(this.this$1)));
                            } else {
                                abstractList = new ArrayList<E>(ChainsawCyclicBufferTableModel.access$300(ModelChanger.access$400(this.this$1)));
                                abstractList2 = new ArrayList<E>(ChainsawCyclicBufferTableModel.access$300(ModelChanger.access$400(this.this$1)));
                            }
                            int n2 = 0;
                            Iterator<E> iterator = ModelChanger.access$400((ModelChanger)this.this$1).unfilteredList.iterator();
                            while (iterator.hasNext()) {
                                LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
                                abstractList.add(loggingEvent);
                                String string = loggingEvent.getProperty(loggingEvent.getProperty("log4jid"));
                                if (string != null) {
                                    hashSet.add(string);
                                } else {
                                    hashSet.add(new Integer(n2++));
                                }
                                progressMonitor.setProgress(n++);
                            }
                            ModelChanger.access$400((ModelChanger)this.this$1).unfilteredList = abstractList;
                            ModelChanger.access$400((ModelChanger)this.this$1).filteredList = abstractList2;
                            ModelChanger.access$400((ModelChanger)this.this$1).idSet = hashSet;
                        }
                        progressMonitor.setNote("Refiltering...");
                        ChainsawCyclicBufferTableModel.access$500(ModelChanger.access$400(this.this$1));
                        progressMonitor.setProgress(n++);
                    }
                    finally {
                        progressMonitor.close();
                    }
                    LogLog.debug("Model Change completed");
                }
            });
            thread.setPriority(2);
            thread.start();
        }

        static /* synthetic */ ChainsawCyclicBufferTableModel access$400(ModelChanger modelChanger) {
            return modelChanger.ChainsawCyclicBufferTableModel.this;
        }
    }
}

