/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;

public abstract class AbstractPreferencePanel
extends JPanel {
    private final JLabel titleLabel = new JLabel("Selected Pref Panel");
    private final JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
    private final JPanel selectedPrefPanel = new JPanel(new BorderLayout(0, 3));
    private final JButton okButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private ActionListener okCancelListener;
    private Component currentlyDisplayedPanel = null;
    private final JTree prefTree = new JTree();

    protected void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.prefTree.setModel(this.createTreeModel());
        this.prefTree.setRootVisible(false);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(ChainsawIcons.ICON_PREFERENCES);
        this.prefTree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.prefTree);
        jScrollPane.setPreferredSize(new Dimension(200, 240));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setBorder(BorderFactory.createEtchedBorder());
        this.titleLabel.setBackground(Color.white);
        this.titleLabel.setOpaque(true);
        this.selectedPrefPanel.add((Component)this.titleLabel, "North");
        this.mainPanel.add((Component)jScrollPane, "West");
        this.mainPanel.add((Component)this.selectedPrefPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.okButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.cancelButton);
        this.add((Component)box, "South");
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.prefTree.setSelectionModel(defaultTreeSelectionModel);
        this.prefTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                AbstractPreferencePanel.this.setDisplayedPrefPanel((JComponent)defaultMutableTreeNode.getUserObject());
            }
        });
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.prefTree.getModel().getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        this.prefTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    protected abstract TreeModel createTreeModel();

    protected void setDisplayedPrefPanel(JComponent jComponent) {
        if (this.currentlyDisplayedPanel != null) {
            this.selectedPrefPanel.remove(this.currentlyDisplayedPanel);
        }
        this.selectedPrefPanel.add((Component)jComponent, "Center");
        this.currentlyDisplayedPanel = jComponent;
        String string = jComponent.toString();
        this.titleLabel.setText(string);
        this.selectedPrefPanel.revalidate();
        this.selectedPrefPanel.repaint();
    }

    public void notifyOfLookAndFeelChange() {
        SwingUtilities.updateComponentTreeUI(this);
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.prefTree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof Component)) continue;
            Component component = (Component)defaultMutableTreeNode.getUserObject();
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public void setOkCancelActionListener(ActionListener actionListener) {
        this.okCancelListener = actionListener;
    }

    public void hidePanel() {
        if (this.okCancelListener != null) {
            this.okCancelListener.actionPerformed(null);
        }
    }

    protected final JButton getCancelButton() {
        return this.cancelButton;
    }

    protected final JButton getOkButton() {
        return this.okButton;
    }
}

