/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

public class Level {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int TRACE_INT = 5000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF", 0);
    public static final Level FATAL = new Level(50000, "FATAL", 0);
    public static final Level ERROR = new Level(40000, "ERROR", 3);
    public static final Level WARN = new Level(30000, "WARN", 4);
    public static final Level INFO = new Level(20000, "INFO", 6);
    public static final Level DEBUG = new Level(10000, "DEBUG", 7);
    public static final Level TRACE = new Level(5000, "TRACE", 7);
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL", 7);
    int level;
    String levelStr;
    int syslogEquivalent;

    protected Level(int level, String levelStr, int syslogEquivalent) {
        this.level = level;
        this.levelStr = levelStr;
        this.syslogEquivalent = syslogEquivalent;
    }

    public static Level toLevel(String sArg) {
        return Level.toLevel(sArg, DEBUG);
    }

    public static Level toLevel(int val) {
        return Level.toLevel(val, DEBUG);
    }

    public boolean equals(Object o) {
        if (o instanceof Level) {
            Level r = (Level)o;
            return this.level == r.level;
        }
        return false;
    }

    public int hashCode() {
        return this.level;
    }

    public final int getSyslogEquivalent() {
        return this.syslogEquivalent;
    }

    public boolean isGreaterOrEqual(Level r) {
        return this.level >= r.level;
    }

    public static Level[] getAllPossiblePriorities() {
        return new Level[]{FATAL, ERROR, WARN, INFO, DEBUG, TRACE};
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.level;
    }

    public static Level toLevel(int val, Level defaultLevel) {
        switch (val) {
            case -2147483648: {
                return ALL;
            }
            case 5000: {
                return TRACE;
            }
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        return defaultLevel;
    }

    public static Level toLevel(String sArg, Level defaultLevel) {
        if (sArg == null) {
            return defaultLevel;
        }
        String s = sArg.toUpperCase();
        if (s.equals("ALL")) {
            return ALL;
        }
        if (s.equals("TRACE")) {
            return TRACE;
        }
        if (s.equals("DEBUG")) {
            return DEBUG;
        }
        if (s.equals("INFO")) {
            return INFO;
        }
        if (s.equals("WARN")) {
            return WARN;
        }
        if (s.equals("ERROR")) {
            return ERROR;
        }
        if (s.equals("FATAL")) {
            return FATAL;
        }
        if (s.equals("OFF")) {
            return OFF;
        }
        return defaultLevel;
    }
}

