/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    static final String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    public static final String TITLE_OPTION = "Title";
    protected static final int BUF_SIZE = 256;
    protected static final int MAX_CAPACITY = 1024;
    private StringBuffer sbuf = new StringBuffer(256);
    boolean locationInfo = false;
    String title = "Log4J Log Messages";

    public HTMLLayout() {
        this.ignoresThrowable = false;
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContentType() {
        return "text/html";
    }

    public void activateOptions() {
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        String[] s;
        output.write(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
        output.write("<td>");
        output.write(Long.toString(event.getTimeStamp() - LoggingEvent.getStartTime()));
        output.write("</td>" + Layout.LINE_SEP);
        output.write("<td title=\"" + event.getThreadName() + " thread\">");
        Transform.escapeTags(event.getThreadName(), output);
        output.write("</td>" + Layout.LINE_SEP);
        output.write("<td title=\"Level\">");
        if (event.getLevel().equals(Level.DEBUG)) {
            output.write("<font color=\"#339933\">");
            output.write(event.getLevel().toString());
            output.write("</font>");
        } else if (event.getLevel().isGreaterOrEqual(Level.WARN)) {
            output.write("<font color=\"#993300\"><strong>");
            output.write(event.getLevel().toString());
            output.write("</strong></font>");
        } else {
            output.write(event.getLevel().toString());
        }
        output.write("</td>" + Layout.LINE_SEP);
        output.write("<td title=\"" + event.getLoggerName() + " category\">");
        output.write(event.getLoggerName());
        output.write("</td>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            LocationInfo locInfo = event.getLocationInformation();
            output.write("<td>");
            Transform.escapeTags(locInfo.getFileName(), output);
            output.write(58);
            output.write(locInfo.getLineNumber());
            output.write("</td>" + Layout.LINE_SEP);
        }
        output.write("<td title=\"Message\">");
        Transform.escapeTags(event.getRenderedMessage(), output);
        output.write("</td>" + Layout.LINE_SEP);
        output.write("</tr>" + Layout.LINE_SEP);
        if (event.getNDC() != null) {
            output.write("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
            Transform.escapeTags(event.getNDC(), output);
            output.write("</td></tr>" + Layout.LINE_SEP);
        }
        if (!this.ignoresThrowable && (s = event.getThrowableStrRep()) != null) {
            output.write("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, output);
            output.write("</td></tr>" + Layout.LINE_SEP);
        }
    }

    void appendThrowableAsHTML(String[] s, Writer output) throws IOException {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            Transform.escapeTags(s[0], output);
            output.write(Layout.LINE_SEP);
            for (int i = 1; i < len; ++i) {
                output.write(TRACE_PREFIX);
                Transform.escapeTags(s[i], output);
                output.write(Layout.LINE_SEP);
            }
        }
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>" + Layout.LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr>" + Layout.LINE_SEP);
        sbuf.append("<th>Time</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Thread</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Level</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Category</th>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            sbuf.append("<th>File:Line</th>" + Layout.LINE_SEP);
        }
        sbuf.append("<th>Message</th>" + Layout.LINE_SEP);
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }

    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString();
    }
}

